/*
 * Decompiled with CFR 0.152.
 */
package herddb.utils;

import java.util.ArrayList;
import java.util.List;

public abstract class SystemInstrumentation {
    private static List<InstrumentationPointListener> listeners = null;

    private SystemInstrumentation() {
    }

    public static void addListener(InstrumentationPointListener l) {
        if (listeners == null) {
            listeners = new ArrayList<InstrumentationPointListener>();
        }
        listeners.add(l);
    }

    public static void instrumentationPoint(String crashpointid, Object ... args) {
        if (listeners != null) {
            for (InstrumentationPointListener listener : listeners) {
                try {
                    listener.accept(crashpointid, args);
                }
                catch (Throwable t) {
                    if (t instanceof RuntimeException) {
                        throw (RuntimeException)t;
                    }
                    throw new RuntimeException(t);
                }
            }
        }
    }

    public static void clear() {
        listeners = null;
    }

    public static interface InstrumentationPointListener {
        public void accept(String var1, Object ... var2) throws Exception;
    }

    public static abstract class SingleInstrumentationPointListener
    implements InstrumentationPointListener {
        private final String crashpointid;

        public SingleInstrumentationPointListener(String crashpointid) {
            this.crashpointid = crashpointid;
        }

        public abstract void acceptSingle(Object ... var1) throws Exception;

        @Override
        public final void accept(String crashpointid, Object ... args) throws Exception {
            if (crashpointid.equals(this.crashpointid)) {
                this.acceptSingle(args);
            }
        }
    }
}

