/*
 * Decompiled with CFR 0.152.
 */
package herddb.utils;

import com.sun.nio.file.ExtendedOpenOption;
import io.netty.util.internal.PlatformDependent;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.logging.Logger;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class OpenFileUtils {
    private static final Logger LOG = Logger.getLogger(OpenFileUtils.class.getName());

    public static FileChannel openFileChannelWithO_DIRECT(Path path, OpenOption ... options) throws IOException {
        OpenOption[] options2 = new OpenOption[options.length + 1];
        System.arraycopy(options, 0, options2, 0, options.length);
        options2[options2.length - 1] = ExtendedOpenOption.DIRECT;
        return FileChannel.open(path, options2);
    }

    public static long getBlockSize(Path p) throws IOException {
        return Files.getFileStore(p).getBlockSize();
    }

    public static boolean isO_DIRECT_Supported() {
        return true;
    }

    public static ByteBuffer alignedSlice(ByteBuffer buffer, int alignment) {
        return buffer.alignedSlice(alignment);
    }

    public static void releaseAlignedBuffer(ByteBuffer buffer) {
        PlatformDependent.freeDirectBuffer((ByteBuffer)buffer);
    }

    static {
        LOG.fine("This JVM is able to use O_DIRECT");
    }
}

