/*
 * Decompiled with CFR 0.152.
 */
package herddb.utils;

import herddb.utils.Bytes;
import herddb.utils.RawString;
import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import java.util.List;

public class ByteBufUtils {
    public static void writeArray(ByteBuf buffer, byte[] array) {
        ByteBufUtils.writeVInt(buffer, array.length);
        buffer.writeBytes(array);
    }

    public static void writeFloatArray(ByteBuf buffer, float[] array) {
        ByteBufUtils.writeVInt(buffer, array.length);
        for (float f : array) {
            buffer.writeFloat(f);
        }
    }

    public static void writeFloatArray(ByteBuf buffer, List<Number> array) {
        ByteBufUtils.writeVInt(buffer, array.size());
        for (Number f : array) {
            buffer.writeFloat(f.floatValue());
        }
    }

    public static void writeArray(ByteBuf buffer, Bytes array) {
        ByteBufUtils.writeVInt(buffer, array.getLength());
        buffer.writeBytes(array.getBuffer(), array.getOffset(), array.getLength());
    }

    public static void writeArray(ByteBuf buffer, byte[] array, int offset, int length) {
        ByteBufUtils.writeVInt(buffer, length);
        buffer.writeBytes(array, offset, length);
    }

    public static void writeString(ByteBuf buffer, String string) {
        ByteBufUtils.writeArray(buffer, string.getBytes(StandardCharsets.UTF_8));
    }

    public static void writeRawString(ByteBuf buffer, RawString string) {
        ByteBufUtils.writeArray(buffer, string.getData(), string.getOffset(), string.getLength());
    }

    public static byte[] readArray(ByteBuf buffer) {
        int len = ByteBufUtils.readVInt(buffer);
        byte[] array = new byte[len];
        buffer.readBytes(array);
        return array;
    }

    public static float[] readFloatArray(ByteBuf buffer) {
        int len = ByteBufUtils.readVInt(buffer);
        float[] array = new float[len];
        for (int i = 0; i < len; ++i) {
            array[i] = buffer.readFloat();
        }
        return array;
    }

    public static String readString(ByteBuf buffer) {
        int len = ByteBufUtils.readVInt(buffer);
        byte[] array = new byte[len];
        buffer.readBytes(array);
        return new String(array, StandardCharsets.UTF_8);
    }

    public static RawString readRawString(ByteBuf buffer) {
        int len = ByteBufUtils.readVInt(buffer);
        byte[] array = new byte[len];
        buffer.readBytes(array);
        return RawString.newPooledRawString(array, 0, len);
    }

    public static RawString readUnpooledRawString(ByteBuf buffer) {
        int len = ByteBufUtils.readVInt(buffer);
        byte[] array = new byte[len];
        buffer.readBytes(array);
        return RawString.newUnpooledRawString(array, 0, len);
    }

    public static void skipArray(ByteBuf buffer) {
        int len = ByteBufUtils.readVInt(buffer);
        buffer.skipBytes(len);
    }

    public static void writeVInt(ByteBuf buffer, int i) {
        if ((i & 0xFFFFFF80) != 0) {
            buffer.writeByte((int)((byte)(i & 0x7F | 0x80)));
            if (((i >>>= 7) & 0xFFFFFF80) != 0) {
                buffer.writeByte((int)((byte)(i & 0x7F | 0x80)));
                if (((i >>>= 7) & 0xFFFFFF80) != 0) {
                    buffer.writeByte((int)((byte)(i & 0x7F | 0x80)));
                    if (((i >>>= 7) & 0xFFFFFF80) != 0) {
                        buffer.writeByte((int)((byte)(i & 0x7F | 0x80)));
                        i >>>= 7;
                    }
                }
            }
        }
        buffer.writeByte((int)((byte)i));
    }

    public static int readVInt(ByteBuf buffer) {
        byte b = buffer.readByte();
        int i = b & 0x7F;
        if ((b & 0x80) != 0) {
            b = buffer.readByte();
            i |= (b & 0x7F) << 7;
            if ((b & 0x80) != 0) {
                b = buffer.readByte();
                i |= (b & 0x7F) << 14;
                if ((b & 0x80) != 0) {
                    b = buffer.readByte();
                    i |= (b & 0x7F) << 21;
                    if ((b & 0x80) != 0) {
                        b = buffer.readByte();
                        i |= (b & 0x7F) << 28;
                    }
                }
            }
        }
        return i;
    }

    public static void writeZInt(ByteBuf buffer, int i) {
        ByteBufUtils.writeVInt(buffer, ByteBufUtils.zigZagEncode(i));
    }

    public static int readZInt(ByteBuf buffer) {
        return ByteBufUtils.zigZagDecode(ByteBufUtils.readVInt(buffer));
    }

    public static void writeVLong(ByteBuf buffer, long i) {
        if (i < 0L) {
            throw new IllegalArgumentException("cannot write negative vLong (got: " + i + ")");
        }
        ByteBufUtils.writeSignedVLong(buffer, i);
    }

    private static void writeSignedVLong(ByteBuf buffer, long i) {
        while ((i & 0xFFFFFFFFFFFFFF80L) != 0L) {
            buffer.writeByte((int)((byte)(i & 0x7FL | 0x80L)));
            i >>>= 7;
        }
        buffer.writeByte((int)((byte)i));
    }

    public static long readVLong(ByteBuf buffer) {
        return ByteBufUtils.readVLong(buffer, false);
    }

    private static long readVLong(ByteBuf buffer, boolean allowNegative) {
        byte b = buffer.readByte();
        if (b >= 0) {
            return b;
        }
        long i = (long)b & 0x7FL;
        b = buffer.readByte();
        i |= ((long)b & 0x7FL) << 7;
        if (b >= 0) {
            return i;
        }
        b = buffer.readByte();
        i |= ((long)b & 0x7FL) << 14;
        if (b >= 0) {
            return i;
        }
        b = buffer.readByte();
        i |= ((long)b & 0x7FL) << 21;
        if (b >= 0) {
            return i;
        }
        b = buffer.readByte();
        i |= ((long)b & 0x7FL) << 28;
        if (b >= 0) {
            return i;
        }
        b = buffer.readByte();
        i |= ((long)b & 0x7FL) << 35;
        if (b >= 0) {
            return i;
        }
        b = buffer.readByte();
        i |= ((long)b & 0x7FL) << 42;
        if (b >= 0) {
            return i;
        }
        b = buffer.readByte();
        i |= ((long)b & 0x7FL) << 49;
        if (b >= 0) {
            return i;
        }
        b = buffer.readByte();
        i |= ((long)b & 0x7FL) << 56;
        if (b >= 0) {
            return i;
        }
        if (allowNegative) {
            b = buffer.readByte();
            i |= ((long)b & 0x7FL) << 63;
            if (b == 0 || b == 1) {
                return i;
            }
            throw new IllegalArgumentException("Invalid vLong detected (more than 64 bits)");
        }
        throw new IllegalArgumentException("Invalid vLong detected (negative values disallowed)");
    }

    public static void writeZLong(ByteBuf buffer, long i) {
        ByteBufUtils.writeVLong(buffer, ByteBufUtils.zigZagEncode(i));
    }

    public static long readZLong(ByteBuf buffer) {
        return ByteBufUtils.zigZagDecode(ByteBufUtils.readVLong(buffer));
    }

    public static void writeDouble(ByteBuf buffer, double i) {
        buffer.writeLong(Double.doubleToLongBits(i));
    }

    public static double readDouble(ByteBuf buffer) {
        return Double.longBitsToDouble(buffer.readLong());
    }

    private static int zigZagEncode(int i) {
        return i >> 31 ^ i << 1;
    }

    private static long zigZagEncode(long l) {
        return l >> 63 ^ l << 1;
    }

    private static int zigZagDecode(int i) {
        return i >>> 1 ^ -(i & 1);
    }

    private static long zigZagDecode(long l) {
        return l >>> 1 ^ -(l & 1L);
    }
}

