/*
 * Decompiled with CFR 0.152.
 */
package herddb.utils;

import herddb.utils.DeleteFileVisitor;
import herddb.utils.SystemProperties;
import io.netty.util.internal.PlatformDependent;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;

public class FileUtils {
    private static final boolean USE_DIRECT_BUFFER = SystemProperties.getBooleanSystemProperty("herddb.nio.usedirectmemory", false);
    private static final int COPY_BUFFER_SIZE = 8192;

    public static void cleanDirectory(Path directory) throws IOException {
        if (!Files.isDirectory(directory, new LinkOption[0])) {
            return;
        }
        Files.walkFileTree(directory, DeleteFileVisitor.INSTANCE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] fastReadFile(Path f) throws IOException {
        int len = (int)Files.size(f);
        if (USE_DIRECT_BUFFER) {
            try (SeekableByteChannel c = Files.newByteChannel(f, StandardOpenOption.READ);){
                byte[] byArray;
                ByteBuffer buffer = ByteBuffer.allocateDirect(len);
                try {
                    long res = c.read(buffer);
                    if (res != (long)len) {
                        throw new IOException("not all file " + f.toAbsolutePath() + " was read with NIO len=" + len + " writeen=" + res);
                    }
                    buffer.flip();
                    byte[] result = new byte[len];
                    buffer.get(result);
                    byArray = result;
                }
                catch (Throwable throwable) {
                    FileUtils.forceReleaseBuffer(buffer);
                    throw throwable;
                }
                FileUtils.forceReleaseBuffer(buffer);
                return byArray;
            }
        }
        byte[] result = new byte[len];
        try (RandomAccessFile raf = new RandomAccessFile(f.toFile(), "r");){
            long res = raf.read(result, 0, len);
            if (res != (long)len) {
                throw new IOException("not all file " + f.toAbsolutePath() + " was read with NIO len=" + len + " read=" + res);
            }
        }
        return result;
    }

    public static void forceReleaseBuffer(ByteBuffer buffer) {
        if (buffer == null || !buffer.isDirect()) {
            return;
        }
        PlatformDependent.freeDirectBuffer((ByteBuffer)buffer);
    }

    public static long copyStreams(InputStream input, OutputStream output) throws IOException {
        long count = 0L;
        int n = 0;
        byte[] buffer = new byte[8192];
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            count += (long)n;
        }
        return count;
    }

    public static long copyStreams(InputStream input, OutputStream output, long sizeToCopy) throws IOException {
        long count = 0L;
        int n = 0;
        int bufferSize = 8192L > sizeToCopy ? (int)sizeToCopy : 8192;
        byte[] buffer = new byte[bufferSize];
        while (count + (long)bufferSize < sizeToCopy && -1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            count += (long)n;
        }
        int remaining = (int)(sizeToCopy - count);
        if (remaining > 0) {
            buffer = new byte[remaining];
            n = input.read(buffer);
            output.write(buffer, 0, n);
            count += (long)n;
        }
        return count;
    }
}

