/*
 * Decompiled with CFR 0.152.
 */
package herddb.utils;

import herddb.utils.OpenFileUtils;
import io.netty.util.internal.PlatformDependent;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;

public class ODirectFileOutputStream
extends OutputStream {
    private static final OpenOption[] DEFAULT_OPTIONS = new OpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.WRITE};
    final ByteBuffer originalBuffer;
    final ByteBuffer block;
    final FileChannel fc;
    final int batchBlocks;
    final int alignment;
    final int batchSize;
    int writtenBlocks;

    public ODirectFileOutputStream(Path p) throws IOException {
        this(p, 1, new OpenOption[0]);
    }

    public ODirectFileOutputStream(Path p, int batchBlocks, OpenOption ... options) throws IOException {
        if (options == null || options.length == 0) {
            options = DEFAULT_OPTIONS;
        }
        this.fc = OpenFileUtils.openFileChannelWithO_DIRECT(p, options);
        try {
            this.alignment = (int)OpenFileUtils.getBlockSize(p);
        }
        catch (IOException e) {
            this.fc.close();
            Files.delete(p);
            throw e;
        }
        this.batchBlocks = batchBlocks;
        this.batchSize = this.alignment * batchBlocks;
        this.originalBuffer = ByteBuffer.allocateDirect(this.batchSize + this.batchSize);
        this.block = OpenFileUtils.alignedSlice(this.originalBuffer, this.alignment);
        ((Buffer)this.block).position(0);
        ((Buffer)this.block).limit(this.batchSize);
    }

    public int getAlignment() {
        return this.alignment;
    }

    public int getWrittenBlocks() {
        return this.writtenBlocks;
    }

    public int getBatchBlocks() {
        return this.batchBlocks;
    }

    @Override
    public void write(int b) throws IOException {
        this.block.put((byte)b);
        this.flushIfNeeded();
    }

    private void flushIfNeeded() throws IOException {
        if (this.block.remaining() == 0) {
            ((Buffer)this.block).flip();
            this.fc.write(this.block);
            this.writtenBlocks += this.batchBlocks;
            ((Buffer)this.block).position(0);
            ((Buffer)this.block).limit(this.batchSize);
        }
    }

    @Override
    public void close() throws IOException {
        this.flush(true);
        this.fc.close();
        PlatformDependent.freeDirectBuffer((ByteBuffer)this.originalBuffer);
    }

    @Override
    public void flush() throws IOException {
        this.flush(true);
    }

    private void flush(boolean pad) throws IOException {
        if (this.block.position() == 0) {
            return;
        }
        if (pad) {
            int remaining = this.block.remaining() % this.alignment;
            for (int i = 0; i < remaining; ++i) {
                this.block.put((byte)0);
            }
        }
        ((Buffer)this.block).flip();
        this.fc.write(this.block);
        this.writtenBlocks += this.block.position() / this.alignment;
        ((Buffer)this.block).position(0);
        ((Buffer)this.block).limit(this.batchSize);
    }

    public FileChannel getFc() {
        return this.fc;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        int remainingInBlock = this.block.remaining();
        if (remainingInBlock >= len) {
            this.block.put(b, off, len);
            this.flushIfNeeded();
        } else {
            int end = off + len;
            int pos = off;
            while (pos < end) {
                int remainingToWrite = len - pos;
                if (remainingToWrite > remainingInBlock) {
                    this.block.put(b, pos, remainingInBlock);
                    this.flush(false);
                    pos += remainingInBlock;
                    remainingInBlock = this.block.remaining();
                    continue;
                }
                this.block.put(b, pos, remainingToWrite);
                pos += remainingToWrite;
                this.flushIfNeeded();
            }
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }
}

