/*
 * Decompiled with CFR 0.152.
 */
package herddb.utils;

import herddb.proto.Pdu;
import herddb.proto.PduCodec;
import herddb.utils.ByteBufUtils;
import herddb.utils.DataAccessor;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;

public class RecordsBatch {
    public final String[] columnNames;
    public final int numRecords;
    private int currentRecordIndex;
    public Pdu message;
    public ByteBuf buffer;
    private DataAccessor next;
    private boolean finished;
    public Map<String, Integer> columnNameToPosition;

    public RecordsBatch(Pdu message) {
        this.buffer = message.buffer;
        this.message = message;
        this.buffer = message.buffer;
        this.currentRecordIndex = -1;
        int numColumns = this.buffer.readInt();
        this.columnNames = new String[numColumns];
        for (int i = 0; i < numColumns; ++i) {
            this.columnNames[i] = ByteBufUtils.readString(this.buffer);
        }
        this.numRecords = this.buffer.readInt();
        if (this.numRecords == 0) {
            this.finished = true;
        }
    }

    private void ensureColumnNameToPosition() {
        if (this.columnNameToPosition == null) {
            this.columnNameToPosition = new HashMap<String, Integer>();
            for (int i = 0; i < this.columnNames.length; ++i) {
                String columnName = this.columnNames[i];
                this.columnNameToPosition.put(columnName, i);
            }
        }
    }

    public boolean isEmpty() {
        return this.numRecords == 0;
    }

    private DataAccessor readRecordAtCurrentPosition() {
        Object[] values = new Object[this.columnNames.length];
        for (int i = 0; i < this.columnNames.length; ++i) {
            values[i] = PduCodec.readObject(this.buffer);
        }
        return new RowDataAccessor(values);
    }

    public boolean hasNext() {
        if (this.finished) {
            return false;
        }
        return this.ensureNext();
    }

    private boolean ensureNext() {
        if (this.next != null) {
            return true;
        }
        if (this.currentRecordIndex == this.numRecords - 1) {
            this.finished = true;
            return false;
        }
        ++this.currentRecordIndex;
        this.next = this.readRecordAtCurrentPosition();
        return true;
    }

    public DataAccessor next() {
        if (this.finished) {
            throw new IllegalStateException("Scanner is exhausted");
        }
        if (this.next == null) {
            throw new IllegalStateException("You have to call hasNext");
        }
        DataAccessor _res = this.next;
        this.next = null;
        return _res;
    }

    public void release() {
        this.message.close();
        this.message = null;
        this.next = null;
    }

    private final class RowDataAccessor
    implements DataAccessor {
        private final Object[] row;

        public RowDataAccessor(Object[] row) {
            this.row = row;
        }

        @Override
        public Object get(int index) {
            return this.row[index];
        }

        @Override
        public int getNumFields() {
            return RecordsBatch.this.columnNames.length;
        }

        @Override
        public Object get(String property) {
            RecordsBatch.this.ensureColumnNameToPosition();
            Integer i = RecordsBatch.this.columnNameToPosition.get(property);
            if (i == null) {
                return null;
            }
            return this.get(i);
        }

        @Override
        public String[] getFieldNames() {
            return RecordsBatch.this.columnNames;
        }
    }
}

