/*
 * Decompiled with CFR 0.152.
 */
package herddb.utils;

import java.util.concurrent.Callable;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TestUtils {
    private static final Logger LOG = Logger.getLogger(TestUtils.class.getName());
    public static final Callable<Void> NOOP = () -> null;

    public static void assertThrows(Class<? extends Throwable> expectedThrowable, ThrowingRunnable runnable) {
        TestUtils.expectThrows(expectedThrowable, runnable);
    }

    public static <T extends Throwable> T expectThrows(Class<T> expectedThrowable, ThrowingRunnable runnable) {
        try {
            runnable.run();
        }
        catch (Throwable actualThrown) {
            if (expectedThrowable.isInstance(actualThrown)) {
                Throwable retVal = actualThrown;
                return (T)retVal;
            }
            String mismatchMessage = String.format("unexpected exception type thrown expected %s actual %s", expectedThrowable.getSimpleName(), actualThrown.getClass().getSimpleName());
            AssertionError assertionError = new AssertionError((Object)mismatchMessage);
            ((Throwable)((Object)assertionError)).initCause(actualThrown);
            throw assertionError;
        }
        String message = String.format("expected %s to be thrown, but nothing was thrown", expectedThrowable.getSimpleName());
        throw new AssertionError((Object)message);
    }

    public static <T extends Throwable> void verifyThrows(Class<T> expectedThrowable, ThrowingRunnable runnable, Function<T, Boolean> verify) throws Exception {
        T t = TestUtils.expectThrows(expectedThrowable, runnable);
        if (!verify.apply(t).booleanValue()) {
            throw new AssertionError((Object)("Returned exception " + t + " did not very the assertion"));
        }
    }

    public static void waitForCondition(Callable<Boolean> condition, Callable<Void> callback, int seconds) throws Exception {
        TestUtils.waitForCondition(condition, callback, seconds, null);
    }

    public static void waitForCondition(Callable<Boolean> condition, Callable<Void> callback, int seconds, String description) throws Exception {
        try {
            long _start = System.currentTimeMillis();
            long millis = seconds * 1000;
            while (System.currentTimeMillis() - _start <= millis) {
                if (condition.call().booleanValue()) {
                    return;
                }
                callback.call();
                Thread.sleep(100L);
            }
        }
        catch (InterruptedException ee) {
            throw new AssertionError("test interrupted!", ee);
        }
        catch (Exception ee) {
            LOG.log(Level.SEVERE, "error during wait", ee);
            throw new AssertionError((Object)("error while evaluating condition:" + ee));
        }
        String d = description == null ? "" : " " + description;
        throw new AssertionError((Object)("condition not met in time!" + d));
    }

    public static void assertExceptionPresentInChain(Throwable t, Class<?> clazz) {
        if (!TestUtils.isExceptionPresentInChain(t, clazz)) {
            throw new AssertionError("exception didn't contain expected " + clazz.getSimpleName(), t);
        }
    }

    public static boolean isExceptionPresentInChain(Throwable t, Class clazz) {
        if (t == null) {
            return false;
        }
        if (clazz.isInstance(t)) {
            return true;
        }
        return TestUtils.isExceptionPresentInChain(t.getCause(), clazz);
    }

    public static <T extends Throwable> T getExceptionIfPresentInChain(Throwable t, Class<T> clazz) {
        if (t == null) {
            return null;
        }
        if (clazz.isInstance(t)) {
            return (T)t;
        }
        return TestUtils.getExceptionIfPresentInChain(t.getCause(), clazz);
    }

    public static interface ThrowingRunnable {
        public void run() throws Throwable;
    }
}

