/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.tck.arquillian;

import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.ByteArrayAsset;
import org.jboss.shrinkwrap.api.asset.FileAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;

public class ArchiveClassLoader
extends URLClassLoader {
    private static final String WEB_ARCHIVE_PREFIX = "WEB-INF/classes/";
    private static final String EMPTY_PREFIX = "";
    private final Archive archive;
    private final String archivePrefix;

    public ArchiveClassLoader(ClassLoader classLoader, Archive archive) {
        super(new URL[0], classLoader);
        this.archive = archive;
        this.archivePrefix = archive instanceof WebArchive ? WEB_ARCHIVE_PREFIX : EMPTY_PREFIX;
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        if (this.archive.get(this.archivePrefix + name) != null) {
            return this.loadFromArchive(this.archivePrefix + name);
        }
        return super.getResourceAsStream(name);
    }

    private InputStream loadFromArchive(String name) {
        InputStream in;
        Asset asset = this.archive.get(name).getAsset();
        if (asset instanceof FileAsset) {
            in = asset.openStream();
        } else if (asset instanceof ByteArrayAsset) {
            in = asset.openStream();
        } else {
            throw new RuntimeException("Unsupported asset type " + asset.toString());
        }
        return in;
    }
}

