/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.metadata;

import javax.validation.metadata.PropertyDescriptor;
import org.hibernate.beanvalidation.tck.tests.metadata.Customer;
import org.hibernate.beanvalidation.tck.tests.metadata.NotEmpty;
import org.hibernate.beanvalidation.tck.tests.metadata.Order;
import org.hibernate.beanvalidation.tck.tests.metadata.Person;
import org.hibernate.beanvalidation.tck.tests.metadata.Severity;
import org.hibernate.beanvalidation.tck.util.TestUtil;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="beanvalidation", version="1.1.0")
public class PropertyDescriptorTest
extends Arquillian {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClass(PropertyDescriptorTest.class)).withClasses(Order.class, Person.class, Customer.class, Severity.class, NotEmpty.class)).build();
    }

    @Test
    @SpecAssertion(section="5.4", id="a")
    public void testIsNotCascaded() {
        PropertyDescriptor descriptor = TestUtil.getPropertyDescriptor(Order.class, "orderNumber");
        Assert.assertFalse((boolean)descriptor.isCascaded(), (String)"Should not be cascaded");
    }

    @Test
    @SpecAssertion(section="5.4", id="a")
    public void testIsCascaded() {
        PropertyDescriptor descriptor = TestUtil.getPropertyDescriptor(Customer.class, "orderList");
        Assert.assertTrue((boolean)descriptor.isCascaded(), (String)"Should be cascaded");
    }

    @Test
    @SpecAssertion(section="5.4", id="b")
    public void testPropertyName() {
        String propertyName = "orderList";
        PropertyDescriptor descriptor = TestUtil.getPropertyDescriptor(Customer.class, propertyName);
        Assert.assertEquals((String)descriptor.getPropertyName(), (String)propertyName, (String)"Wrong property name");
    }
}

