/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.traversableresolver;

import java.lang.annotation.ElementType;
import java.util.HashSet;
import java.util.Set;
import javax.validation.Path;
import javax.validation.TraversableResolver;
import org.hibernate.beanvalidation.tck.tests.traversableresolver.Suit;

public class SnifferTraversableResolver
implements TraversableResolver {
    Set<String> reachPaths = new HashSet<String>();
    Set<String> cascadePaths = new HashSet<String>();
    Set<Call> expectedReachCalls = new HashSet<Call>();
    Set<Call> expectedCascadeCalls = new HashSet<Call>();
    Set<Call> executedReachableCalls = new HashSet<Call>();

    public SnifferTraversableResolver(Suit suit) {
        this.expectedReachCalls.add(new Call(suit, "size", Suit.class, "", ElementType.FIELD));
        this.expectedReachCalls.add(new Call(suit, "trousers", Suit.class, "", ElementType.FIELD));
        this.expectedCascadeCalls.add(new Call(suit, "trousers", Suit.class, "", ElementType.FIELD));
        this.expectedReachCalls.add(new Call(suit.getTrousers(), "length", Suit.class, "trousers", ElementType.FIELD));
        this.expectedReachCalls.add(new Call(suit, "jacket", Suit.class, "", ElementType.METHOD));
        this.expectedCascadeCalls.add(new Call(suit, "jacket", Suit.class, "", ElementType.METHOD));
        this.expectedReachCalls.add(new Call(suit.getJacket(), "width", Suit.class, "jacket", ElementType.METHOD));
    }

    public Set<String> getReachPaths() {
        return this.reachPaths;
    }

    public Set<String> getCascadePaths() {
        return this.cascadePaths;
    }

    public boolean isTraversable(Set<Call> calls, Set<String> paths, Call call, String traversableProperty, String pathToTraversableObject) {
        String path = "";
        if (pathToTraversableObject != null && pathToTraversableObject.length() != 0) {
            path = pathToTraversableObject + ".";
        }
        paths.add(path + traversableProperty);
        if (!calls.contains(call)) {
            throw new IllegalStateException("Unexpected " + call.toString());
        }
        return true;
    }

    public boolean isReachable(Object traversableObject, Path.Node traversableProperty, Class<?> rootBeanType, Path pathToTraversableObject, ElementType elementType) {
        Call call = new Call(traversableObject, traversableProperty.getName(), rootBeanType, pathToTraversableObject.toString(), elementType);
        this.executedReachableCalls.add(call);
        return this.isTraversable(this.expectedReachCalls, this.reachPaths, call, traversableProperty.getName(), pathToTraversableObject.toString());
    }

    public boolean isCascadable(Object traversableObject, Path.Node traversableProperty, Class<?> rootBeanType, Path pathToTraversableObject, ElementType elementType) {
        Call call = new Call(traversableObject, traversableProperty.getName(), rootBeanType, pathToTraversableObject.toString(), elementType);
        if (!this.executedReachableCalls.contains(call)) {
            throw new IllegalStateException("isCascadable called before a matching  isReachable call: " + call.toString());
        }
        return this.isTraversable(this.expectedCascadeCalls, this.cascadePaths, call, traversableProperty.getName(), pathToTraversableObject.toString());
    }

    private static final class Call {
        private Object traversableObject;
        private String traversableProperty;
        private Class<?> rootBeanType;
        private String pathToTraversableObject;
        private ElementType elementType;

        private Call(Object traversableObject, String traversableProperty, Class<?> rootBeanType, String pathToTraversableObject, ElementType elementType) {
            this.traversableObject = traversableObject;
            this.traversableProperty = traversableProperty;
            this.rootBeanType = rootBeanType;
            this.pathToTraversableObject = pathToTraversableObject;
            this.elementType = elementType;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Call call = (Call)o;
            if (this.elementType != call.elementType) {
                return false;
            }
            if (!this.pathToTraversableObject.equals(call.pathToTraversableObject)) {
                return false;
            }
            if (!this.rootBeanType.equals(call.rootBeanType)) {
                return false;
            }
            if (this.traversableObject != null ? this.traversableObject != call.traversableObject : call.traversableObject != null) {
                return false;
            }
            return this.traversableProperty.equals(call.traversableProperty);
        }

        public int hashCode() {
            int result = this.traversableObject != null ? this.traversableObject.hashCode() : 0;
            result = 31 * result + this.traversableProperty.hashCode();
            result = 31 * result + this.rootBeanType.hashCode();
            result = 31 * result + this.pathToTraversableObject.hashCode();
            result = 31 * result + this.elementType.hashCode();
            return result;
        }

        public String toString() {
            return "Call{traversableObject=" + this.traversableObject + ", traversableProperty='" + this.traversableProperty + '\'' + ", rootBeanType=" + this.rootBeanType + ", pathToTraversableObject='" + this.pathToTraversableObject + '\'' + ", elementType=" + (Object)((Object)this.elementType) + '}';
        }
    }
}

