/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.validation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.validation.Constraint;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import javax.validation.ConstraintViolation;
import javax.validation.Path;
import javax.validation.Payload;
import javax.validation.Valid;
import javax.validation.Validator;
import org.hibernate.beanvalidation.tck.tests.validation.Actor;
import org.hibernate.beanvalidation.tck.tests.validation.ActorArrayBased;
import org.hibernate.beanvalidation.tck.tests.validation.ActorListBased;
import org.hibernate.beanvalidation.tck.tests.validation.Customer;
import org.hibernate.beanvalidation.tck.tests.validation.Engine;
import org.hibernate.beanvalidation.tck.tests.validation.Order;
import org.hibernate.beanvalidation.tck.tests.validation.Person;
import org.hibernate.beanvalidation.tck.tests.validation.PlayedWith;
import org.hibernate.beanvalidation.tck.util.TestUtil;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="beanvalidation", version="1.1.0")
public class PropertyPathTest
extends Arquillian {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClass(PropertyPathTest.class)).withClasses(Actor.class, ActorArrayBased.class, ActorListBased.class, PlayedWith.class, Person.class, VerySpecialClass.class, Customer.class, Engine.class, Order.class)).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="4.2", id="f"), @SpecAssertion(section="4.2", id="g"), @SpecAssertion(section="4.2", id="m")})
    public void testPropertyPathWithConstraintViolationForRootObject() {
        Validator validator = TestUtil.getValidatorUnderTest();
        Set constraintViolations = validator.validate((Object)new VerySpecialClass(), new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 1);
        ConstraintViolation constraintViolation = (ConstraintViolation)constraintViolations.iterator().next();
        Iterator nodeIter = constraintViolation.getPropertyPath().iterator();
        Assert.assertTrue((boolean)nodeIter.hasNext());
        Path.Node node = (Path.Node)nodeIter.next();
        Assert.assertEquals((String)node.getName(), null);
        Assert.assertFalse((boolean)node.isInIterable());
        Assert.assertFalse((boolean)nodeIter.hasNext());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="4.2", id="f"), @SpecAssertion(section="4.2", id="h"), @SpecAssertion(section="4.2", id="l")})
    public void testPropertyPathTraversedObject() {
        Validator validator = TestUtil.getValidatorUnderTest();
        Engine engine = new Engine();
        engine.setSerialNumber("ABCDEFGH1234");
        Set constraintViolations = validator.validate((Object)engine, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 1);
        ConstraintViolation constraintViolation = (ConstraintViolation)constraintViolations.iterator().next();
        Iterator nodeIter = constraintViolation.getPropertyPath().iterator();
        Assert.assertTrue((boolean)nodeIter.hasNext());
        Path.Node node = (Path.Node)nodeIter.next();
        Assert.assertEquals((String)node.getName(), (String)"serialNumber");
        Assert.assertFalse((boolean)node.isInIterable());
        Assert.assertFalse((boolean)nodeIter.hasNext());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="4.2", id="f"), @SpecAssertion(section="4.2", id="i"), @SpecAssertion(section="4.2", id="k")})
    public void testPropertyPathWithList() {
        Validator validator = TestUtil.getValidatorUnderTest();
        ActorListBased clint = new ActorListBased("Clint", "Eastwood");
        ActorListBased morgan = new ActorListBased("Morgan", null);
        ActorListBased charlie = new ActorListBased("Charlie", "Sheen");
        clint.addPlayedWith(charlie);
        charlie.addPlayedWith(clint);
        charlie.addPlayedWith(morgan);
        morgan.addPlayedWith(charlie);
        Set constraintViolations = validator.validate((Object)clint, new Class[0]);
        this.checkActorViolations(constraintViolations);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="4.2", id="f"), @SpecAssertion(section="4.2", id="i"), @SpecAssertion(section="4.2", id="k")})
    public void testPropertyPathWithArray() {
        Validator validator = TestUtil.getValidatorUnderTest();
        ActorArrayBased clint = new ActorArrayBased("Clint", "Eastwood");
        ActorArrayBased morgan = new ActorArrayBased("Morgan", null);
        ActorArrayBased charlie = new ActorArrayBased("Charlie", "Sheen");
        clint.addPlayedWith(charlie);
        charlie.addPlayedWith(clint);
        charlie.addPlayedWith(morgan);
        morgan.addPlayedWith(charlie);
        Set constraintViolations = validator.validate((Object)clint, new Class[0]);
        this.checkActorViolations(constraintViolations);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="4.2", id="f"), @SpecAssertion(section="4.2", id="j"), @SpecAssertion(section="4.2", id="k")})
    public void testPropertyPathWithMap() {
        Validator validator = TestUtil.getValidatorUnderTest();
        ActorDB db = new ActorDB();
        ActorArrayBased morgan = new ActorArrayBased("Morgan", null);
        Integer id = db.addActor(morgan);
        Set constraintViolations = validator.validate((Object)db, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 1);
        ConstraintViolation constraintViolation = (ConstraintViolation)constraintViolations.iterator().next();
        Iterator nodeIter = constraintViolation.getPropertyPath().iterator();
        Assert.assertTrue((boolean)nodeIter.hasNext());
        Path.Node node = (Path.Node)nodeIter.next();
        Assert.assertEquals((String)node.getName(), (String)"actors");
        Assert.assertFalse((boolean)node.isInIterable());
        node = (Path.Node)nodeIter.next();
        Assert.assertEquals((String)node.getName(), (String)"lastName");
        Assert.assertTrue((boolean)node.isInIterable());
        Assert.assertEquals((Object)node.getKey(), (Object)id);
        Assert.assertFalse((boolean)nodeIter.hasNext());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="4.2", id="f"), @SpecAssertion(section="4.2", id="k")})
    public void testPropertyPathSet() {
        Validator validator = TestUtil.getValidatorUnderTest();
        Customer customer = new Customer();
        customer.setFirstName("John");
        customer.setLastName("Doe");
        Order order = new Order();
        customer.addOrder(order);
        Set constraintViolations = validator.validate((Object)customer, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 1);
        ConstraintViolation constraintViolation = (ConstraintViolation)constraintViolations.iterator().next();
        Iterator nodeIter = constraintViolation.getPropertyPath().iterator();
        Assert.assertTrue((boolean)nodeIter.hasNext());
        Path.Node node = (Path.Node)nodeIter.next();
        Assert.assertEquals((String)node.getName(), (String)"orders");
        Assert.assertFalse((boolean)node.isInIterable());
        node = (Path.Node)nodeIter.next();
        Assert.assertEquals((String)node.getName(), (String)"orderNumber");
        Assert.assertTrue((boolean)node.isInIterable());
        Assert.assertFalse((boolean)nodeIter.hasNext());
    }

    private void checkActorViolations(Set<ConstraintViolation<Actor>> constraintViolations) {
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 1);
        ConstraintViolation constraintViolation = constraintViolations.iterator().next();
        Iterator nodeIter = constraintViolation.getPropertyPath().iterator();
        Assert.assertTrue((boolean)nodeIter.hasNext());
        Path.Node node = (Path.Node)nodeIter.next();
        Assert.assertEquals((String)node.getName(), (String)"playedWith");
        Assert.assertFalse((boolean)node.isInIterable());
        node = (Path.Node)nodeIter.next();
        Assert.assertEquals((String)node.getName(), (String)"playedWith");
        Assert.assertTrue((boolean)node.isInIterable());
        Assert.assertEquals((Object)node.getIndex(), (Object)new Integer(0));
        node = (Path.Node)nodeIter.next();
        Assert.assertEquals((String)node.getName(), (String)"lastName");
        Assert.assertTrue((boolean)node.isInIterable());
        Assert.assertEquals((Object)node.getIndex(), (Object)new Integer(1));
        Assert.assertFalse((boolean)nodeIter.hasNext());
    }

    class ActorDB {
        private int idGen = 0;
        @Valid
        Map<Integer, Actor> actors = new HashMap<Integer, Actor>();

        ActorDB() {
        }

        public Integer addActor(Actor actor) {
            Integer id = this.idGen++;
            this.actors.put(id, actor);
            return id;
        }
    }

    public static class SpecialValidator
    implements ConstraintValidator<Special, VerySpecialClass> {
        public void initialize(Special constraintAnnotation) {
        }

        public boolean isValid(VerySpecialClass clazz, ConstraintValidatorContext constraintValidatorContext) {
            return false;
        }
    }

    @Constraint(validatedBy={SpecialValidator.class})
    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Special {
        public String message() default "special validation failed";

        public Class<?>[] groups() default {};

        public Class<? extends Payload>[] payload() default {};
    }

    @Special
    class VerySpecialClass {
        VerySpecialClass() {
        }
    }
}

