/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.integration.cdi.executable.types;

import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.validation.ConstraintViolationException;
import javax.validation.constraints.Min;
import javax.validation.constraints.Size;
import org.hibernate.beanvalidation.tck.tests.integration.cdi.executable.types.AnotherCalendarService;
import org.hibernate.beanvalidation.tck.tests.integration.cdi.executable.types.CalendarService;
import org.hibernate.beanvalidation.tck.tests.integration.cdi.executable.types.Event;
import org.hibernate.beanvalidation.tck.tests.integration.cdi.executable.types.OfflineCalendarService;
import org.hibernate.beanvalidation.tck.tests.integration.cdi.executable.types.OnlineCalendarService;
import org.hibernate.beanvalidation.tck.tests.integration.cdi.executable.types.ValidOjbect;
import org.hibernate.beanvalidation.tck.tests.integration.cdi.executable.types.YetAnotherCalendarService;
import org.hibernate.beanvalidation.tck.util.IntegrationTest;
import org.hibernate.beanvalidation.tck.util.TestUtil;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@IntegrationTest
@SpecVersion(spec="beanvalidation", version="1.1.0")
public class ExecutableTypesTest
extends Arquillian {
    @Inject
    private CalendarService calendar;
    @Inject
    private Instance<OnlineCalendarService> onlineCalendar;
    @Inject
    private Instance<OfflineCalendarService> offlineCalendar;
    @Inject
    private Instance<AnotherCalendarService> anotherCalendar;
    @Inject
    private Instance<YetAnotherCalendarService> yetAnotherCalendar;

    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(ExecutableTypesTest.class)).withEmptyBeansXml().build();
    }

    @Test
    @SpecAssertion(section="10.1.2", id="i")
    public void testValidationOfConstrainedMethodWithExecutableTypeNONE() {
        Event event = this.calendar.createEvent(null);
        Assert.assertNotNull((Object)event);
    }

    @Test
    @SpecAssertion(section="10.1.2", id="i")
    public void testValidationOfConstrainedMethodWithEmptyExecutableTypes() {
        Event event = this.calendar.createEvent(-10);
        Assert.assertNotNull((Object)event);
    }

    @Test
    @SpecAssertion(section="10.1.2", id="i")
    public void testValidationOfConstrainedMethodWithExecutableTypeNONEAndOther() {
        try {
            this.calendar.createEvent(-10L);
            Assert.fail((String)"Method invocation should have caused a ConstraintViolationException");
        }
        catch (ConstraintViolationException e) {
            TestUtil.assertCorrectConstraintTypes(e.getConstraintViolations(), Min.class);
        }
    }

    @Test
    @SpecAssertion(section="10.1.2", id="j")
    public void testValidationOfConstrainedConstructorParametersWithExecutableTypeCONSTRUCTORS() {
        try {
            this.onlineCalendar.get();
            Assert.fail((String)"Constructor invocation should have caused a ConstraintViolationException");
        }
        catch (ConstraintViolationException e) {
            TestUtil.assertCorrectConstraintTypes(e.getConstraintViolations(), Size.class);
        }
    }

    @Test
    @SpecAssertion(section="10.1.2", id="j")
    public void testValidationOfConstrainedConstructorReturnValueWithExecutableTypeCONSTRUCTORS() {
        try {
            this.offlineCalendar.get();
            Assert.fail((String)"Constructor invocation should have caused a ConstraintViolationException");
        }
        catch (ConstraintViolationException e) {
            TestUtil.assertCorrectConstraintTypes(e.getConstraintViolations(), ValidOjbect.class);
        }
    }

    @Test
    @SpecAssertion(section="10.1.2", id="j")
    public void testValidationOfConstrainedConstructorWithoutExecutableTypeCONSTRUCTORS() {
        AnotherCalendarService calendar = (AnotherCalendarService)this.anotherCalendar.get();
        Assert.assertNotNull((Object)calendar);
    }

    @Test
    @SpecAssertion(section="10.1.2", id="k")
    public void testValidationOfConstrainedMethodParametersWithExecutableTypeNON_GETTER_METHODS() {
        try {
            this.calendar.createEvent((short)-10);
            Assert.fail((String)"Method invocation should have caused a ConstraintViolationException");
        }
        catch (ConstraintViolationException e) {
            TestUtil.assertCorrectConstraintTypes(e.getConstraintViolations(), Min.class);
        }
    }

    @Test
    @SpecAssertion(section="10.1.2", id="k")
    public void testValidationOfConstrainedMethodReturnValueWithExecutableTypeNON_GETTER_METHODS() {
        try {
            this.calendar.createEvent((byte)-10);
            Assert.fail((String)"Method invocation should have caused a ConstraintViolationException");
        }
        catch (ConstraintViolationException e) {
            TestUtil.assertCorrectConstraintTypes(e.getConstraintViolations(), ValidOjbect.class);
        }
    }

    @Test
    @SpecAssertion(section="10.1.2", id="k")
    public void testValidationOfConstrainedGetterWithExecutableTypeNON_GETTER_METHODS() {
        Event event = this.calendar.getEvent();
        Assert.assertNotNull((Object)event);
    }

    @Test
    @SpecAssertion(section="10.1.2", id="l")
    public void testValidationOfConstrainedGetterReturnValueWithExecutableTypeGETTER_METHODS() {
        try {
            this.calendar.getSpecialEvent();
            Assert.fail((String)"Method invocation should have caused a ConstraintViolationException");
        }
        catch (ConstraintViolationException e) {
            TestUtil.assertCorrectConstraintTypes(e.getConstraintViolations(), ValidOjbect.class);
        }
    }

    @Test
    @SpecAssertion(section="10.1.2", id="l")
    public void testValidationOfConstrainedMethodWithExecutableTypeGETTER_METHODS() {
        Event event = this.calendar.getSpecialEvent(0);
        Assert.assertNotNull((Object)event);
    }

    @Test
    @SpecAssertion(section="10.1.2", id="m")
    public void testValidationOfConstrainedMethodWithExecutableTypeALL() {
        try {
            this.calendar.createEvent(-10.0);
            Assert.fail((String)"Method invocation should have caused a ConstraintViolationException");
        }
        catch (ConstraintViolationException e) {
            TestUtil.assertCorrectConstraintTypes(e.getConstraintViolations(), Min.class);
        }
    }

    @Test
    @SpecAssertion(section="10.1.2", id="m")
    public void testValidationOfConstrainedGetterWithExecutableTypeALL() {
        try {
            this.calendar.getVerySpecialEvent();
            Assert.fail((String)"Method invocation should have caused a ConstraintViolationException");
        }
        catch (ConstraintViolationException e) {
            TestUtil.assertCorrectConstraintTypes(e.getConstraintViolations(), ValidOjbect.class);
        }
    }

    @Test
    @SpecAssertion(section="10.1.2", id="m")
    public void testValidationOfConstrainedConstructorWithExecutableTypeALL() {
        try {
            this.yetAnotherCalendar.get();
            Assert.fail((String)"Constructor invocation should have caused a ConstraintViolationException");
        }
        catch (ConstraintViolationException e) {
            TestUtil.assertCorrectConstraintTypes(e.getConstraintViolations(), Size.class);
        }
    }

    @Test
    @SpecAssertion(section="10.1.2", id="m")
    public void testValidationOfConstrainedMethodWithExecutableTypesALLAndNONE() {
        try {
            this.calendar.createEvent(-10.0f);
            Assert.fail((String)"Method invocation should have caused a ConstraintViolationException");
        }
        catch (ConstraintViolationException e) {
            TestUtil.assertCorrectConstraintTypes(e.getConstraintViolations(), Min.class);
        }
    }
}

