/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.xmlconfiguration.methodvalidation;

import java.util.List;
import java.util.Set;
import javax.validation.constraints.NotNull;
import javax.validation.groups.Default;
import javax.validation.metadata.ConstraintDescriptor;
import javax.validation.metadata.GroupConversionDescriptor;
import javax.validation.metadata.MethodDescriptor;
import javax.validation.metadata.ParameterDescriptor;
import javax.validation.metadata.ReturnValueDescriptor;
import org.hibernate.beanvalidation.tck.tests.xmlconfiguration.methodvalidation.Customer;
import org.hibernate.beanvalidation.tck.tests.xmlconfiguration.methodvalidation.CustomerRepository;
import org.hibernate.beanvalidation.tck.util.TestUtil;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="beanvalidation", version="1.1.0")
public class MethodValidationTest
extends Arquillian {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(MethodValidationTest.class)).withValidationXml("validation-MethodValidationTest.xml")).withResource("customer-repository-constraints-MethodValidationTest.xml")).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="8.1.1.5", id="a"), @SpecAssertion(section="8.1.1.5", id="c"), @SpecAssertion(section="8.1.1.5", id="f")})
    public void testXmlMethodConfigurationApplied() throws Exception {
        MethodDescriptor descriptor = TestUtil.getMethodDescriptor(CustomerRepository.class, "listCustomers", new Class[0]);
        Assert.assertNotNull((Object)descriptor, (String)"the specified method should be configured in xml");
        Assert.assertTrue((boolean)descriptor.hasConstrainedReturnValue());
        Assert.assertFalse((boolean)descriptor.hasConstrainedParameters());
        descriptor = TestUtil.getMethodDescriptor(CustomerRepository.class, "findCustomer", String.class);
        Assert.assertNotNull((Object)descriptor, (String)"the specified method should be configured in xml");
        Assert.assertTrue((boolean)descriptor.hasConstrainedReturnValue());
        Assert.assertTrue((boolean)descriptor.hasConstrainedParameters());
        descriptor = TestUtil.getMethodDescriptor(CustomerRepository.class, "isCustomer", String.class);
        Assert.assertNotNull((Object)descriptor, (String)"the specified method should be configured in xml");
        Assert.assertFalse((boolean)descriptor.hasConstrainedReturnValue());
        Assert.assertTrue((boolean)descriptor.hasConstrainedParameters());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="8.1.1.5", id="b"), @SpecAssertion(section="8.1.1.5", id="c")})
    public void testVarargsMethodParameter() throws Exception {
        MethodDescriptor descriptor = TestUtil.getMethodDescriptor(CustomerRepository.class, "addCustomers", Customer[].class);
        Assert.assertNotNull((Object)descriptor, (String)"the specified method should be configured in xml");
        Assert.assertTrue((boolean)descriptor.hasConstrainedParameters());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="8.1.1.5", id="c"), @SpecAssertion(section="8.1.1.5", id="g"), @SpecAssertion(section="8.1.1.5", id="k")})
    public void tesConstructorCrossParameterParameter() throws Exception {
        MethodDescriptor descriptor = TestUtil.getMethodDescriptor(CustomerRepository.class, "notifyCustomer", Customer.class, String.class);
        Assert.assertNotNull((Object)descriptor, (String)"the specified method should be configured in xml");
        Assert.assertTrue((boolean)descriptor.getCrossParameterDescriptor().hasConstraints());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="6.11", id="a"), @SpecAssertion(section="8.1.1.5", id="h")})
    public void testConstraintOnConstructorReturnValueAndParameter() throws Exception {
        MethodDescriptor descriptor = TestUtil.getMethodDescriptor(CustomerRepository.class, "notifyCustomer", Customer.class, String.class);
        Assert.assertNotNull((Object)descriptor, (String)"the specified method should be configured in xml");
        ReturnValueDescriptor returnValueDescriptor = descriptor.getReturnValueDescriptor();
        Set constraintDescriptors = returnValueDescriptor.getConstraintDescriptors();
        Assert.assertTrue((constraintDescriptors.size() == 1 ? 1 : 0) != 0);
        ConstraintDescriptor constraintDescriptor = (ConstraintDescriptor)constraintDescriptors.iterator().next();
        Assert.assertEquals(constraintDescriptor.getAnnotation().annotationType(), NotNull.class, (String)"Unexpected constraint type");
        List parameterDescriptors = descriptor.getParameterDescriptors();
        Assert.assertTrue((parameterDescriptors.size() == 2 ? 1 : 0) != 0);
        ParameterDescriptor parameterDescriptor = (ParameterDescriptor)parameterDescriptors.get(0);
        constraintDescriptors = parameterDescriptor.getConstraintDescriptors();
        Assert.assertTrue((constraintDescriptors.size() == 1 ? 1 : 0) != 0);
        constraintDescriptor = (ConstraintDescriptor)constraintDescriptors.iterator().next();
        Assert.assertEquals(constraintDescriptor.getAnnotation().annotationType(), NotNull.class, (String)"Unexpected constraint type");
    }

    @Test
    @SpecAssertion(section="8.1.1.5", id="i")
    public void testCascadingOnReturnValueAndParameter() throws Exception {
        MethodDescriptor descriptor = TestUtil.getMethodDescriptor(CustomerRepository.class, "findByExample", Customer.class);
        Assert.assertNotNull((Object)descriptor, (String)"the specified method should be configured in xml");
        ReturnValueDescriptor returnValueDescriptor = descriptor.getReturnValueDescriptor();
        Assert.assertTrue((boolean)returnValueDescriptor.isCascaded(), (String)"<valid/> is used to configure cascading");
        List parameterDescriptors = descriptor.getParameterDescriptors();
        Assert.assertTrue((parameterDescriptors.size() == 1 ? 1 : 0) != 0);
        ParameterDescriptor parameterDescriptor = (ParameterDescriptor)parameterDescriptors.get(0);
        Assert.assertTrue((boolean)parameterDescriptor.isCascaded(), (String)"<valid/> is used to configure cascading");
    }

    @Test
    @SpecAssertion(section="8.1.1.5", id="j")
    public void testGroupConversionOnReturnValueAndParameter() throws Exception {
        MethodDescriptor descriptor = TestUtil.getMethodDescriptor(CustomerRepository.class, "findByExample", Customer.class);
        Assert.assertNotNull((Object)descriptor, (String)"the specified method should be configured in xml");
        ReturnValueDescriptor returnValueDescriptor = descriptor.getReturnValueDescriptor();
        Set groupConversionDescriptors = returnValueDescriptor.getGroupConversions();
        Assert.assertTrue((groupConversionDescriptors.size() == 1 ? 1 : 0) != 0);
        GroupConversionDescriptor groupConversionDescriptor = (GroupConversionDescriptor)groupConversionDescriptors.iterator().next();
        Assert.assertEquals((Object)groupConversionDescriptor.getFrom(), Default.class, (String)"Wrong from class for group conversion");
        List parameterDescriptors = descriptor.getParameterDescriptors();
        Assert.assertTrue((parameterDescriptors.size() == 1 ? 1 : 0) != 0);
        ParameterDescriptor parameterDescriptor = (ParameterDescriptor)parameterDescriptors.get(0);
        groupConversionDescriptors = parameterDescriptor.getGroupConversions();
        Assert.assertTrue((groupConversionDescriptors.size() == 1 ? 1 : 0) != 0);
        groupConversionDescriptor = (GroupConversionDescriptor)groupConversionDescriptors.iterator().next();
        Assert.assertEquals((Object)groupConversionDescriptor.getFrom(), Default.class, (String)"Wrong from class for group conversion");
    }
}

