/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.constraints.groups.groupsequenceisolation;

import java.util.Set;
import javax.validation.Validator;
import javax.validation.constraints.Max;
import javax.validation.constraints.Size;
import org.hibernate.beanvalidation.tck.tests.constraints.groups.groupsequenceisolation.B1;
import org.hibernate.beanvalidation.tck.tests.constraints.groups.groupsequenceisolation.B2;
import org.hibernate.beanvalidation.tck.tests.constraints.groups.groupsequenceisolation.B3;
import org.hibernate.beanvalidation.tck.tests.constraints.groups.groupsequenceisolation.C;
import org.hibernate.beanvalidation.tck.tests.constraints.groups.groupsequenceisolation.E;
import org.hibernate.beanvalidation.tck.tests.constraints.groups.groupsequenceisolation.IsAdult;
import org.hibernate.beanvalidation.tck.tests.constraints.groups.groupsequenceisolation.SafeEncryption;
import org.hibernate.beanvalidation.tck.util.TestUtil;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.annotations.Test;

@SpecVersion(spec="beanvalidation", version="1.1.0")
public class GroupSequenceIsolationTest
extends Arquillian {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(GroupSequenceIsolationTest.class)).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="4.4.3", id="a"), @SpecAssertion(section="4.4.3", id="c"), @SpecAssertion(section="4.4.6", id="c")})
    public void testCorrectDefaultSequenceInheritance() {
        Validator validator = TestUtil.getValidatorUnderTest();
        B1 b = new B1();
        b.name = "this name is too long";
        b.nickname = "and this nickname as well";
        b.size = 20;
        b.encryptionKey = "not safe";
        Set violations = validator.validate((Object)b, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(violations, 2);
        TestUtil.assertCorrectConstraintTypes(violations, Size.class, Size.class);
        b.name = "Jonathan";
        violations = validator.validate((Object)b, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(violations, 1);
        TestUtil.assertCorrectConstraintTypes(violations, Size.class);
        b.nickname = "Jon";
        violations = validator.validate((Object)b, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(violations, 1);
        TestUtil.assertCorrectConstraintTypes(violations, SafeEncryption.class);
        b.encryptionKey = "secret";
        violations = validator.validate((Object)b, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(violations, 0);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="4.4.3", id="a"), @SpecAssertion(section="4.4.3", id="c"), @SpecAssertion(section="4.4.6", id="c")})
    public void testCorrectDefaultSequenceInheritance2() {
        Validator validator = TestUtil.getValidatorUnderTest();
        B2 b = new B2();
        b.name = "this name is too long";
        b.nickname = "and this nickname as well";
        b.size = 20;
        b.encryptionKey = "not safe";
        Set violations = validator.validate((Object)b, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(violations, 1);
        TestUtil.assertCorrectConstraintTypes(violations, Max.class);
        b.size = 10;
        violations = validator.validate((Object)b, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(violations, 2);
        TestUtil.assertCorrectConstraintTypes(violations, Size.class, Size.class);
        b.name = "Jonathan";
        violations = validator.validate((Object)b, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(violations, 1);
        TestUtil.assertCorrectConstraintTypes(violations, Size.class);
        b.nickname = "Jon";
        violations = validator.validate((Object)b, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(violations, 1);
        TestUtil.assertCorrectConstraintTypes(violations, SafeEncryption.class);
        b.encryptionKey = "secret";
        violations = validator.validate((Object)b, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(violations, 0);
    }

    @Test
    @SpecAssertion(section="4.4.6", id="b")
    public void testCorrectDefaultSequenceInheritance3() {
        Validator validator = TestUtil.getValidatorUnderTest();
        B3 b = new B3();
        b.name = "this name is too long";
        b.nickname = "and this nickname as well";
        b.size = 20;
        b.encryptionKey = "not safe";
        Set violations = validator.validate((Object)b, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(violations, 2);
        TestUtil.assertCorrectConstraintTypes(violations, Max.class, Size.class);
        TestUtil.assertCorrectPropertyPaths(violations, "size", "nickname");
        b.nickname = "nick";
        violations = validator.validate((Object)b, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(violations, 1);
        TestUtil.assertCorrectConstraintTypes(violations, Max.class);
        TestUtil.assertCorrectPropertyPaths(violations, "size");
        b.size = 10;
        violations = validator.validate((Object)b, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(violations, 1);
        TestUtil.assertCorrectConstraintTypes(violations, Size.class);
        TestUtil.assertCorrectPropertyPaths(violations, "name");
        b.nickname = "and this nickname as well";
        violations = validator.validate((Object)b, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(violations, 2);
        TestUtil.assertCorrectConstraintTypes(violations, Size.class, Size.class);
        TestUtil.assertCorrectPropertyPaths(violations, "name", "nickname");
    }

    @Test
    @SpecAssertion(section="4.6.1", id="e")
    public void testCorrectDefaultSequenceContainedCaseWithoutGroupRedefinitionOnContainedEntity() {
        Validator validator = TestUtil.getValidatorUnderTest();
        C c = new C();
        c.name = "this name is too long";
        c.d.nickname = "and this nickname as well";
        c.size = 20;
        c.d.encryptionKey = "not safe";
        Set violations = validator.validate((Object)c, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(violations, 2);
        TestUtil.assertCorrectConstraintTypes(violations, Max.class, Size.class);
        TestUtil.assertCorrectPropertyPaths(violations, "size", "d.nickname");
        c.size = 10;
        violations = validator.validate((Object)c, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(violations, 2);
        TestUtil.assertCorrectConstraintTypes(violations, Size.class, Size.class);
        TestUtil.assertCorrectPropertyPaths(violations, "name", "d.nickname");
        c.d.nickname = "Jon";
        violations = validator.validate((Object)c, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(violations, 1);
        TestUtil.assertCorrectConstraintTypes(violations, Size.class);
        TestUtil.assertCorrectPropertyPaths(violations, "name");
        c.name = "Johnatan";
        violations = validator.validate((Object)c, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(violations, 0);
    }

    @Test
    @SpecAssertion(section="4.6.1", id="e")
    public void testCorrectDefaultSequenceContainedCaseWithGroupRedefinitionOnContainedEntity() {
        Validator validator = TestUtil.getValidatorUnderTest();
        E e = new E();
        e.name = "this name is too long";
        e.f.nickname = "and this nickname as well";
        e.size = 20;
        e.f.encryptionKey = "not safe";
        e.f.age = 16;
        Set violations = validator.validate((Object)e, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(violations, 2);
        TestUtil.assertCorrectConstraintTypes(violations, Max.class, Size.class);
        TestUtil.assertCorrectPropertyPaths(violations, "size", "f.nickname");
        e.size = 10;
        violations = validator.validate((Object)e, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(violations, 2);
        TestUtil.assertCorrectConstraintTypes(violations, Size.class, Size.class);
        TestUtil.assertCorrectPropertyPaths(violations, "name", "f.nickname");
        e.f.nickname = "Jon";
        violations = validator.validate((Object)e, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(violations, 2);
        TestUtil.assertCorrectConstraintTypes(violations, Size.class, IsAdult.class);
        TestUtil.assertCorrectPropertyPaths(violations, "name", "f.age");
        e.f.age = 18;
        violations = validator.validate((Object)e, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(violations, 1);
        TestUtil.assertCorrectConstraintTypes(violations, Size.class);
        TestUtil.assertCorrectPropertyPaths(violations, "name");
        e.name = "Johnatan";
        violations = validator.validate((Object)e, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(violations, 0);
    }
}

