/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.constraints.constraintdefinition;

import java.util.Set;
import javax.validation.Validator;
import javax.validation.groups.Default;
import javax.validation.metadata.ConstraintDescriptor;
import org.hibernate.beanvalidation.tck.tests.constraints.constraintdefinition.AlwaysValid;
import org.hibernate.beanvalidation.tck.tests.constraints.constraintdefinition.Person;
import org.hibernate.beanvalidation.tck.util.TestUtil;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="beanvalidation", version="1.1.0")
public class ConstraintDefinitionsTest
extends Arquillian {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(ConstraintDefinitionsTest.class)).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="3.1.1", id="a"), @SpecAssertion(section="3.2", id="a")})
    public void testConstraintWithCustomAttributes() {
        Validator validator = TestUtil.getValidatorUnderTest();
        Set descriptors = validator.getConstraintsForClass(Person.class).getConstraintsForProperty("lastName").getConstraintDescriptors();
        Assert.assertEquals((int)descriptors.size(), (int)2, (String)"There should be two constraints on the lastName property.");
        for (ConstraintDescriptor descriptor : descriptors) {
            Assert.assertEquals((String)descriptor.getAnnotation().annotationType().getName(), (String)AlwaysValid.class.getName(), (String)"Wrong annotation type.");
        }
        Set constraintViolations = validator.validate((Object)new Person("John", "Doe"), new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 1);
    }

    @Test
    @SpecAssertion(section="3.1.1.2", id="d")
    public void testDefaultGroupAssumedWhenNoGroupsSpecified() {
        Validator validator = TestUtil.getValidatorUnderTest();
        ConstraintDescriptor descriptor = (ConstraintDescriptor)validator.getConstraintsForClass(Person.class).getConstraintsForProperty("firstName").getConstraintDescriptors().iterator().next();
        Set groups = descriptor.getGroups();
        Assert.assertEquals((int)groups.size(), (int)1, (String)"The group set should only contain one entry.");
        Assert.assertEquals(groups.iterator().next(), Default.class, (String)"The Default group should be returned.");
    }
}

