/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.methodvalidation;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Set;
import javax.validation.ElementKind;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import javax.validation.executable.ExecutableValidator;
import javax.validation.groups.Default;
import org.hibernate.beanvalidation.tck.tests.methodvalidation.ValidateConstructorParametersTest;
import org.hibernate.beanvalidation.tck.tests.methodvalidation.constraint.MyCrossParameterConstraint;
import org.hibernate.beanvalidation.tck.tests.methodvalidation.constraint.ValidOrder;
import org.hibernate.beanvalidation.tck.tests.methodvalidation.constraint.ValidOrderService;
import org.hibernate.beanvalidation.tck.tests.methodvalidation.constraint.ValidRetailOrder;
import org.hibernate.beanvalidation.tck.tests.methodvalidation.constraint.ValidRetailOrderService;
import org.hibernate.beanvalidation.tck.tests.methodvalidation.model.Item;
import org.hibernate.beanvalidation.tck.tests.methodvalidation.model.Order;
import org.hibernate.beanvalidation.tck.tests.methodvalidation.service.ExtendedOrderService;
import org.hibernate.beanvalidation.tck.tests.methodvalidation.service.OrderService;
import org.hibernate.beanvalidation.tck.tests.methodvalidation.service.OrderServiceImpl;
import org.hibernate.beanvalidation.tck.tests.methodvalidation.service.OrderServiceWithRedefinedDefaultGroupSequence;
import org.hibernate.beanvalidation.tck.util.TestUtil;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@SpecVersion(spec="beanvalidation", version="1.1.0")
public class MethodValidationTest
extends Arquillian {
    private ExecutableValidator executableValidator;

    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClass(ValidateConstructorParametersTest.class)).withPackage(MyCrossParameterConstraint.class.getPackage())).withPackage(ExtendedOrderService.class.getPackage())).withClass(Item.class)).withClass(Order.class)).build();
    }

    @BeforeMethod
    public void setupValidator() {
        this.executableValidator = TestUtil.getValidatorUnderTest().forExecutables();
    }

    @Test
    @SpecAssertion(section="4.6.2", id="a")
    public void methodParameterValidationTargetsParameterCrossParameterAndCascadedConstraints() throws Exception {
        String methodName = "placeOrder";
        OrderService object = new OrderService();
        Method method = OrderService.class.getMethod(methodName, String.class, Item.class, Integer.TYPE);
        Object[] parameterValues = new Object[]{null, new Item(""), 0};
        Set violations = this.executableValidator.validateParameters((Object)object, method, parameterValues, new Class[0]);
        TestUtil.assertCorrectConstraintTypes(violations, NotNull.class, Min.class, Size.class, MyCrossParameterConstraint.class);
        TestUtil.assertCorrectPathNodeNames(violations, TestUtil.names(methodName, "<cross-parameter>"), TestUtil.names(methodName, "arg0"), TestUtil.names(methodName, "arg1", "name"), TestUtil.names(methodName, "arg2"));
        TestUtil.assertCorrectPathNodeKinds(violations, TestUtil.kinds(ElementKind.METHOD, ElementKind.CROSS_PARAMETER), TestUtil.kinds(ElementKind.METHOD, ElementKind.PARAMETER), TestUtil.kinds(ElementKind.METHOD, ElementKind.PARAMETER, ElementKind.PROPERTY), TestUtil.kinds(ElementKind.METHOD, ElementKind.PARAMETER));
    }

    @Test
    @SpecAssertion(section="4.6.2", id="a")
    public void methodParameterValidationIncludesConstraintsFromSuperClass() throws Exception {
        String methodName = "placeOrder";
        ExtendedOrderService object = new ExtendedOrderService();
        Method method = ExtendedOrderService.class.getMethod(methodName, String.class, Item.class, Integer.TYPE);
        Object[] parameterValues = new Object[]{null, new Item(""), 0};
        Set violations = this.executableValidator.validateParameters((Object)object, method, parameterValues, new Class[0]);
        TestUtil.assertCorrectConstraintTypes(violations, NotNull.class, Min.class, Size.class, MyCrossParameterConstraint.class);
        TestUtil.assertCorrectPathNodeNames(violations, TestUtil.names(methodName, "<cross-parameter>"), TestUtil.names(methodName, "arg0"), TestUtil.names(methodName, "arg1", "name"), TestUtil.names(methodName, "arg2"));
        TestUtil.assertCorrectPathNodeKinds(violations, TestUtil.kinds(ElementKind.METHOD, ElementKind.CROSS_PARAMETER), TestUtil.kinds(ElementKind.METHOD, ElementKind.PARAMETER), TestUtil.kinds(ElementKind.METHOD, ElementKind.PARAMETER, ElementKind.PROPERTY), TestUtil.kinds(ElementKind.METHOD, ElementKind.PARAMETER));
    }

    @Test
    @SpecAssertion(section="4.6.2", id="a")
    public void methodParameterValidationIncludesConstraintsFromImplementedInterface() throws Exception {
        String methodName = "placeOrder";
        OrderServiceImpl object = new OrderServiceImpl();
        Method method = OrderServiceImpl.class.getMethod(methodName, String.class, Item.class, Integer.TYPE);
        Object[] parameterValues = new Object[]{null, new Item(""), 0};
        Set violations = this.executableValidator.validateParameters((Object)object, method, parameterValues, new Class[0]);
        TestUtil.assertCorrectConstraintTypes(violations, NotNull.class, Min.class, Size.class, MyCrossParameterConstraint.class);
        TestUtil.assertCorrectPathNodeNames(violations, TestUtil.names(methodName, "<cross-parameter>"), TestUtil.names(methodName, "arg0"), TestUtil.names(methodName, "arg1", "name"), TestUtil.names(methodName, "arg2"));
        TestUtil.assertCorrectPathNodeKinds(violations, TestUtil.kinds(ElementKind.METHOD, ElementKind.CROSS_PARAMETER), TestUtil.kinds(ElementKind.METHOD, ElementKind.PARAMETER), TestUtil.kinds(ElementKind.METHOD, ElementKind.PARAMETER, ElementKind.PROPERTY), TestUtil.kinds(ElementKind.METHOD, ElementKind.PARAMETER));
    }

    @Test
    @SpecAssertion(section="4.6.2", id="a")
    public void methodParameterValidationIsAppliedGroupWise() throws Exception {
        String methodName = "placeOrder";
        OrderService object = new OrderService();
        Method method = OrderService.class.getMethod(methodName, String.class, Item.class, Integer.class);
        Object[] parameterValues = new Object[]{null, new Item(""), 0};
        Set violations = this.executableValidator.validateParameters((Object)object, method, parameterValues, new Class[]{OrderService.Basic.class});
        TestUtil.assertCorrectConstraintTypes(violations, NotNull.class, MyCrossParameterConstraint.class);
        TestUtil.assertCorrectPathNodeNames(violations, TestUtil.names(methodName, "<cross-parameter>"), TestUtil.names(methodName, "arg0"));
        TestUtil.assertCorrectPathNodeKinds(violations, TestUtil.kinds(ElementKind.METHOD, ElementKind.CROSS_PARAMETER), TestUtil.kinds(ElementKind.METHOD, ElementKind.PARAMETER));
        violations = this.executableValidator.validateParameters((Object)object, method, parameterValues, new Class[0]);
        TestUtil.assertCorrectConstraintTypes(violations, Min.class, Size.class);
        TestUtil.assertCorrectPathNodeNames(violations, TestUtil.names(methodName, "arg1", "name"), TestUtil.names(methodName, "arg2"));
        TestUtil.assertCorrectPathNodeKinds(violations, TestUtil.kinds(ElementKind.METHOD, ElementKind.PARAMETER, ElementKind.PROPERTY), TestUtil.kinds(ElementKind.METHOD, ElementKind.PARAMETER));
    }

    @Test
    @SpecAssertion(section="4.6.2", id="a")
    public void methodParameterValidationPerformsGroupConversion() throws Exception {
        String methodName = "placeOrder";
        OrderService object = new OrderService();
        Method method = OrderService.class.getMethod(methodName, String.class, Item.class, Long.TYPE);
        Object[] parameterValues = new Object[]{null, new Item(""), 0};
        Set violations = this.executableValidator.validateParameters((Object)object, method, parameterValues, new Class[]{OrderService.Basic.class});
        TestUtil.assertCorrectConstraintTypes(violations, Size.class);
        TestUtil.assertCorrectPathNodeNames(violations, TestUtil.names(methodName, "arg1", "name"));
        TestUtil.assertCorrectPathNodeKinds(violations, TestUtil.kinds(ElementKind.METHOD, ElementKind.PARAMETER, ElementKind.PROPERTY));
    }

    @Test
    @SpecAssertion(section="4.6.2", id="a")
    public void methodParameterValidationValidatesEachConstraintOnlyOnce() throws Exception {
        String methodName = "placeOrder";
        OrderService object = new OrderService();
        Method method = OrderService.class.getMethod(methodName, String.class, Item.class, Short.TYPE);
        Object[] parameterValues = new Object[]{null, new Item(""), (short)0};
        Set violations = this.executableValidator.validateParameters((Object)object, method, parameterValues, new Class[]{OrderService.Basic.class, Default.class});
        TestUtil.assertCorrectConstraintTypes(violations, NotNull.class, Min.class, Size.class, MyCrossParameterConstraint.class);
        TestUtil.assertCorrectPathNodeNames(violations, TestUtil.names(methodName, "<cross-parameter>"), TestUtil.names(methodName, "arg0"), TestUtil.names(methodName, "arg1", "name"), TestUtil.names(methodName, "arg2"));
        TestUtil.assertCorrectPathNodeKinds(violations, TestUtil.kinds(ElementKind.METHOD, ElementKind.CROSS_PARAMETER), TestUtil.kinds(ElementKind.METHOD, ElementKind.PARAMETER), TestUtil.kinds(ElementKind.METHOD, ElementKind.PARAMETER, ElementKind.PROPERTY), TestUtil.kinds(ElementKind.METHOD, ElementKind.PARAMETER));
    }

    @Test
    @SpecAssertion(section="4.6.2", id="a")
    public void methodParameterValidationUsingSequence() throws Exception {
        String methodName = "placeOrder";
        OrderService object = new OrderService();
        Method method = OrderService.class.getMethod(methodName, String.class, Item.class, Byte.TYPE);
        Object[] parameterValues = new Object[]{null, new Item(""), (byte)0};
        Set violations = this.executableValidator.validateParameters((Object)object, method, parameterValues, new Class[]{OrderService.OrderServiceSequence.class});
        TestUtil.assertCorrectConstraintTypes(violations, Size.class, NotNull.class);
        TestUtil.assertCorrectPathNodeNames(violations, TestUtil.names(methodName, "arg0"), TestUtil.names(methodName, "arg1", "name"));
        TestUtil.assertCorrectPathNodeKinds(violations, TestUtil.kinds(ElementKind.METHOD, ElementKind.PARAMETER), TestUtil.kinds(ElementKind.METHOD, ElementKind.PARAMETER, ElementKind.PROPERTY));
        parameterValues = new Object[]{"Bob", new Item("BV Specification"), (byte)0};
        violations = this.executableValidator.validateParameters((Object)object, method, parameterValues, new Class[]{OrderService.OrderServiceSequence.class});
        TestUtil.assertCorrectConstraintTypes(violations, MyCrossParameterConstraint.class, Min.class);
        TestUtil.assertCorrectPathNodeNames(violations, TestUtil.names(methodName, "<cross-parameter>"), TestUtil.names(methodName, "arg2"));
        TestUtil.assertCorrectPathNodeKinds(violations, TestUtil.kinds(ElementKind.METHOD, ElementKind.CROSS_PARAMETER), TestUtil.kinds(ElementKind.METHOD, ElementKind.PARAMETER));
    }

    @Test
    @SpecAssertion(section="4.6.2", id="a")
    public void methodParameterValidationWithRedefinedDefaultGroupSequence() throws Exception {
        String methodName = "placeOrder";
        OrderServiceWithRedefinedDefaultGroupSequence object = new OrderServiceWithRedefinedDefaultGroupSequence();
        Method method = OrderServiceWithRedefinedDefaultGroupSequence.class.getMethod(methodName, String.class, Item.class, Byte.TYPE);
        Object[] parameterValues = new Object[]{null, new Item(""), (byte)0};
        Set violations = this.executableValidator.validateParameters((Object)object, method, parameterValues, new Class[0]);
        TestUtil.assertCorrectConstraintTypes(violations, Size.class, NotNull.class);
        TestUtil.assertCorrectPathNodeNames(violations, TestUtil.names(methodName, "arg0"), TestUtil.names(methodName, "arg1", "name"));
        TestUtil.assertCorrectPathNodeKinds(violations, TestUtil.kinds(ElementKind.METHOD, ElementKind.PARAMETER), TestUtil.kinds(ElementKind.METHOD, ElementKind.PARAMETER, ElementKind.PROPERTY));
        parameterValues = new Object[]{"Bob", new Item(""), (byte)0};
        violations = this.executableValidator.validateParameters((Object)object, method, parameterValues, new Class[0]);
        TestUtil.assertCorrectConstraintTypes(violations, MyCrossParameterConstraint.class, Size.class, Min.class);
        TestUtil.assertCorrectPathNodeNames(violations, TestUtil.names(methodName, "<cross-parameter>"), TestUtil.names(methodName, "arg1", "name"), TestUtil.names(methodName, "arg2"));
        TestUtil.assertCorrectPathNodeKinds(violations, TestUtil.kinds(ElementKind.METHOD, ElementKind.CROSS_PARAMETER), TestUtil.kinds(ElementKind.METHOD, ElementKind.PARAMETER, ElementKind.PROPERTY), TestUtil.kinds(ElementKind.METHOD, ElementKind.PARAMETER));
    }

    @Test
    @SpecAssertion(section="4.6.2", id="a")
    public void constructorParameterValidationTargetsParameterCrossParameterAndCascadedConstraints() throws Exception {
        String className = "OrderService";
        Constructor constructor = OrderService.class.getConstructor(String.class, Item.class, Integer.TYPE);
        Object[] parameterValues = new Object[]{null, new Item(""), 0};
        Set violations = this.executableValidator.validateConstructorParameters(constructor, parameterValues, new Class[0]);
        TestUtil.assertCorrectConstraintTypes(violations, NotNull.class, Min.class, Size.class, MyCrossParameterConstraint.class);
        TestUtil.assertCorrectPathNodeNames(violations, TestUtil.names(className, "<cross-parameter>"), TestUtil.names(className, "arg0"), TestUtil.names(className, "arg1", "name"), TestUtil.names(className, "arg2"));
        TestUtil.assertCorrectPathNodeKinds(violations, TestUtil.kinds(ElementKind.CONSTRUCTOR, ElementKind.CROSS_PARAMETER), TestUtil.kinds(ElementKind.CONSTRUCTOR, ElementKind.PARAMETER), TestUtil.kinds(ElementKind.CONSTRUCTOR, ElementKind.PARAMETER, ElementKind.PROPERTY), TestUtil.kinds(ElementKind.CONSTRUCTOR, ElementKind.PARAMETER));
    }

    @Test
    @SpecAssertion(section="4.6.2", id="a")
    public void constructorParameterValidationDoesNotIncludeConstraintsFromSuperClass() throws Exception {
        Constructor constructor = ExtendedOrderService.class.getConstructor(String.class, Item.class, Integer.TYPE);
        Object[] parameterValues = new Object[]{null, new Item(""), 0};
        Set violations = this.executableValidator.validateConstructorParameters(constructor, parameterValues, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(violations, 0);
    }

    @Test
    @SpecAssertion(section="4.6.2", id="a")
    public void constructorParameterValidationIsAppliedGroupWise() throws Exception {
        String className = "OrderService";
        Constructor constructor = OrderService.class.getConstructor(String.class, Item.class, Integer.class);
        Object[] parameterValues = new Object[]{null, new Item(""), 0};
        Set violations = this.executableValidator.validateConstructorParameters(constructor, parameterValues, new Class[]{OrderService.Basic.class});
        TestUtil.assertCorrectConstraintTypes(violations, NotNull.class, MyCrossParameterConstraint.class);
        TestUtil.assertCorrectPathNodeNames(violations, TestUtil.names(className, "<cross-parameter>"), TestUtil.names(className, "arg0"));
        TestUtil.assertCorrectPathNodeKinds(violations, TestUtil.kinds(ElementKind.CONSTRUCTOR, ElementKind.CROSS_PARAMETER), TestUtil.kinds(ElementKind.CONSTRUCTOR, ElementKind.PARAMETER));
        violations = this.executableValidator.validateConstructorParameters(constructor, parameterValues, new Class[0]);
        TestUtil.assertCorrectConstraintTypes(violations, Min.class, Size.class);
        TestUtil.assertCorrectPathNodeNames(violations, TestUtil.names(className, "arg1", "name"), TestUtil.names(className, "arg2"));
        TestUtil.assertCorrectPathNodeKinds(violations, TestUtil.kinds(ElementKind.CONSTRUCTOR, ElementKind.PARAMETER, ElementKind.PROPERTY), TestUtil.kinds(ElementKind.CONSTRUCTOR, ElementKind.PARAMETER));
    }

    @Test
    @SpecAssertion(section="4.6.2", id="a")
    public void constructorParameterValidationPerformsGroupConversion() throws Exception {
        String className = "OrderService";
        Constructor constructor = OrderService.class.getConstructor(String.class, Item.class, Long.TYPE);
        Object[] parameterValues = new Object[]{null, new Item(""), 0};
        Set violations = this.executableValidator.validateConstructorParameters(constructor, parameterValues, new Class[]{OrderService.Basic.class});
        TestUtil.assertCorrectConstraintTypes(violations, Size.class);
        TestUtil.assertCorrectPathNodeNames(violations, TestUtil.names(className, "arg1", "name"));
        TestUtil.assertCorrectPathNodeKinds(violations, TestUtil.kinds(ElementKind.CONSTRUCTOR, ElementKind.PARAMETER, ElementKind.PROPERTY));
    }

    @Test
    @SpecAssertion(section="4.6.2", id="a")
    public void constructorParameterValidationValidatesEachConstraintOnlyOnce() throws Exception {
        String className = "OrderService";
        Constructor constructor = OrderService.class.getConstructor(String.class, Item.class, Short.TYPE);
        Object[] parameterValues = new Object[]{null, new Item(""), (short)0};
        Set violations = this.executableValidator.validateConstructorParameters(constructor, parameterValues, new Class[]{OrderService.Basic.class, Default.class});
        TestUtil.assertCorrectConstraintTypes(violations, NotNull.class, Min.class, Size.class, MyCrossParameterConstraint.class);
        TestUtil.assertCorrectPathNodeNames(violations, TestUtil.names(className, "<cross-parameter>"), TestUtil.names(className, "arg0"), TestUtil.names(className, "arg1", "name"), TestUtil.names(className, "arg2"));
        TestUtil.assertCorrectPathNodeKinds(violations, TestUtil.kinds(ElementKind.CONSTRUCTOR, ElementKind.CROSS_PARAMETER), TestUtil.kinds(ElementKind.CONSTRUCTOR, ElementKind.PARAMETER), TestUtil.kinds(ElementKind.CONSTRUCTOR, ElementKind.PARAMETER, ElementKind.PROPERTY), TestUtil.kinds(ElementKind.CONSTRUCTOR, ElementKind.PARAMETER));
    }

    @Test
    @SpecAssertion(section="4.6.2", id="a")
    public void constructorParameterValidationUsingSequence() throws Exception {
        String className = "OrderService";
        Constructor constructor = OrderService.class.getConstructor(String.class, Item.class, Byte.TYPE);
        Object[] parameterValues = new Object[]{null, new Item(""), (byte)0};
        Set violations = this.executableValidator.validateConstructorParameters(constructor, parameterValues, new Class[]{OrderService.OrderServiceSequence.class});
        TestUtil.assertCorrectConstraintTypes(violations, Size.class, NotNull.class);
        TestUtil.assertCorrectPathNodeNames(violations, TestUtil.names(className, "arg0"), TestUtil.names(className, "arg1", "name"));
        TestUtil.assertCorrectPathNodeKinds(violations, TestUtil.kinds(ElementKind.CONSTRUCTOR, ElementKind.PARAMETER), TestUtil.kinds(ElementKind.CONSTRUCTOR, ElementKind.PARAMETER, ElementKind.PROPERTY));
        parameterValues = new Object[]{"Bob", new Item("BV Specification"), (byte)0};
        violations = this.executableValidator.validateConstructorParameters(constructor, parameterValues, new Class[]{OrderService.OrderServiceSequence.class});
        TestUtil.assertCorrectConstraintTypes(violations, MyCrossParameterConstraint.class, Min.class);
        TestUtil.assertCorrectPathNodeNames(violations, TestUtil.names(className, "<cross-parameter>"), TestUtil.names(className, "arg2"));
        TestUtil.assertCorrectPathNodeKinds(violations, TestUtil.kinds(ElementKind.CONSTRUCTOR, ElementKind.CROSS_PARAMETER), TestUtil.kinds(ElementKind.CONSTRUCTOR, ElementKind.PARAMETER));
    }

    @Test
    @SpecAssertion(section="4.6.2", id="a")
    public void constructorParameterValidationWithRedefinedDefaultGroupSequence() throws Exception {
        String className = "OrderServiceWithRedefinedDefaultGroupSequence";
        Constructor constructor = OrderServiceWithRedefinedDefaultGroupSequence.class.getConstructor(String.class, Item.class, Byte.TYPE);
        Object[] parameterValues = new Object[]{null, new Item(""), (byte)0};
        Set violations = this.executableValidator.validateConstructorParameters(constructor, parameterValues, new Class[0]);
        TestUtil.assertCorrectConstraintTypes(violations, Size.class, NotNull.class);
        TestUtil.assertCorrectPathNodeNames(violations, TestUtil.names(className, "arg0"), TestUtil.names(className, "arg1", "name"));
        TestUtil.assertCorrectPathNodeKinds(violations, TestUtil.kinds(ElementKind.CONSTRUCTOR, ElementKind.PARAMETER), TestUtil.kinds(ElementKind.CONSTRUCTOR, ElementKind.PARAMETER, ElementKind.PROPERTY));
        parameterValues = new Object[]{"Bob", new Item(""), (byte)0};
        violations = this.executableValidator.validateConstructorParameters(constructor, parameterValues, new Class[0]);
        TestUtil.assertCorrectConstraintTypes(violations, MyCrossParameterConstraint.class, Size.class, Min.class);
        TestUtil.assertCorrectPathNodeNames(violations, TestUtil.names(className, "<cross-parameter>"), TestUtil.names(className, "arg1", "name"), TestUtil.names(className, "arg2"));
        TestUtil.assertCorrectPathNodeKinds(violations, TestUtil.kinds(ElementKind.CONSTRUCTOR, ElementKind.CROSS_PARAMETER), TestUtil.kinds(ElementKind.CONSTRUCTOR, ElementKind.PARAMETER, ElementKind.PROPERTY), TestUtil.kinds(ElementKind.CONSTRUCTOR, ElementKind.PARAMETER));
    }

    @Test
    @SpecAssertion(section="4.6.2", id="c")
    public void methodReturnValueValidationTargetsReturnValueAndCascadedConstraints() throws Exception {
        String methodName = "placeOrder";
        OrderService object = new OrderService();
        Method method = OrderService.class.getMethod(methodName, String.class, Item.class, Integer.TYPE);
        Order returnValue = new Order("");
        Set violations = this.executableValidator.validateReturnValue((Object)object, method, (Object)returnValue, new Class[0]);
        TestUtil.assertCorrectConstraintTypes(violations, ValidOrder.class, Size.class);
        TestUtil.assertCorrectPathNodeNames(violations, TestUtil.names(methodName, "<return value>"), TestUtil.names(methodName, "<return value>", "name"));
        TestUtil.assertCorrectPathNodeKinds(violations, TestUtil.kinds(ElementKind.METHOD, ElementKind.RETURN_VALUE), TestUtil.kinds(ElementKind.METHOD, ElementKind.RETURN_VALUE, ElementKind.PROPERTY));
    }

    @Test
    @SpecAssertion(section="4.6.2", id="c")
    public void methodReturnValueValidationIncludesConstraintsFromSuperClass() throws Exception {
        String methodName = "placeOrder";
        ExtendedOrderService object = new ExtendedOrderService();
        Method method = ExtendedOrderService.class.getMethod(methodName, String.class, Item.class, Integer.TYPE);
        Order returnValue = new Order("");
        Set violations = this.executableValidator.validateReturnValue((Object)object, method, (Object)returnValue, new Class[0]);
        TestUtil.assertCorrectConstraintTypes(violations, ValidOrder.class, ValidRetailOrder.class, Size.class);
        TestUtil.assertCorrectPathNodeNames(violations, TestUtil.names(methodName, "<return value>"), TestUtil.names(methodName, "<return value>"), TestUtil.names(methodName, "<return value>", "name"));
        TestUtil.assertCorrectPathNodeKinds(violations, TestUtil.kinds(ElementKind.METHOD, ElementKind.RETURN_VALUE), TestUtil.kinds(ElementKind.METHOD, ElementKind.RETURN_VALUE), TestUtil.kinds(ElementKind.METHOD, ElementKind.RETURN_VALUE, ElementKind.PROPERTY));
    }

    @Test
    @SpecAssertion(section="4.6.2", id="c")
    public void methodReturnValueValidationIncludesConstraintsFromImplementedInterface() throws Exception {
        String methodName = "placeOrder";
        OrderServiceImpl object = new OrderServiceImpl();
        Method method = OrderServiceImpl.class.getMethod(methodName, String.class, Item.class, Integer.TYPE);
        Order returnValue = new Order("");
        Set violations = this.executableValidator.validateReturnValue((Object)object, method, (Object)returnValue, new Class[0]);
        TestUtil.assertCorrectConstraintTypes(violations, ValidOrder.class, ValidRetailOrder.class, Size.class);
        TestUtil.assertCorrectPathNodeNames(violations, TestUtil.names(methodName, "<return value>"), TestUtil.names(methodName, "<return value>"), TestUtil.names(methodName, "<return value>", "name"));
        TestUtil.assertCorrectPathNodeKinds(violations, TestUtil.kinds(ElementKind.METHOD, ElementKind.RETURN_VALUE), TestUtil.kinds(ElementKind.METHOD, ElementKind.RETURN_VALUE), TestUtil.kinds(ElementKind.METHOD, ElementKind.RETURN_VALUE, ElementKind.PROPERTY));
    }

    @Test
    @SpecAssertion(section="4.6.2", id="c")
    public void methodReturnValueValidationIsAppliedGroupWise() throws Exception {
        String methodName = "placeOrder";
        OrderService object = new OrderService();
        Method method = OrderService.class.getMethod(methodName, String.class, Item.class, Integer.class);
        Order returnValue = new Order("");
        Set violations = this.executableValidator.validateReturnValue((Object)object, method, (Object)returnValue, new Class[]{OrderService.Basic.class});
        TestUtil.assertCorrectConstraintTypes(violations, ValidRetailOrder.class);
        TestUtil.assertCorrectPathNodeNames(violations, TestUtil.names(methodName, "<return value>"));
        TestUtil.assertCorrectPathNodeKinds(violations, TestUtil.kinds(ElementKind.METHOD, ElementKind.RETURN_VALUE));
        violations = this.executableValidator.validateReturnValue((Object)object, method, (Object)returnValue, new Class[0]);
        TestUtil.assertCorrectConstraintTypes(violations, ValidOrder.class, Size.class);
        TestUtil.assertCorrectPathNodeNames(violations, TestUtil.names(methodName, "<return value>", "name"), TestUtil.names(methodName, "<return value>"));
        TestUtil.assertCorrectPathNodeKinds(violations, TestUtil.kinds(ElementKind.METHOD, ElementKind.RETURN_VALUE, ElementKind.PROPERTY), TestUtil.kinds(ElementKind.METHOD, ElementKind.RETURN_VALUE));
    }

    @Test
    @SpecAssertion(section="4.6.2", id="c")
    public void methodReturnValueValidationPerformsGroupConversion() throws Exception {
        String methodName = "placeOrder";
        OrderService object = new OrderService();
        Method method = OrderService.class.getMethod(methodName, String.class, Item.class, Long.TYPE);
        Order returnValue = new Order("");
        Set violations = this.executableValidator.validateReturnValue((Object)object, method, (Object)returnValue, new Class[]{OrderService.Basic.class});
        TestUtil.assertCorrectConstraintTypes(violations, Size.class);
        TestUtil.assertCorrectPathNodeNames(violations, TestUtil.names(methodName, "<return value>", "name"));
        TestUtil.assertCorrectPathNodeKinds(violations, TestUtil.kinds(ElementKind.METHOD, ElementKind.RETURN_VALUE, ElementKind.PROPERTY));
    }

    @Test
    @SpecAssertion(section="4.6.2", id="c")
    public void methodReturnValueValidationValidatesEachConstraintOnlyOnce() throws Exception {
        String methodName = "placeOrder";
        OrderService object = new OrderService();
        Method method = OrderService.class.getMethod(methodName, String.class, Item.class, Short.TYPE);
        Order returnValue = new Order("");
        Set violations = this.executableValidator.validateReturnValue((Object)object, method, (Object)returnValue, new Class[]{OrderService.Basic.class, Default.class});
        TestUtil.assertCorrectConstraintTypes(violations, ValidOrder.class);
        TestUtil.assertCorrectPathNodeNames(violations, TestUtil.names(methodName, "<return value>"));
        TestUtil.assertCorrectPathNodeKinds(violations, TestUtil.kinds(ElementKind.METHOD, ElementKind.RETURN_VALUE));
    }

    @Test
    @SpecAssertion(section="4.6.2", id="c")
    public void methodReturnValueValidationUsingSequence() throws Exception {
        String methodName = "placeOrder";
        OrderService object = new OrderService();
        Method method = OrderService.class.getMethod(methodName, String.class, Item.class, Byte.TYPE);
        Order returnValue = new Order("");
        Set violations = this.executableValidator.validateReturnValue((Object)object, method, (Object)returnValue, new Class[]{OrderService.OrderServiceSequence.class});
        TestUtil.assertCorrectConstraintTypes(violations, ValidOrder.class, Size.class);
        TestUtil.assertCorrectPathNodeNames(violations, TestUtil.names(methodName, "<return value>"), TestUtil.names(methodName, "<return value>", "name"));
        TestUtil.assertCorrectPathNodeKinds(violations, TestUtil.kinds(ElementKind.METHOD, ElementKind.RETURN_VALUE), TestUtil.kinds(ElementKind.METHOD, ElementKind.RETURN_VALUE, ElementKind.PROPERTY));
        returnValue = new Order("BV Specification");
        violations = this.executableValidator.validateReturnValue((Object)object, method, (Object)returnValue, new Class[]{OrderService.OrderServiceSequence.class});
        TestUtil.assertCorrectConstraintTypes(violations, ValidRetailOrder.class);
        TestUtil.assertCorrectPathNodeNames(violations, TestUtil.names(methodName, "<return value>"));
        TestUtil.assertCorrectPathNodeKinds(violations, TestUtil.kinds(ElementKind.METHOD, ElementKind.RETURN_VALUE));
    }

    @Test
    @SpecAssertion(section="4.6.2", id="c")
    public void methodReturnValueValidationWithRedefinedDefaultGroupSequence() throws Exception {
        String methodName = "placeOrder";
        OrderServiceWithRedefinedDefaultGroupSequence object = new OrderServiceWithRedefinedDefaultGroupSequence();
        Method method = OrderServiceWithRedefinedDefaultGroupSequence.class.getMethod(methodName, String.class, Item.class, Byte.TYPE);
        Order returnValue = new Order("");
        Set violations = this.executableValidator.validateReturnValue((Object)object, method, (Object)returnValue, new Class[0]);
        TestUtil.assertCorrectConstraintTypes(violations, Size.class, ValidOrder.class);
        TestUtil.assertCorrectPathNodeNames(violations, TestUtil.names(methodName, "<return value>"), TestUtil.names(methodName, "<return value>", "name"));
        TestUtil.assertCorrectPathNodeKinds(violations, TestUtil.kinds(ElementKind.METHOD, ElementKind.RETURN_VALUE), TestUtil.kinds(ElementKind.METHOD, ElementKind.RETURN_VALUE, ElementKind.PROPERTY));
        returnValue = new Order("valid");
        violations = this.executableValidator.validateReturnValue((Object)object, method, (Object)returnValue, new Class[0]);
        TestUtil.assertCorrectConstraintTypes(violations, Size.class, ValidRetailOrder.class);
        TestUtil.assertCorrectPathNodeNames(violations, TestUtil.names(methodName, "<return value>"), TestUtil.names(methodName, "<return value>", "name"));
        TestUtil.assertCorrectPathNodeKinds(violations, TestUtil.kinds(ElementKind.METHOD, ElementKind.RETURN_VALUE), TestUtil.kinds(ElementKind.METHOD, ElementKind.RETURN_VALUE, ElementKind.PROPERTY));
    }

    @Test
    @SpecAssertion(section="4.6.2", id="c")
    public void constructorReturnValueValidationTargetsReturnValueAndCascadedConstraints() throws Exception {
        String className = "OrderService";
        Constructor constructor = OrderService.class.getConstructor(String.class, Item.class, Integer.TYPE);
        OrderService returnValue = new OrderService("");
        Set violations = this.executableValidator.validateConstructorReturnValue(constructor, (Object)returnValue, new Class[0]);
        TestUtil.assertCorrectConstraintTypes(violations, ValidOrderService.class, Size.class);
        TestUtil.assertCorrectPathNodeNames(violations, TestUtil.names(className, "<return value>"), TestUtil.names(className, "<return value>", "name"));
        TestUtil.assertCorrectPathNodeKinds(violations, TestUtil.kinds(ElementKind.CONSTRUCTOR, ElementKind.RETURN_VALUE), TestUtil.kinds(ElementKind.CONSTRUCTOR, ElementKind.RETURN_VALUE, ElementKind.PROPERTY));
    }

    @Test
    @SpecAssertion(section="4.6.2", id="c")
    public void constructorReturnValueValidationDoesNotIncludeConstraintsFromSuperClass() throws Exception {
        String className = "ExtendedOrderService";
        Constructor constructor = ExtendedOrderService.class.getConstructor(String.class, Item.class, Integer.TYPE);
        ExtendedOrderService returnValue = new ExtendedOrderService();
        Set violations = this.executableValidator.validateConstructorReturnValue(constructor, (Object)returnValue, new Class[0]);
        TestUtil.assertCorrectConstraintTypes(violations, ValidRetailOrderService.class);
        TestUtil.assertCorrectPathNodeNames(violations, TestUtil.names(className, "<return value>"));
        TestUtil.assertCorrectPathNodeKinds(violations, TestUtil.kinds(ElementKind.CONSTRUCTOR, ElementKind.RETURN_VALUE));
    }

    @Test
    @SpecAssertion(section="4.6.2", id="c")
    public void constructorReturnValueValidationIsAppliedGroupWise() throws Exception {
        String className = "OrderService";
        Constructor constructor = OrderService.class.getConstructor(String.class, Item.class, Integer.class);
        OrderService returnValue = new OrderService("");
        Set violations = this.executableValidator.validateConstructorReturnValue(constructor, (Object)returnValue, new Class[]{OrderService.Basic.class});
        TestUtil.assertCorrectConstraintTypes(violations, ValidRetailOrderService.class);
        TestUtil.assertCorrectPathNodeNames(violations, TestUtil.names(className, "<return value>"));
        TestUtil.assertCorrectPathNodeKinds(violations, TestUtil.kinds(ElementKind.CONSTRUCTOR, ElementKind.RETURN_VALUE));
        violations = this.executableValidator.validateConstructorReturnValue(constructor, (Object)returnValue, new Class[0]);
        TestUtil.assertCorrectConstraintTypes(violations, ValidOrderService.class, Size.class);
        TestUtil.assertCorrectPathNodeNames(violations, TestUtil.names(className, "<return value>", "name"), TestUtil.names(className, "<return value>"));
        TestUtil.assertCorrectPathNodeKinds(violations, TestUtil.kinds(ElementKind.CONSTRUCTOR, ElementKind.RETURN_VALUE, ElementKind.PROPERTY), TestUtil.kinds(ElementKind.CONSTRUCTOR, ElementKind.RETURN_VALUE));
    }

    @Test
    @SpecAssertion(section="4.6.2", id="c")
    public void constructorReturnValueValidationPerformsGroupConversion() throws Exception {
        String className = "OrderService";
        Constructor constructor = OrderService.class.getConstructor(String.class, Item.class, Long.TYPE);
        OrderService returnValue = new OrderService("");
        Set violations = this.executableValidator.validateConstructorReturnValue(constructor, (Object)returnValue, new Class[]{OrderService.Basic.class});
        TestUtil.assertCorrectConstraintTypes(violations, Size.class);
        TestUtil.assertCorrectPathNodeNames(violations, TestUtil.names(className, "<return value>", "name"));
        TestUtil.assertCorrectPathNodeKinds(violations, TestUtil.kinds(ElementKind.CONSTRUCTOR, ElementKind.RETURN_VALUE, ElementKind.PROPERTY));
    }

    @Test
    @SpecAssertion(section="4.6.2", id="c")
    public void constructorReturnValueValidationValidatesEachConstraintOnlyOnce() throws Exception {
        String className = "OrderService";
        Constructor constructor = OrderService.class.getConstructor(String.class, Item.class, Short.TYPE);
        OrderService returnValue = new OrderService("");
        Set violations = this.executableValidator.validateConstructorReturnValue(constructor, (Object)returnValue, new Class[]{OrderService.Basic.class, Default.class});
        TestUtil.assertCorrectConstraintTypes(violations, ValidOrderService.class);
        TestUtil.assertCorrectPathNodeNames(violations, TestUtil.names(className, "<return value>"));
        TestUtil.assertCorrectPathNodeKinds(violations, TestUtil.kinds(ElementKind.CONSTRUCTOR, ElementKind.RETURN_VALUE));
    }

    @Test
    @SpecAssertion(section="4.6.2", id="c")
    public void constructorReturnValueValidationUsingSequence() throws Exception {
        String className = "OrderService";
        Constructor constructor = OrderService.class.getConstructor(String.class, Item.class, Byte.TYPE);
        OrderService returnValue = new OrderService("");
        Set violations = this.executableValidator.validateConstructorReturnValue(constructor, (Object)returnValue, new Class[]{OrderService.OrderServiceSequence.class});
        TestUtil.assertCorrectConstraintTypes(violations, ValidOrderService.class, Size.class);
        TestUtil.assertCorrectPathNodeNames(violations, TestUtil.names(className, "<return value>"), TestUtil.names(className, "<return value>", "name"));
        TestUtil.assertCorrectPathNodeKinds(violations, TestUtil.kinds(ElementKind.CONSTRUCTOR, ElementKind.RETURN_VALUE), TestUtil.kinds(ElementKind.CONSTRUCTOR, ElementKind.RETURN_VALUE, ElementKind.PROPERTY));
        returnValue = new OrderService("valid order service");
        violations = this.executableValidator.validateConstructorReturnValue(constructor, (Object)returnValue, new Class[]{OrderService.OrderServiceSequence.class});
        TestUtil.assertCorrectConstraintTypes(violations, ValidRetailOrderService.class);
        TestUtil.assertCorrectPathNodeNames(violations, TestUtil.names(className, "<return value>"));
        TestUtil.assertCorrectPathNodeKinds(violations, TestUtil.kinds(ElementKind.CONSTRUCTOR, ElementKind.RETURN_VALUE));
    }

    @Test
    @SpecAssertion(section="4.6.2", id="c")
    public void constructorReturnValueValidationWithRedefinedDefaultGroupSequence() throws Exception {
        String className = "OrderServiceWithRedefinedDefaultGroupSequence";
        Constructor constructor = OrderServiceWithRedefinedDefaultGroupSequence.class.getConstructor(String.class, Item.class, Byte.TYPE);
        OrderServiceWithRedefinedDefaultGroupSequence returnValue = new OrderServiceWithRedefinedDefaultGroupSequence("");
        Set violations = this.executableValidator.validateConstructorReturnValue(constructor, (Object)returnValue, new Class[0]);
        TestUtil.assertCorrectConstraintTypes(violations, Size.class, ValidOrderService.class);
        TestUtil.assertCorrectPathNodeNames(violations, TestUtil.names(className, "<return value>"), TestUtil.names(className, "<return value>", "name"));
        TestUtil.assertCorrectPathNodeKinds(violations, TestUtil.kinds(ElementKind.CONSTRUCTOR, ElementKind.RETURN_VALUE), TestUtil.kinds(ElementKind.CONSTRUCTOR, ElementKind.RETURN_VALUE, ElementKind.PROPERTY));
        returnValue = new OrderServiceWithRedefinedDefaultGroupSequence("valid");
        violations = this.executableValidator.validateConstructorReturnValue(constructor, (Object)returnValue, new Class[0]);
        TestUtil.assertCorrectConstraintTypes(violations, Pattern.class, ValidRetailOrderService.class);
        TestUtil.assertCorrectPathNodeNames(violations, TestUtil.names(className, "<return value>"), TestUtil.names(className, "<return value>", "name"));
        TestUtil.assertCorrectPathNodeKinds(violations, TestUtil.kinds(ElementKind.CONSTRUCTOR, ElementKind.RETURN_VALUE), TestUtil.kinds(ElementKind.CONSTRUCTOR, ElementKind.RETURN_VALUE, ElementKind.PROPERTY));
    }
}

