/*
* JBoss, Home of Professional Open Source
* Copyright 2013, Red Hat, Inc. and/or its affiliates, and individual contributors
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
* http://www.apache.org/licenses/LICENSE-2.0
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
package org.hibernate.beanvalidation.tck.tests.validation.groupconversion;

import java.util.List;
import javax.validation.Valid;
import javax.validation.groups.ConvertGroup;
import javax.validation.groups.Default;

/**
 * @author Gunnar Morling
 */
public class EndUserImpl extends User implements EndUser {

	public EndUserImpl(Address mainAddress, List<Address> shipmentAddresses, Address preferredShipmentAddress, Address officeAddress, Address weekendAddress) {
		super(
				mainAddress,
				shipmentAddresses,
				preferredShipmentAddress,
				officeAddress,
				weekendAddress
		);
	}

	@Valid
	@ConvertGroup(from = Default.class, to = BasicPostal.class)
	@Override
	public Address retrieveWeekendAddress() {
		return null;
	}

	@Valid
	@ConvertGroup(from = Default.class, to = BasicPostal.class)
	@Override
	public Address retrieveFallbackAddress() {
		return null;
	}
}
