/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.constraints.crossparameter;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Date;
import javax.validation.ConstraintDeclarationException;
import javax.validation.ConstraintTarget;
import javax.validation.Validator;
import javax.validation.executable.ExecutableValidator;
import org.hibernate.beanvalidation.tck.tests.constraints.crossparameter.GenericAndCrossParameterConstraint;
import org.hibernate.beanvalidation.tck.util.TestUtil;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@SpecVersion(spec="beanvalidation", version="1.1.0")
public class InvalidDeclarationOfGenericAndCrossParameterConstraintTest
extends Arquillian {
    private Validator validator;
    private ExecutableValidator executableValidator;

    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(InvalidDeclarationOfGenericAndCrossParameterConstraintTest.class)).build();
    }

    @BeforeMethod
    public void setupValidator() {
        this.validator = TestUtil.getValidatorUnderTest();
        this.executableValidator = this.validator.forExecutables();
    }

    @Test(expectedExceptions={ConstraintDeclarationException.class})
    @SpecAssertions(value={@SpecAssertion(section="3.1.1.4", id="c"), @SpecAssertion(section="3.1.1.4", id="d"), @SpecAssertion(section="4.5.2.1", id="c"), @SpecAssertion(section="4.5.3", id="b")})
    public void testConstraintTargetImplicitOnMethodWithParametersAndReturnValueCausesException() throws Exception {
        Foo object = new Foo();
        Method method = Foo.class.getMethod("createEvent", Date.class, Date.class);
        Object[] parameterValues = new Object[2];
        this.executableValidator.validateParameters((Object)object, method, parameterValues, new Class[0]);
        Assert.fail((String)"Usage of ConstraintTarget.IMPLICIT not allowed for methods with parameters and return value. Expected exception wasn't thrown.");
    }

    @Test(expectedExceptions={ConstraintDeclarationException.class})
    @SpecAssertions(value={@SpecAssertion(section="3.1.1.4", id="c"), @SpecAssertion(section="3.1.1.4", id="d"), @SpecAssertion(section="4.5.2.1", id="c"), @SpecAssertion(section="4.5.3", id="b")})
    public void testConstraintTargetImplicitOnConstructorWithParametersCausesException() throws Exception {
        Constructor constructor = Bar.class.getConstructor(Date.class, Date.class);
        Object[] parameterValues = new Object[2];
        this.executableValidator.validateConstructorParameters(constructor, parameterValues, new Class[0]);
        Assert.fail((String)"Usage of ConstraintTarget.IMPLICIT not allowed for constructors with parameters. Expected exception wasn't thrown.");
    }

    @Test(expectedExceptions={ConstraintDeclarationException.class})
    @SpecAssertions(value={@SpecAssertion(section="3.1.1.4", id="c"), @SpecAssertion(section="3.1.1.4", id="e"), @SpecAssertion(section="4.5.2.1", id="b")})
    public void testConstraintTargetParametersOnMethodWithoutParametersCausesException() throws Exception {
        Qux object = new Qux();
        Method method = Qux.class.getMethod("qux", new Class[0]);
        Object[] parameterValues = new Object[]{};
        this.executableValidator.validateParameters((Object)object, method, parameterValues, new Class[0]);
        Assert.fail((String)"Usage of ConstraintTarget.PARAMETERS not allowed for methods without parameters. Expected exception wasn't thrown.");
    }

    @Test(expectedExceptions={ConstraintDeclarationException.class})
    @SpecAssertions(value={@SpecAssertion(section="3.1.1.4", id="c"), @SpecAssertion(section="3.1.1.4", id="e"), @SpecAssertion(section="4.5.2.1", id="b")})
    public void testConstraintTargetParametersOnConstructorWithoutParametersCausesException() throws Exception {
        Constructor constructor = Baz.class.getConstructor(new Class[0]);
        Object[] parameterValues = new Object[]{};
        this.executableValidator.validateConstructorParameters(constructor, parameterValues, new Class[0]);
        Assert.fail((String)"Usage of ConstraintTarget.PARAMETERS not allowed for constructors without parameters. Expected exception wasn't thrown.");
    }

    @Test(expectedExceptions={ConstraintDeclarationException.class})
    @SpecAssertions(value={@SpecAssertion(section="3.1.1.4", id="c"), @SpecAssertion(section="3.1.1.4", id="f")})
    public void testConstraintTargetReturnValueOnVoidMethodCausesException() throws Exception {
        Zap object = new Zap();
        Method method = Zap.class.getMethod("zap", new Class[0]);
        Object returnValue = null;
        this.executableValidator.validateReturnValue((Object)object, method, returnValue, new Class[0]);
        Assert.fail((String)"Usage of ConstraintTarget.RETURN_VALUE not allowed for methods without return value. Expected exception wasn't thrown.");
    }

    @Test(expectedExceptions={ConstraintDeclarationException.class})
    @SpecAssertions(value={@SpecAssertion(section="3.1.1.4", id="c"), @SpecAssertion(section="3.1.1.4", id="g")})
    public void testConstraintTargetParametersOnClassCausesException() throws Exception {
        this.validator.validate((Object)new TypeWithConstraintTargetParameter(), new Class[0]);
        Assert.fail((String)"Usage of ConstraintTarget.PARAMETERS not allowed on type definitions. Expected exception wasn't thrown.");
    }

    @Test(expectedExceptions={ConstraintDeclarationException.class})
    @SpecAssertions(value={@SpecAssertion(section="3.1.1.4", id="c"), @SpecAssertion(section="3.1.1.4", id="g")})
    public void testConstraintTargetReturnValueOnClassCausesException() throws Exception {
        this.validator.validate((Object)new TypeWithConstraintTargetReturnValue(), new Class[0]);
        Assert.fail((String)"Usage of ConstraintTarget.RETURN_VALUE not allowed on type definitions. Expected exception wasn't thrown.");
    }

    @Test(expectedExceptions={ConstraintDeclarationException.class})
    @SpecAssertions(value={@SpecAssertion(section="3.1.1.4", id="c"), @SpecAssertion(section="3.1.1.4", id="g")})
    public void testConstraintTargetParametersOnInterfaceCausesException() throws Exception {
        this.validator.validate((Object)new InterfaceWithConstraintTargetParameterImpl(), new Class[0]);
        Assert.fail((String)"Usage of ConstraintTarget.PARAMETERS not allowed on interface definitions. Expected exception wasn't thrown.");
    }

    @Test(expectedExceptions={ConstraintDeclarationException.class})
    @SpecAssertions(value={@SpecAssertion(section="3.1.1.4", id="c"), @SpecAssertion(section="3.1.1.4", id="g")})
    public void testConstraintTargetReturnValueOnInterfaceCausesException() throws Exception {
        this.validator.validate((Object)new InterfaceWithConstraintTargetReturnValueImpl(), new Class[0]);
        Assert.fail((String)"Usage of ConstraintTarget.RETURN_VALUE not allowed on interface definitions. Expected exception wasn't thrown.");
    }

    @Test(expectedExceptions={ConstraintDeclarationException.class})
    @SpecAssertions(value={@SpecAssertion(section="3.1.1.4", id="c"), @SpecAssertion(section="3.1.1.4", id="g")})
    public void testConstraintTargetParametersOnFieldCausesException() throws Exception {
        this.validator.validate((Object)new TypeWithFieldWithConstraintTargetParameter(), new Class[0]);
        Assert.fail((String)"Usage of ConstraintTarget.PARAMETERS not allowed on fields. Expected exception wasn't thrown.");
    }

    @Test(expectedExceptions={ConstraintDeclarationException.class})
    @SpecAssertions(value={@SpecAssertion(section="3.1.1.4", id="c"), @SpecAssertion(section="3.1.1.4", id="g")})
    public void testConstraintTargetReturnValueOnFieldCausesException() throws Exception {
        this.validator.validate((Object)new TypeWithFieldWithConstraintTargetReturnValue(), new Class[0]);
        Assert.fail((String)"Usage of ConstraintTarget.RETURN_VALUE not allowed on fields. Expected exception wasn't thrown.");
    }

    private static class TypeWithFieldWithConstraintTargetReturnValue {
        @GenericAndCrossParameterConstraint(validationAppliesTo=ConstraintTarget.RETURN_VALUE)
        private String foo;

        private TypeWithFieldWithConstraintTargetReturnValue() {
        }
    }

    private static class TypeWithFieldWithConstraintTargetParameter {
        @GenericAndCrossParameterConstraint(validationAppliesTo=ConstraintTarget.PARAMETERS)
        private String foo;

        private TypeWithFieldWithConstraintTargetParameter() {
        }
    }

    private static class InterfaceWithConstraintTargetReturnValueImpl
    implements InterfaceWithConstraintTargetReturnValue {
        private InterfaceWithConstraintTargetReturnValueImpl() {
        }
    }

    @GenericAndCrossParameterConstraint(validationAppliesTo=ConstraintTarget.RETURN_VALUE)
    private static interface InterfaceWithConstraintTargetReturnValue {
    }

    private static class InterfaceWithConstraintTargetParameterImpl
    implements InterfaceWithConstraintTargetParameter {
        private InterfaceWithConstraintTargetParameterImpl() {
        }
    }

    @GenericAndCrossParameterConstraint(validationAppliesTo=ConstraintTarget.PARAMETERS)
    private static interface InterfaceWithConstraintTargetParameter {
    }

    @GenericAndCrossParameterConstraint(validationAppliesTo=ConstraintTarget.RETURN_VALUE)
    private static class TypeWithConstraintTargetReturnValue {
        private TypeWithConstraintTargetReturnValue() {
        }
    }

    @GenericAndCrossParameterConstraint(validationAppliesTo=ConstraintTarget.PARAMETERS)
    private static class TypeWithConstraintTargetParameter {
        private TypeWithConstraintTargetParameter() {
        }
    }

    private static class Zap {
        private Zap() {
        }

        @GenericAndCrossParameterConstraint(validationAppliesTo=ConstraintTarget.RETURN_VALUE)
        public void zap() {
        }
    }

    private static class Baz {
        @GenericAndCrossParameterConstraint(validationAppliesTo=ConstraintTarget.PARAMETERS)
        public Baz() {
        }
    }

    private static class Qux {
        private Qux() {
        }

        @GenericAndCrossParameterConstraint(validationAppliesTo=ConstraintTarget.PARAMETERS)
        public void qux() {
        }
    }

    private static class Bar {
        @GenericAndCrossParameterConstraint(validationAppliesTo=ConstraintTarget.IMPLICIT)
        public Bar(Date start, Date end) {
        }
    }

    private static class Foo {
        private Foo() {
        }

        @GenericAndCrossParameterConstraint(validationAppliesTo=ConstraintTarget.IMPLICIT)
        public Object createEvent(Date start, Date end) {
            return null;
        }
    }
}

