/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.xmlconfiguration.groupconversion;

import java.util.List;
import java.util.Set;
import javax.validation.metadata.ConstructorDescriptor;
import javax.validation.metadata.MethodDescriptor;
import javax.validation.metadata.ParameterDescriptor;
import javax.validation.metadata.PropertyDescriptor;
import javax.validation.metadata.ReturnValueDescriptor;
import org.hibernate.beanvalidation.tck.tests.xmlconfiguration.groupconversion.Groups;
import org.hibernate.beanvalidation.tck.util.TestUtil;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="beanvalidation", version="1.1.0")
public class GroupConversionTest
extends Arquillian {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(GroupConversionTest.class)).withValidationXml("validation-GroupConversionTest.xml")).withResource("GroupConversionTest.xml")).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="8.1.1.7", id="a"), @SpecAssertion(section="8.1.1.7", id="b")})
    public void testGroupConversionsAppliedOnMethod() throws Exception {
        MethodDescriptor methodDescriptor = TestUtil.getMethodDescriptor(Groups.class, "convert", String.class);
        Assert.assertNotNull((Object)methodDescriptor, (String)"the specified method should be configured in xml");
        ReturnValueDescriptor returnValueDescriptor = methodDescriptor.getReturnValueDescriptor();
        Set groupConversionDescriptors = returnValueDescriptor.getGroupConversions();
        Assert.assertTrue((groupConversionDescriptors.size() == 2 ? 1 : 0) != 0);
        List parameterDescriptors = methodDescriptor.getParameterDescriptors();
        Assert.assertTrue((parameterDescriptors.size() == 1 ? 1 : 0) != 0);
        ParameterDescriptor parameterDescriptor = (ParameterDescriptor)parameterDescriptors.get(0);
        groupConversionDescriptors = parameterDescriptor.getGroupConversions();
        Assert.assertTrue((groupConversionDescriptors.size() == 1 ? 1 : 0) != 0);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="8.1.1.7", id="a"), @SpecAssertion(section="8.1.1.7", id="b")})
    public void testGroupConversionsAppliedOnConstructor() throws Exception {
        ConstructorDescriptor constructorDescriptor = TestUtil.getConstructorDescriptor(Groups.class, new Class[0]);
        Assert.assertNotNull((Object)constructorDescriptor, (String)"the specified constructor should be configured in xml");
        ReturnValueDescriptor returnValueDescriptor = constructorDescriptor.getReturnValueDescriptor();
        Set groupConversionDescriptors = returnValueDescriptor.getGroupConversions();
        Assert.assertTrue((groupConversionDescriptors.size() == 1 ? 1 : 0) != 0);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="8.1.1.7", id="a"), @SpecAssertion(section="8.1.1.7", id="b")})
    public void testGroupConversionsAppliedOnField() throws Exception {
        PropertyDescriptor propertyDescriptor = TestUtil.getPropertyDescriptor(Groups.class, "foo");
        Assert.assertNotNull((Object)propertyDescriptor, (String)"the specified property should be configured in xml");
        Set groupConversionDescriptors = propertyDescriptor.getGroupConversions();
        Assert.assertTrue((groupConversionDescriptors.size() == 2 ? 1 : 0) != 0);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="8.1.1.7", id="a"), @SpecAssertion(section="8.1.1.7", id="b")})
    public void testGroupConversionsAppliedOnGetter() throws Exception {
        PropertyDescriptor propertyDescriptor = TestUtil.getPropertyDescriptor(Groups.class, "snafu");
        Assert.assertNotNull((Object)propertyDescriptor, (String)"the specified property should be configured in xml");
        Set groupConversionDescriptors = propertyDescriptor.getGroupConversions();
        Assert.assertTrue((groupConversionDescriptors.size() == 3 ? 1 : 0) != 0);
    }
}

