/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.validation.Path;

public class PathNodeNames
implements Comparable<PathNodeNames> {
    private final List<String> nodeNames;

    PathNodeNames(String ... nodeNames) {
        this.nodeNames = Arrays.asList(nodeNames);
    }

    PathNodeNames(Path path) {
        this.nodeNames = new ArrayList<String>();
        for (Path.Node node : path) {
            this.nodeNames.add(node.getName());
        }
    }

    @Override
    public int compareTo(PathNodeNames other) {
        return this.toString().compareTo(other.toString());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.nodeNames == null ? 0 : this.nodeNames.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PathNodeNames other = (PathNodeNames)obj;
        return !(this.nodeNames == null ? other.nodeNames != null : !this.nodeNames.equals(other.nodeNames));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        Iterator<String> nodeNameIterator = this.nodeNames.iterator();
        while (nodeNameIterator.hasNext()) {
            sb.append(nodeNameIterator.next());
            if (nodeNameIterator.hasNext()) {
                sb.append(".");
                continue;
            }
            return sb.toString();
        }
        return sb.toString();
    }
}

