/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.integration.cdi.executable.global;

import javax.inject.Inject;
import javax.validation.ConstraintViolationException;
import javax.validation.constraints.NotNull;
import org.hibernate.beanvalidation.tck.tests.integration.cdi.executable.global.CalendarService;
import org.hibernate.beanvalidation.tck.tests.integration.cdi.executable.global.Event;
import org.hibernate.beanvalidation.tck.util.IntegrationTest;
import org.hibernate.beanvalidation.tck.util.TestUtil;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@IntegrationTest
@SpecVersion(spec="beanvalidation", version="2.0.0")
public class ExecutableValidationBasedOnGlobalConfigurationTest
extends Arquillian {
    @Inject
    private CalendarService calendar;

    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(ExecutableValidationBasedOnGlobalConfigurationTest.class)).withValidationXml("validation-ExecutableValidationBasedOnGlobalConfigurationTest.xml")).withEmptyBeansXml().build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="5.5.6", id="k"), @SpecAssertion(section="10.1.2", id="g")})
    public void testValidationOfConstrainedMethodOnTypeAnnotatedWithValidateOnExecutionContainingExecutableType() {
        try {
            this.calendar.getEvent();
            Assert.fail((String)"Method invocation should have caused a ConstraintViolationException");
        }
        catch (ConstraintViolationException e) {
            TestUtil.assertCorrectConstraintTypes(e.getConstraintViolations(), NotNull.class);
        }
    }

    @Test
    @SpecAssertion(section="10.1.2", id="g")
    public void testValidationOfConstrainedMethodOnTypeAnnotatedWithValidateOnExecutionNotContainingExecutableType() {
        Event event = this.calendar.createEvent(null);
        Assert.assertNotNull((Object)event);
    }
}

