/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.metadata;

import javax.validation.metadata.ConstructorDescriptor;
import javax.validation.metadata.MethodDescriptor;
import javax.validation.metadata.ParameterDescriptor;
import org.hibernate.beanvalidation.tck.tests.metadata.Item;
import org.hibernate.beanvalidation.tck.tests.metadata.OrderLine;
import org.hibernate.beanvalidation.tck.util.TestUtil;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="beanvalidation", version="2.0.0")
public class ExecutableDescriptorIgnoresValidatedExecutableAnnotationSettingsTest
extends Arquillian {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClass(ExecutableDescriptorIgnoresValidatedExecutableAnnotationSettingsTest.class)).withClasses(Item.class, OrderLine.class)).build();
    }

    @Test
    @SpecAssertion(section="6.7", id="h")
    public void testMethodDescriptorCanBeRetrievedAlsoIfValidateExecutableIsSetToNONEOnTypeLevel() {
        MethodDescriptor descriptor = TestUtil.getMethodDescriptor(OrderLine.class, "setItem", String.class);
        Assert.assertNotNull((Object)descriptor);
        Assert.assertEquals((String)descriptor.getName(), (String)"setItem");
        Assert.assertEquals((int)((ParameterDescriptor)descriptor.getParameterDescriptors().get(0)).getConstraintDescriptors().size(), (int)1);
    }

    @Test
    @SpecAssertion(section="6.7", id="h")
    public void testConstructorDescriptorCanBeRetrievedAlsoIfValidateExecutableIsSetToNONEOnTypeLevel() {
        ConstructorDescriptor descriptor = TestUtil.getConstructorDescriptor(OrderLine.class, String.class);
        Assert.assertNotNull((Object)descriptor);
        Assert.assertEquals((String)descriptor.getName(), (String)"OrderLine");
        Assert.assertEquals((int)((ParameterDescriptor)descriptor.getParameterDescriptors().get(0)).getConstraintDescriptors().size(), (int)1);
    }

    @Test
    @SpecAssertion(section="6.7", id="h")
    public void testMethodDescriptorCanBeRetrievedAlsoIfValidateExecutableIsSetToNONEOnMethodLevel() {
        MethodDescriptor descriptor = TestUtil.getMethodDescriptor(Item.class, "setName", String.class);
        Assert.assertNotNull((Object)descriptor);
        Assert.assertEquals((String)descriptor.getName(), (String)"setName");
        Assert.assertEquals((int)((ParameterDescriptor)descriptor.getParameterDescriptors().get(0)).getConstraintDescriptors().size(), (int)1);
    }

    @Test
    @SpecAssertion(section="6.7", id="h")
    public void testConstructorDescriptorCanBeRetrievedAlsoIfValidateExecutableIsSetToNONEOnConstructorLevel() {
        ConstructorDescriptor descriptor = TestUtil.getConstructorDescriptor(Item.class, String.class);
        Assert.assertNotNull((Object)descriptor);
        Assert.assertEquals((String)descriptor.getName(), (String)"Item");
        Assert.assertEquals((int)((ParameterDescriptor)descriptor.getParameterDescriptors().get(0)).getConstraintDescriptors().size(), (int)1);
    }
}

