/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.time;

import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.util.Set;
import javax.validation.ClockProvider;
import javax.validation.Configuration;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.constraints.Past;
import org.hibernate.beanvalidation.tck.tests.time.FixedClockProvider;
import org.hibernate.beanvalidation.tck.util.TestUtil;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="beanvalidation", version="2.0.0")
public class ClockProviderTest
extends Arquillian {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(ClockProviderTest.class)).build();
    }

    @Test
    @SpecAssertion(section="", id="")
    public void testCustomClockProviderFromValidatorFactory() {
        Configuration<?> configuration = TestUtil.getConfigurationUnderTest();
        CustomClockProvider clockProvider = new CustomClockProvider();
        configuration.clockProvider((ClockProvider)clockProvider);
        ValidatorFactory factory = configuration.buildValidatorFactory();
        Assert.assertSame((Object)factory.getClockProvider(), (Object)clockProvider);
    }

    @Test
    @SpecAssertion(section="", id="")
    public void testDefaultClockProviderIsNotNull() {
        Configuration<?> config = TestUtil.getConfigurationUnderTest();
        Assert.assertNotNull((Object)config.getDefaultClockProvider());
    }

    @Test
    @SpecAssertion(section="", id="")
    public void testCustomClockProviderViaConfiguration() {
        Validator validator = TestUtil.getValidatorUnderTest();
        Person person = new Person();
        person.setBirthday(Instant.now().minus(Duration.ofDays(15L)));
        Set constraintViolations = validator.validate((Object)person, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 0);
        person.setBirthday(Instant.now().plus(Duration.ofDays(15L)));
        constraintViolations = validator.validate((Object)person, new Class[0]);
        TestUtil.assertCorrectPropertyPaths(constraintViolations, "birthday");
        validator = TestUtil.getConfigurationUnderTest().clockProvider((ClockProvider)new FixedClockProvider(ZonedDateTime.now().plus(Duration.ofDays(60L)))).buildValidatorFactory().getValidator();
        person.setBirthday(Instant.now().plus(Duration.ofDays(15L)));
        constraintViolations = validator.validate((Object)person, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 0);
        person.setBirthday(Instant.now().plus(Duration.ofDays(90L)));
        constraintViolations = validator.validate((Object)person, new Class[0]);
        TestUtil.assertCorrectPropertyPaths(constraintViolations, "birthday");
    }

    @Test(expectedExceptions={ValidationException.class})
    @SpecAssertion(section="", id="")
    public void testClockProviderExceptionsGetWrappedInValidationException() {
        ExceptionThrowingClockProvider clockProvider = new ExceptionThrowingClockProvider();
        Configuration config = TestUtil.getConfigurationUnderTest().clockProvider((ClockProvider)clockProvider);
        ValidatorFactory factory = config.buildValidatorFactory();
        Validator v = factory.getValidator();
        Person person = new Person();
        person.setBirthday(Instant.now().minus(Duration.ofDays(3L)));
        v.validate((Object)person, new Class[0]);
    }

    @Test
    @SpecAssertion(section="", id="")
    public void canConfigureClockProviderForValidator() {
        Validator validator = TestUtil.getValidatorUnderTest();
        Person person = new Person();
        person.setBirthday(Instant.now().plus(Duration.ofDays(15L)));
        Set constraintViolations = validator.validate((Object)person, new Class[0]);
        TestUtil.assertCorrectPropertyPaths(constraintViolations, "birthday");
        validator = TestUtil.getValidatorFactoryUnderTest().usingContext().clockProvider((ClockProvider)new FixedClockProvider(ZonedDateTime.now().plus(Duration.ofDays(60L)))).getValidator();
        constraintViolations = validator.validate((Object)person, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 0);
    }

    private static class ExceptionThrowingClockProvider
    implements ClockProvider {
        private ExceptionThrowingClockProvider() {
        }

        public Clock getClock() {
            throw new RuntimeException("This clock provider throws an exception that should be wrapped in a ValidationException");
        }
    }

    private static class CustomClockProvider
    implements ClockProvider {
        private CustomClockProvider() {
        }

        public Clock getClock() {
            return Clock.systemDefaultZone();
        }
    }

    private static class Person {
        @Past
        private Instant birthday;

        private Person() {
        }

        public void setBirthday(Instant birthday) {
            this.birthday = birthday;
        }
    }
}

