/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.validation;

import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.constraints.Size;
import org.hibernate.beanvalidation.tck.tests.validation.Address;
import org.hibernate.beanvalidation.tck.tests.validation.BadlyBehavedEntity;
import org.hibernate.beanvalidation.tck.tests.validation.Customer;
import org.hibernate.beanvalidation.tck.tests.validation.Order;
import org.hibernate.beanvalidation.tck.tests.validation.Person;
import org.hibernate.beanvalidation.tck.util.TestUtil;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@SpecVersion(spec="beanvalidation", version="2.0.0")
public class ValidatePropertyTest
extends Arquillian {
    private Validator validator;

    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClass(ValidatePropertyTest.class)).withClasses(Customer.class, Person.class, Order.class, Address.class, BadlyBehavedEntity.class)).build();
    }

    @BeforeMethod
    public void setupValidator() {
        this.validator = TestUtil.getValidatorUnderTest();
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    @SpecAssertion(section="5.1.1", id="e")
    public void testPassingNullAsGroup() {
        Customer customer = new Customer();
        this.validator.validateProperty((Object)customer, "firstName", new Class[]{null});
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    @SpecAssertion(section="5.1.1", id="e")
    public void testIllegalArgumentExceptionIsThrownForNullValue() {
        this.validator.validateProperty(null, "firstName", new Class[0]);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="5.1.1", id="e"), @SpecAssertion(section="5.1.1", id="f")})
    public void testValidatePropertyWithInvalidPropertyPath() {
        Customer customer = new Customer();
        try {
            this.validator.validateProperty((Object)customer, "foobar", new Class[0]);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.validator.validateProperty((Object)customer, "FirstName", new Class[0]);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    @SpecAssertion(section="5.1.1", id="e")
    public void testValidatePropertyWithNullProperty() {
        Customer customer = new Customer();
        this.validator.validateProperty((Object)customer, null, new Class[0]);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    @SpecAssertion(section="5.1.1", id="e")
    public void testValidatePropertyWithEmptyProperty() {
        Customer customer = new Customer();
        Order order = new Order();
        customer.addOrder(order);
        this.validator.validateProperty((Object)customer, "", new Class[0]);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="5.1.1", id="c"), @SpecAssertion(section="5.1.1", id="d"), @SpecAssertion(section="5.1.1", id="f"), @SpecAssertion(section="5.2", id="e"), @SpecAssertion(section="5.2", id="f"), @SpecAssertion(section="5.2", id="g"), @SpecAssertion(section="5.2", id="h"), @SpecAssertion(section="5.2", id="i")})
    public void testValidateProperty() {
        Address address = new Address();
        address.setStreet(null);
        address.setZipCode(null);
        String townInNorthWales = "Llanfairpwllgwyngyllgogerychwyrndrobwyll-llantysiliogogogoch";
        address.setCity(townInNorthWales);
        Set constraintViolations = this.validator.validateProperty((Object)address, "city", new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 1);
        TestUtil.assertCorrectConstraintTypes(constraintViolations, Size.class);
        ConstraintViolation violation = (ConstraintViolation)constraintViolations.iterator().next();
        TestUtil.assertConstraintViolation(violation, Address.class, townInNorthWales, "city");
        Assert.assertEquals((Object)violation.getRootBean(), (Object)address);
        Assert.assertEquals((Object)violation.getLeafBean(), (Object)address);
        Assert.assertEquals((Object)violation.getInvalidValue(), (Object)townInNorthWales);
        Assert.assertNull((Object)violation.getExecutableParameters());
        Assert.assertNull((Object)violation.getExecutableReturnValue());
        TestUtil.assertCorrectConstraintViolationMessages(constraintViolations, "City name cannot be longer than 30 characters.");
        address.setCity("London");
        constraintViolations = this.validator.validateProperty((Object)address, "city", new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 0);
    }

    @Test
    @SpecAssertion(section="5.1.1", id="g")
    public void testValidIsNotHonoredValidateProperty() {
        Customer customer = new Customer();
        Order order = new Order();
        customer.addOrder(order);
        Set constraintViolations = this.validator.validateProperty((Object)customer, "orders", new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 0);
    }

    @Test(expectedExceptions={ValidationException.class})
    @SpecAssertion(section="5.1.1", id="k")
    public void testUnexpectedExceptionsInValidatePropertyGetWrappedInValidationExceptions() {
        this.validator.validateProperty((Object)new BadlyBehavedEntity(), "value", new Class[0]);
    }
}

