/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.validation.validatorcontext;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.validation.Constraint;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import javax.validation.Payload;
import javax.validation.ValidationException;
import javax.validation.Validator;
import org.hibernate.beanvalidation.tck.tests.validation.validatorcontext.DummyBean;
import org.hibernate.beanvalidation.tck.tests.validation.validatorcontext.DummyValidator;
import org.hibernate.beanvalidation.tck.util.TestUtil;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.annotations.Test;

@SpecVersion(spec="beanvalidation", version="2.0.0")
public class ConstraintValidatorContextTest
extends Arquillian {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(ConstraintValidatorContextTest.class)).build();
    }

    @Test
    @SpecAssertion(section="3.4", id="o")
    public void testDefaultError() {
        Validator validator = TestUtil.getValidatorUnderTest();
        DummyValidator.disableDefaultError(false);
        DummyValidator.setCustomErrorMessages(null);
        DummyBean bean = new DummyBean("foobar");
        Set constraintViolations = validator.validate((Object)bean, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 1);
        TestUtil.assertCorrectConstraintViolationMessages(constraintViolations, "dummy message");
    }

    @Test(expectedExceptions={ValidationException.class})
    @SpecAssertion(section="3.4", id="t")
    public void testDisableDefaultErrorWithoutAddingCustomError() {
        Validator validator = TestUtil.getValidatorUnderTest();
        DummyValidator.disableDefaultError(true);
        HashMap<String, String> errors = new HashMap<String, String>();
        DummyValidator.setCustomErrorMessages(errors);
        DummyBean bean = new DummyBean("foobar");
        validator.validate((Object)bean, new Class[0]);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="3.4", id="p")})
    public void testDisableDefaultErrorWithCustomErrorNoSubNode() {
        Validator validator = TestUtil.getValidatorUnderTest();
        DummyValidator.disableDefaultError(true);
        HashMap<String, String> errors = new HashMap<String, String>();
        errors.put(null, "message1");
        DummyValidator.setCustomErrorMessages(errors);
        DummyBean bean = new DummyBean("foobar");
        Set constraintViolations = validator.validate((Object)bean, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 1);
        TestUtil.assertCorrectConstraintViolationMessages(constraintViolations, "message1");
        TestUtil.assertCorrectPropertyPaths(constraintViolations, "value");
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="3.4", id="p"), @SpecAssertion(section="3.4", id="s")})
    public void testDisableDefaultErrorWithCustomErrorWithSubNode() {
        Validator validator = TestUtil.getValidatorUnderTest();
        DummyValidator.disableDefaultError(true);
        HashMap<String, String> errors = new HashMap<String, String>();
        errors.put("subnode", "subnode message");
        DummyValidator.setCustomErrorMessages(errors);
        DummyBean bean = new DummyBean("foobar");
        Set constraintViolations = validator.validate((Object)bean, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 1);
        TestUtil.assertCorrectConstraintViolationMessages(constraintViolations, "subnode message");
        TestUtil.assertCorrectPropertyPaths(constraintViolations, "value.subnode");
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="3.4", id="p"), @SpecAssertion(section="3.4", id="s")})
    public void propertyPathInIterable() {
        Validator validator = TestUtil.getValidatorUnderTest();
        Group group = new Group(Gender.MALE, new Person(Gender.FEMALE));
        Set constraintViolations = validator.validate((Object)group, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 1);
        TestUtil.assertCorrectPropertyPaths(constraintViolations, "persons[0]");
        TestUtil.assertCorrectConstraintTypes(constraintViolations, CompatiblePersons.class);
    }

    public static class CompatiblePersonsValidator
    implements ConstraintValidator<CompatiblePersons, Group> {
        public boolean isValid(Group group, ConstraintValidatorContext constraintValidatorContext) {
            if (group == null) {
                return true;
            }
            constraintValidatorContext.disableDefaultConstraintViolation();
            for (int index = 0; index < group.persons.size(); ++index) {
                Person person = group.persons.get(index);
                if (group.gender.equals((Object)person.gender)) continue;
                constraintValidatorContext.buildConstraintViolationWithTemplate("constraints.CompatiblePersons.gender.message").addNode("persons").addNode(null).inIterable().atIndex(Integer.valueOf(index)).addConstraintViolation();
                return false;
            }
            return true;
        }
    }

    @Target(value={ElementType.TYPE, ElementType.ANNOTATION_TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Constraint(validatedBy={CompatiblePersonsValidator.class})
    @Documented
    public static @interface CompatiblePersons {
        public String message() default "";

        public Class<?>[] groups() default {};

        public Class<? extends Payload>[] payload() default {};
    }

    private class Person {
        Gender gender;

        public Person(Gender gender) {
            this.gender = gender;
        }
    }

    @CompatiblePersons
    private class Group {
        Gender gender;
        List<Person> persons = new ArrayList<Person>();

        public Group(Gender gender, Person ... persons) {
            this.gender = gender;
            this.persons.addAll(Arrays.asList(persons));
        }
    }

    private static enum Gender {
        MALE,
        FEMALE;

    }
}

