/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.xmlconfiguration.constraintdeclaration.clazzlevel;

import java.util.Set;
import javax.validation.Configuration;
import javax.validation.Validator;
import org.hibernate.beanvalidation.tck.tests.xmlconfiguration.constraintdeclaration.clazzlevel.Package;
import org.hibernate.beanvalidation.tck.util.TestUtil;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.annotations.Test;

@SpecVersion(spec="beanvalidation", version="2.0.0")
public class ClassLevelOverridingTest
extends Arquillian {
    public static final String packageName = "/org/hibernate/beanvalidation/tck/tests/xmlconfiguration/constraintdeclaration/clazzlevel/";
    public static final String mappingFile1 = "package-constraints-ClassLevelOverridingTest.xml";
    public static final String mappingFile2 = "package-constraints-ClassLevelOverridingImplicitOverrideTest.xml";
    public static final String mappingFile3 = "package-constraints-ClassLevelOverridingWithAnnotationTest.xml";

    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(ClassLevelOverridingTest.class)).withResource(mappingFile1)).withResource(mappingFile2)).withResource(mappingFile3)).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="8.1.1.1", id="a"), @SpecAssertion(section="8.1.1.1", id="c")})
    public void testIgnoreClassLevelAnnotations() {
        Configuration<?> config = TestUtil.getConfigurationUnderTest();
        config.addMapping(TestUtil.getInputStreamForPath("/org/hibernate/beanvalidation/tck/tests/xmlconfiguration/constraintdeclaration/clazzlevel/package-constraints-ClassLevelOverridingTest.xml"));
        Validator validator = config.buildValidatorFactory().getValidator();
        Package p = new Package();
        Set violations = validator.validate((Object)p, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(violations, 1);
        TestUtil.assertCorrectConstraintViolationMessages(violations, "ValidPackage defined in XML");
    }

    @Test
    @SpecAssertion(section="8.1.1.1", id="b")
    public void testIgnoreAnnotationsFromEnclosingBeanIsApplied() {
        Configuration<?> config = TestUtil.getConfigurationUnderTest();
        config.addMapping(TestUtil.getInputStreamForPath("/org/hibernate/beanvalidation/tck/tests/xmlconfiguration/constraintdeclaration/clazzlevel/package-constraints-ClassLevelOverridingImplicitOverrideTest.xml"));
        Validator validator = config.buildValidatorFactory().getValidator();
        Package p = new Package();
        Set violations = validator.validate((Object)p, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(violations, 1);
        TestUtil.assertCorrectConstraintViolationMessages(violations, "ValidPackage defined in XML");
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="8.1.1.1", id="a"), @SpecAssertion(section="8.1.1.1", id="d")})
    public void testClassLevelAnnotationsApplied() {
        Configuration<?> config = TestUtil.getConfigurationUnderTest();
        config.addMapping(TestUtil.getInputStreamForPath("/org/hibernate/beanvalidation/tck/tests/xmlconfiguration/constraintdeclaration/clazzlevel/package-constraints-ClassLevelOverridingWithAnnotationTest.xml"));
        Validator validator = config.buildValidatorFactory().getValidator();
        Package p = new Package();
        Set violations = validator.validate((Object)p, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(violations, 2);
        TestUtil.assertCorrectConstraintViolationMessages(violations, "ValidPackage defined in XML", "ValidPackage defined as annotation");
    }
}

