/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.xmlconfiguration.constraintdeclaration.fieldlevel;

import java.util.Set;
import javax.validation.Validator;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.groups.Default;
import javax.validation.metadata.BeanDescriptor;
import javax.validation.metadata.ConstraintDescriptor;
import javax.validation.metadata.GroupConversionDescriptor;
import javax.validation.metadata.PropertyDescriptor;
import org.hibernate.beanvalidation.tck.tests.xmlconfiguration.constraintdeclaration.fieldlevel.CreditCard;
import org.hibernate.beanvalidation.tck.tests.xmlconfiguration.constraintdeclaration.fieldlevel.User;
import org.hibernate.beanvalidation.tck.util.TestUtil;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="beanvalidation", version="2.0.0")
public class FieldLevelOverridingTest
extends Arquillian {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClass(FieldLevelOverridingTest.class)).withClasses(User.class, CreditCard.class)).withValidationXml("validation-FieldLevelOverridingTest.xml")).withResource("user-constraints-FieldLevelOverridingTest.xml")).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="8.1.1.2", id="a"), @SpecAssertion(section="8.1.1.2", id="c")})
    public void testIgnoreAnnotations() {
        Validator validator = TestUtil.getValidatorUnderTest();
        BeanDescriptor beanDescriptor = validator.getConstraintsForClass(User.class);
        Assert.assertNotNull((Object)beanDescriptor);
        PropertyDescriptor propDescriptor = beanDescriptor.getConstraintsForProperty("firstname");
        Assert.assertNull((Object)propDescriptor, (String)"The annotation defined constraints should be ignored.");
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="6.11", id="a"), @SpecAssertion(section="8.1.1.2", id="a"), @SpecAssertion(section="8.1.1.2", id="d")})
    public void testIncludeAnnotations() {
        Validator validator = TestUtil.getValidatorUnderTest();
        BeanDescriptor beanDescriptor = validator.getConstraintsForClass(User.class);
        Assert.assertNotNull((Object)beanDescriptor);
        PropertyDescriptor propDescriptor = beanDescriptor.getConstraintsForProperty("lastname");
        Assert.assertNotNull((Object)propDescriptor);
        Set constraintDescriptors = propDescriptor.getConstraintDescriptors();
        Assert.assertEquals((int)constraintDescriptors.size(), (int)2, (String)"There should be two constraints");
        boolean foundNotNullConstraint = false;
        boolean foundPatternConstraint = false;
        for (ConstraintDescriptor descriptor : constraintDescriptors) {
            if (descriptor.getAnnotation() instanceof NotNull) {
                foundNotNullConstraint = true;
                continue;
            }
            if (descriptor.getAnnotation() instanceof Pattern) {
                foundPatternConstraint = true;
                continue;
            }
            Assert.fail((String)"Invalid constraint for property.");
        }
        if (!foundNotNullConstraint || !foundPatternConstraint) {
            Assert.fail((String)"Not all configured constraints discovered.");
        }
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="8.1.1.2", id="e")})
    public void testCascadedConfiguration() {
        Validator validator = TestUtil.getValidatorUnderTest();
        BeanDescriptor beanDescriptor = validator.getConstraintsForClass(User.class);
        Assert.assertNotNull((Object)beanDescriptor);
        PropertyDescriptor propDescriptor = beanDescriptor.getConstraintsForProperty("firstCreditCard");
        Assert.assertNotNull((Object)propDescriptor);
        Assert.assertTrue((boolean)propDescriptor.isCascaded(), (String)"Cascaded validation is configured via xml.");
        propDescriptor = beanDescriptor.getConstraintsForProperty("secondCreditCard");
        Assert.assertNull((Object)propDescriptor, (String)"The @Valid annotation should be ignored.");
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="8.1.1.2", id="f")})
    public void testGroupConversionsAreAdditive() {
        Validator validator = TestUtil.getValidatorUnderTest();
        BeanDescriptor beanDescriptor = validator.getConstraintsForClass(User.class);
        Assert.assertNotNull((Object)beanDescriptor);
        PropertyDescriptor propDescriptor = beanDescriptor.getConstraintsForProperty("firstCreditCard");
        Assert.assertNotNull((Object)propDescriptor);
        Assert.assertTrue((boolean)propDescriptor.isCascaded(), (String)"Cascaded validation is configured via xml.");
        Set groupConversionDescriptorSet = propDescriptor.getGroupConversions();
        Assert.assertTrue((groupConversionDescriptorSet.size() == 2 ? 1 : 0) != 0, (String)"There should be two group conversions. One configured via annotations and one via XML");
        boolean foundDefaultToRatingA = false;
        boolean foundDefaultToRatingAA = false;
        for (GroupConversionDescriptor groupConversionDescriptor : groupConversionDescriptorSet) {
            if (groupConversionDescriptor.getFrom().equals(Default.class) && groupConversionDescriptor.getTo().equals(User.CreditRatingA.class)) {
                foundDefaultToRatingA = true;
                continue;
            }
            if (groupConversionDescriptor.getFrom().equals(User.CreditRatingA.class) && groupConversionDescriptor.getTo().equals(User.CreditRatingAA.class)) {
                foundDefaultToRatingAA = true;
                continue;
            }
            Assert.fail((String)"Unexpected group conversion");
        }
        Assert.assertTrue((foundDefaultToRatingA && foundDefaultToRatingAA ? 1 : 0) != 0, (String)"Group conversions defined via XML and Annotation are additive");
    }
}

