/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.integration.ee;

import java.util.Set;
import javax.naming.InitialContext;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import org.hibernate.beanvalidation.tck.tests.AbstractTCKTest;
import org.hibernate.beanvalidation.tck.tests.integration.ee.ConstantMessageInterpolator;
import org.hibernate.beanvalidation.tck.tests.integration.ee.Foo;
import org.hibernate.beanvalidation.tck.util.ConstraintViolationAssert;
import org.hibernate.beanvalidation.tck.util.IntegrationTest;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@IntegrationTest
@SpecVersion(spec="beanvalidation", version="2.0.0")
public class JndiRetrievalTest
extends AbstractTCKTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)JndiRetrievalTest.webArchiveBuilder().withTestClass(JndiRetrievalTest.class)).withClass(ConstantMessageInterpolator.class)).withClass(Foo.class)).withValidationXml("test-validation.xml")).withEmptyBeansXml().build();
    }

    @Test
    @SpecAssertion(section="integration-javaee", id="a")
    private void testDefaultValidatorFactoryCanBeRetrievedFromJndi() throws Exception {
        ValidatorFactory validatorFactory = (ValidatorFactory)InitialContext.doLookup("java:comp/ValidatorFactory");
        Assert.assertNotNull((Object)validatorFactory, (String)"Default validator factory should be bound to JNDI tree.");
        Assert.assertTrue((boolean)(validatorFactory.getMessageInterpolator() instanceof ConstantMessageInterpolator), (String)"Default validator factory bound to JNDI should be configured based on META-INF/validation.xml.");
        Set violations = validatorFactory.getValidator().validate((Object)new Foo(), new Class[0]);
        ConstraintViolationAssert.assertCorrectConstraintViolationMessages(violations, "Invalid constraint");
    }

    @Test
    @SpecAssertion(section="integration-javaee", id="a")
    private void testDefaultValidatorCanBeRetrievedFromJndi() throws Exception {
        Validator validator = (Validator)InitialContext.doLookup("java:comp/Validator");
        Assert.assertNotNull((Object)validator, (String)"Default validator should be bound to JNDI tree.");
        Set violations = validator.validate((Object)new Foo(), new Class[0]);
        ConstraintViolationAssert.assertCorrectConstraintViolationMessages(violations, "Invalid constraint");
    }
}

