/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.validation.graphnavigation.containerelement;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.validation.Valid;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import org.hibernate.beanvalidation.tck.tests.AbstractTCKTest;
import org.hibernate.beanvalidation.tck.tests.validation.graphnavigation.containerelement.model.Cinema;
import org.hibernate.beanvalidation.tck.util.CollectionHelper;
import org.hibernate.beanvalidation.tck.util.ConstraintViolationAssert;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.annotations.Test;

@SpecVersion(spec="beanvalidation", version="2.0.0")
public class CascadingOnContainerElementsTest
extends AbstractTCKTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)CascadingOnContainerElementsTest.webArchiveBuilder().withTestClassPackage(CascadingOnContainerElementsTest.class)).withPackage(Cinema.class.getPackage())).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintdeclarationvalidationprocess-requirements-graphvalidation", id="l"), @SpecAssertion(section="validationapi-constraintviolation", id="ac"), @SpecAssertion(section="constraintdeclarationvalidationprocess-containerelementconstraints", id="a"), @SpecAssertion(section="constraintdeclarationvalidationprocess-containerelementconstraints", id="b"), @SpecAssertion(section="constraintdeclarationvalidationprocess-containerelementconstraints", id="c")})
    public void constraint_provided_on_custom_bean_used_as_list_parameter_and_cascading_gets_validated() {
        TypeWithList l = new TypeWithList();
        l.bars = Arrays.asList(new Bar(2), null);
        Set constraintViolations = this.getValidator().validate((Object)l, new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(Min.class).withPropertyPath(ConstraintViolationAssert.pathWith().property("bars").property("number", true, null, 0, List.class, 0)), ConstraintViolationAssert.violationOf(NotNull.class).withPropertyPath(ConstraintViolationAssert.pathWith().property("bars").containerElement("<list element>", true, null, 1, List.class, 0)));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintdeclarationvalidationprocess-requirements-graphvalidation", id="l"), @SpecAssertion(section="validationapi-constraintviolation", id="ac"), @SpecAssertion(section="constraintdeclarationvalidationprocess-containerelementconstraints", id="a"), @SpecAssertion(section="constraintdeclarationvalidationprocess-containerelementconstraints", id="b"), @SpecAssertion(section="constraintdeclarationvalidationprocess-containerelementconstraints", id="c")})
    public void constraint_provided_on_custom_bean_used_as_map_parameter_value_and_cascading_gets_validated() {
        TypeWithMapValue m = new TypeWithMapValue();
        m.barMap = new HashMap();
        m.barMap.put("bar", new Bar(2));
        m.barMap.put("foo", null);
        Set constraintViolations = this.getValidator().validate((Object)m, new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(Min.class).withPropertyPath(ConstraintViolationAssert.pathWith().property("barMap").property("number", true, "bar", null, Map.class, 1)), ConstraintViolationAssert.violationOf(NotNull.class).withPropertyPath(ConstraintViolationAssert.pathWith().property("barMap").containerElement("<map value>", true, "foo", null, Map.class, 1)));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintdeclarationvalidationprocess-requirements-graphvalidation", id="l"), @SpecAssertion(section="validationapi-constraintviolation", id="ac"), @SpecAssertion(section="constraintdeclarationvalidationprocess-containerelementconstraints", id="a"), @SpecAssertion(section="constraintdeclarationvalidationprocess-containerelementconstraints", id="b"), @SpecAssertion(section="constraintdeclarationvalidationprocess-containerelementconstraints", id="c")})
    public void constraint_provided_on_custom_bean_used_as_map_parameter_key_and_cascading_gets_validated() {
        Bar bar = new Bar(2);
        TypeWithMapKey m = new TypeWithMapKey();
        m.barMap = new HashMap();
        m.barMap.put(bar, "bar");
        m.barMap.put(null, "foo");
        Set constraintViolations = this.getValidator().validate((Object)m, new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(Min.class).withPropertyPath(ConstraintViolationAssert.pathWith().property("barMap").property("number", true, bar, null, Map.class, 0)), ConstraintViolationAssert.violationOf(NotNull.class).withPropertyPath(ConstraintViolationAssert.pathWith().property("barMap").containerElement("<map key>", true, null, null, Map.class, 0)));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintdeclarationvalidationprocess-requirements-graphvalidation", id="l"), @SpecAssertion(section="validationapi-constraintviolation", id="ac"), @SpecAssertion(section="constraintdeclarationvalidationprocess-containerelementconstraints", id="a"), @SpecAssertion(section="constraintdeclarationvalidationprocess-containerelementconstraints", id="b"), @SpecAssertion(section="constraintdeclarationvalidationprocess-containerelementconstraints", id="c")})
    public void constraint_provided_on_custom_bean_used_as_optional_parameter_and_cascading_gets_validated() {
        TypeWithOptional o = new TypeWithOptional();
        o.bar = Optional.empty();
        Set constraintViolations = this.getValidator().validate((Object)o, new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(NotNull.class).withProperty("bar"));
        o = new TypeWithOptional();
        o.bar = Optional.of(new Bar(2));
        constraintViolations = this.getValidator().validate((Object)o, new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(Min.class).withPropertyPath(ConstraintViolationAssert.pathWith().property("bar").property("number", false, null, null, Optional.class, 0)));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintdeclarationvalidationprocess-requirements-graphvalidation", id="l"), @SpecAssertion(section="validationapi-constraintviolation", id="ac"), @SpecAssertion(section="constraintdeclarationvalidationprocess-containerelementconstraints", id="a"), @SpecAssertion(section="constraintdeclarationvalidationprocess-containerelementconstraints", id="b"), @SpecAssertion(section="constraintdeclarationvalidationprocess-containerelementconstraints", id="c")})
    public void constraint_provided_on_custom_bean_used_as_set_parameter_and_cascading_gets_validated() {
        TypeWithSet s = new TypeWithSet();
        s.bars = CollectionHelper.asSet(new Bar(2), null);
        Set constraintViolations = this.getValidator().validate((Object)s, new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(Min.class).withPropertyPath(ConstraintViolationAssert.pathWith().property("bars").property("number", true, null, null, Set.class, 0)), ConstraintViolationAssert.violationOf(NotNull.class).withPropertyPath(ConstraintViolationAssert.pathWith().property("bars").containerElement("<iterable element>", true, null, null, Set.class, 0)));
    }

    @Test
    @SpecAssertion(section="constraintdeclarationvalidationprocess-requirements-graphvalidation", id="l")
    public void cascading_on_container_element_of_method_return_value_is_applied() throws NoSuchMethodException, SecurityException {
        Set constraintViolations = this.getExecutableValidator().validateReturnValue((Object)new BarService(), BarService.class.getMethod("retrieveBars", new Class[0]), Arrays.asList(new Bar(2)), new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(Min.class).withPropertyPath(ConstraintViolationAssert.pathWith().method("retrieveBars").returnValue().property("number", true, null, 0, List.class, 0)));
    }

    @Test
    @SpecAssertion(section="constraintdeclarationvalidationprocess-requirements-graphvalidation", id="l")
    public void cascading_on_container_element_of_method_parameter_is_applied() throws NoSuchMethodException, SecurityException {
        Set constraintViolations = this.getExecutableValidator().validateParameters((Object)new BarService(), BarService.class.getMethod("addBars", List.class), new Object[]{Arrays.asList(new Bar(2))}, new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(Min.class).withPropertyPath(ConstraintViolationAssert.pathWith().method("addBars").parameter("bars", 0).property("number", true, null, 0, List.class, 0)));
    }

    @Test
    @SpecAssertion(section="constraintdeclarationvalidationprocess-requirements-graphvalidation", id="l")
    public void cascading_on_container_element_of_constructor_parameter_is_applied() throws NoSuchMethodException, SecurityException {
        Set constraintViolations = this.getExecutableValidator().validateConstructorParameters(BarService.class.getConstructor(List.class), new Object[]{Arrays.asList(new Bar(2))}, new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(Min.class).withPropertyPath(ConstraintViolationAssert.pathWith().constructor(BarService.class).parameter("bars", 0).property("number", true, null, 0, List.class, 0)));
    }

    private static class BarService {
        public BarService() {
        }

        public BarService(List<@Valid Bar> bars) {
        }

        public List<@Valid Bar> retrieveBars() {
            return null;
        }

        public void addBars(List<@Valid Bar> bars) {
        }
    }

    private static class Bar {
        @Min(value=4L)
        private @Min(value=4L) Integer number;

        public Bar(Integer number) {
            this.number = number;
        }
    }

    private static class TypeWithSet {
        private Set<@NotNull @Valid Bar> bars;

        private TypeWithSet() {
        }
    }

    private static class TypeWithOptional {
        private Optional<@NotNull @Valid Bar> bar;

        private TypeWithOptional() {
        }
    }

    private static class TypeWithMapValue {
        private Map<String, @NotNull @Valid Bar> barMap;

        private TypeWithMapValue() {
        }
    }

    private static class TypeWithMapKey {
        private Map<@NotNull @Valid Bar, String> barMap;

        private TypeWithMapKey() {
        }
    }

    private static class TypeWithList {
        private List<@NotNull @Valid Bar> bars;

        private TypeWithList() {
        }
    }
}

