/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg;

import java.util.Map;
import javax.persistence.InheritanceJoinColumn;
import javax.persistence.JoinColumn;
import org.hibernate.AnnotationException;
import org.hibernate.cfg.AnnotedElementInferredData;
import org.hibernate.cfg.Ejb3Column;
import org.hibernate.cfg.ExtendedMappings;
import org.hibernate.cfg.Mappings;
import org.hibernate.cfg.PropertyHolder;
import org.hibernate.cfg.PropertyHolderBuilder;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Join;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.Value;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Ejb3JoinColumn
extends Ejb3Column {
    private String propertyName;
    private String referencedColumn;
    private String mappedBy;
    private String defaultColumnHeader;

    public void setDefaultColumnHeader(String defaultColumnHeader) {
        this.defaultColumnHeader = defaultColumnHeader;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public String getMappedBy() {
        return this.mappedBy;
    }

    public void setMappedBy(String mappedBy) {
        this.mappedBy = mappedBy;
    }

    public Ejb3JoinColumn(String sqlType, String name, boolean nullable, boolean unique, boolean insertable, boolean updatable, String referencedColumn, String secondaryTable, Map<String, Join> joins, PropertyHolder propertyHolder, String propertyName, String mappedBy, boolean isImplicit, Mappings mappings) {
        super(isImplicit, sqlType, 255, 0, 0, name, nullable, unique, insertable, updatable, secondaryTable, joins, propertyHolder, mappings);
        this.referencedColumn = referencedColumn;
        this.propertyName = propertyName;
        this.mappedBy = mappedBy;
    }

    public Ejb3JoinColumn(PropertyHolder propertyHolder, String propertyName, Mappings mappings) {
        super(propertyHolder, mappings);
        this.propertyName = propertyName;
    }

    public String getReferencedColumn() {
        return this.referencedColumn;
    }

    public static Ejb3JoinColumn buildJoinColumn(JoinColumn ann, String defaultName, Map<String, Join> joins, PropertyHolder propertyHolder, String propertyName, ExtendedMappings mappings) {
        if (ann != null) {
            String sqlType = ann.columnDefinition().equals("") ? null : ann.columnDefinition();
            String name = ann.name().equals("") ? defaultName : ann.name();
            return new Ejb3JoinColumn(sqlType, name, ann.nullable(), ann.unique(), ann.insertable(), ann.updatable(), ann.referencedColumnName(), ann.secondaryTable(), joins, propertyHolder, propertyName, "", false, (Mappings)mappings);
        }
        return Ejb3JoinColumn.buildImplicitJoinColumn("", joins, propertyHolder, propertyName, mappings);
    }

    public static Ejb3JoinColumn buildImplicitJoinColumn(String mappedBy, Map<String, Join> joins, PropertyHolder propertyHolder, String propertyName, ExtendedMappings mappings) {
        return new Ejb3JoinColumn(null, null, true, false, true, true, null, null, joins, propertyHolder, propertyName, mappedBy, true, (Mappings)mappings);
    }

    public static Ejb3JoinColumn buildJoinColumn(JoinColumn ann, Value identifier, Map<String, Join> joins, PropertyHolder propertyHolder, ExtendedMappings mappings) {
        Column col = (Column)identifier.getColumnIterator().next();
        String defaultName = col.getName();
        if (ann != null) {
            String sqlType = ann.columnDefinition().equals("") ? null : ann.columnDefinition();
            String name = ann.name().equals("") ? defaultName : ann.name();
            return new Ejb3JoinColumn(sqlType, name, ann.nullable(), ann.unique(), ann.insertable(), ann.updatable(), ann.referencedColumnName(), ann.secondaryTable(), joins, propertyHolder, null, null, false, (Mappings)mappings);
        }
        return new Ejb3JoinColumn(null, defaultName, true, false, true, true, null, null, joins, propertyHolder, null, null, false, (Mappings)mappings);
    }

    public static Ejb3JoinColumn buildJoinColumn(InheritanceJoinColumn ann, Value identifier, Map<String, Join> joins, PropertyHolder propertyHolder, ExtendedMappings mappings) {
        Column col = (Column)identifier.getColumnIterator().next();
        String defaultName = col.getName();
        if (ann != null) {
            String sqlType = ann.columnDefinition().equals("") ? null : ann.columnDefinition();
            String name = ann.name().equals("") ? defaultName : ann.name();
            return new Ejb3JoinColumn(sqlType, name, false, false, true, true, ann.referencedColumnName(), null, joins, propertyHolder, null, null, false, (Mappings)mappings);
        }
        return new Ejb3JoinColumn(null, defaultName, false, false, true, true, null, null, joins, propertyHolder, null, null, false, (Mappings)mappings);
    }

    public void setPersistentClass(PersistentClass persistentClass) {
        this.propertyHolder = PropertyHolderBuilder.buildPropertyHolder(persistentClass);
    }

    public static void checkIfJoinColumn(Object columns, PropertyHolder holder, AnnotedElementInferredData property) {
        if (!(columns instanceof Ejb3JoinColumn[])) {
            throw new AnnotationException("@Column cannot be used on an association property: " + holder.getEntityName() + "." + property.getPropertyName());
        }
    }

    public void linkValueUsingDefaultColumnNaming(Column column, SimpleValue value) {
        String columnName = (this.defaultColumnHeader == null ? this.propertyName : this.defaultColumnHeader) + "_" + column.getName();
        this.initMappingColumn(columnName, column.getLength(), column.getPrecision(), column.getScale(), this.getMappingColumn().isNullable(), column.getSqlType(), this.getMappingColumn().isUnique());
        this.linkWithValue(value);
    }

    public void linkValueUsingAColumnCopy(Column column, SimpleValue value) {
        this.initMappingColumn(column.getName(), column.getLength(), column.getPrecision(), column.getScale(), this.getMappingColumn().isNullable(), column.getSqlType(), this.getMappingColumn().isUnique());
        this.linkWithValue(value);
    }
}

