/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg.annotations;

import java.util.HashMap;
import javax.persistence.ColumnResult;
import javax.persistence.EntityResult;
import javax.persistence.FieldResult;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.SqlResultSetMapping;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.AnnotationException;
import org.hibernate.LockMode;
import org.hibernate.cfg.AnnotationBinder;
import org.hibernate.cfg.ExtendedMappings;
import org.hibernate.cfg.NotYetImplementedException;
import org.hibernate.engine.NamedQueryDefinition;
import org.hibernate.engine.NamedSQLQueryDefinition;
import org.hibernate.engine.SqlResultsetMappingDefinition;
import org.hibernate.loader.custom.SQLQueryReturn;
import org.hibernate.loader.custom.SQLQueryRootReturn;

public abstract class QueryBinder {
    private static Log log = LogFactory.getLog(QueryBinder.class);

    public static void bindQuery(NamedQuery queryAnn, ExtendedMappings mappings) {
        if (queryAnn == null) {
            return;
        }
        SqlResultsetMappingDefinition mappingDefinition = mappings.getResultSetMapping(queryAnn.resultType());
        if (AnnotationBinder.isDefault(queryAnn.name())) {
            throw new AnnotationException("A named query must have a name when used in class or package level");
        }
        if (mappingDefinition == null && !AnnotationBinder.isDefault(queryAnn.resultType())) {
            throw new AnnotationException("Resultset not found " + queryAnn.resultType() + " for named query " + queryAnn.name());
        }
        if (mappingDefinition == null) {
            NamedQueryDefinition query = new NamedQueryDefinition(queryAnn.queryString(), false, null, null, null, null);
            mappings.addQuery(queryAnn.name(), query);
        } else {
            NamedSQLQueryDefinition query = new NamedSQLQueryDefinition(queryAnn.queryString().trim(), mappingDefinition.getEntityQueryReturns(), mappingDefinition.getScalarQueryReturns(), null, false, null, null, null, null, false);
            mappings.addSQLQuery(queryAnn.name(), query);
        }
        log.debug((Object)("Named query " + queryAnn.name() + " => " + queryAnn.queryString()));
    }

    public static void bindQueries(NamedQueries queriesAnn, ExtendedMappings mappings) {
        if (queriesAnn == null) {
            return;
        }
        for (NamedQuery q : queriesAnn.value()) {
            QueryBinder.bindQuery(q, mappings);
        }
    }

    public static void bindSqlResultsetMapping(SqlResultSetMapping ann, ExtendedMappings mappings) {
        if (ann == null) {
            return;
        }
        SqlResultsetMappingDefinition definition = new SqlResultsetMappingDefinition(ann.name());
        int i$ = 0;
        ColumnResult[] arr$ = ann.columns();
        int len$ = arr$.length;
        if (i$ < len$) {
            ColumnResult column = arr$[i$];
            throw new NotYetImplementedException("Scalar returns are not supported");
        }
        int aliasIndex = 0;
        for (EntityResult entity : ann.entities()) {
            HashMap<String, String[]> propertyresults = new HashMap<String, String[]>();
            for (FieldResult field : entity.fields()) {
                propertyresults.put(field.name(), new String[]{field.column()});
            }
            SQLQueryRootReturn result = new SQLQueryRootReturn("alias" + aliasIndex++, entity.name(), propertyresults, false, LockMode.READ);
            definition.addEntityQueryReturn((SQLQueryReturn)result);
        }
        mappings.addSqlResultSetMapping(definition);
    }
}

