/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg;

import java.util.Map;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.DiscriminatorType;
import org.hibernate.AssertionFailure;
import org.hibernate.annotations.DiscriminatorFormula;
import org.hibernate.cfg.AnnotationBinder;
import org.hibernate.cfg.Ejb3Column;
import org.hibernate.cfg.ExtendedMappings;
import org.hibernate.cfg.Mappings;
import org.hibernate.cfg.PropertyHolder;
import org.hibernate.mapping.Join;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Ejb3DiscriminatorColumn
extends Ejb3Column {
    private static final String DEFAULT_DISCRIMINATOR_COLUMN_NAME = "TYPE";
    private static final String DEFAULT_DISCRIMINATOR_TYPE = "string";
    private String discriminatorTypeName;

    public Ejb3DiscriminatorColumn() {
        this.setColumnName(DEFAULT_DISCRIMINATOR_COLUMN_NAME);
        this.setNullable(false);
        this.setDiscriminatorTypeName(DEFAULT_DISCRIMINATOR_TYPE);
    }

    public Ejb3DiscriminatorColumn(boolean isImplicit, String sqlType, int length, String name, boolean nullable, boolean unique, boolean insertable, boolean updatable, String secondaryTableName, Map<String, Join> joins, PropertyHolder propertyHolder, String discriminatorTypeName, Mappings mappings) {
        this.setImplicit(isImplicit);
        this.setSqlType(sqlType);
        this.setLength(length);
        this.setColumnName(name);
        this.setNullable(nullable);
        this.setUnique(unique);
        this.setInsertable(insertable);
        this.setUpdatable(updatable);
        this.setSecondaryTableName(secondaryTableName);
        this.setJoins(joins);
        this.setPropertyHolder(propertyHolder);
        this.setMappings(mappings);
        this.discriminatorTypeName = discriminatorTypeName;
        this.bind();
    }

    public String getDiscriminatorTypeName() {
        return this.discriminatorTypeName;
    }

    public void setDiscriminatorTypeName(String discriminatorTypeName) {
        this.discriminatorTypeName = discriminatorTypeName;
    }

    public static Ejb3DiscriminatorColumn buildDiscriminatorColumn(DiscriminatorType type, DiscriminatorColumn discAnn, DiscriminatorFormula discFormulaAnn, ExtendedMappings mappings) {
        Ejb3DiscriminatorColumn discriminatorColumn = new Ejb3DiscriminatorColumn();
        discriminatorColumn.setMappings(mappings);
        discriminatorColumn.setImplicit(true);
        if (discFormulaAnn != null) {
            discriminatorColumn.setImplicit(false);
            discriminatorColumn.setFormula(discFormulaAnn.value());
        } else if (discAnn != null) {
            discriminatorColumn.setImplicit(false);
            if (!AnnotationBinder.isDefault(discAnn.columnDefinition())) {
                discriminatorColumn.setSqlType(discAnn.columnDefinition());
            }
            if (!AnnotationBinder.isDefault(discAnn.name())) {
                discriminatorColumn.setColumnName(discAnn.name());
            }
            discriminatorColumn.setNullable(discAnn.nullable());
        }
        if (DiscriminatorType.CHAR.equals((Object)type)) {
            discriminatorColumn.setDiscriminatorTypeName("character");
            discriminatorColumn.setImplicit(false);
        } else if (DiscriminatorType.INTEGER.equals((Object)type)) {
            discriminatorColumn.setDiscriminatorTypeName("integer");
            discriminatorColumn.setImplicit(false);
        } else if (DiscriminatorType.STRING.equals((Object)type) || type == null) {
            if (discAnn != null) {
                discriminatorColumn.setLength(discAnn.length());
            }
            discriminatorColumn.setDiscriminatorTypeName(DEFAULT_DISCRIMINATOR_TYPE);
        } else {
            throw new AssertionFailure("Unknown discriminator type: " + type);
        }
        discriminatorColumn.bind();
        return discriminatorColumn;
    }
}

