/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg.beanvalidation;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import javax.validation.Validation;
import javax.validation.ValidatorFactory;
import javax.validation.constraints.Digits;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import javax.validation.metadata.BeanDescriptor;
import javax.validation.metadata.ConstraintDescriptor;
import javax.validation.metadata.PropertyDescriptor;
import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.cfg.beanvalidation.BeanValidationEventListener;
import org.hibernate.cfg.beanvalidation.GroupsPerOperation;
import org.hibernate.event.EventListeners;
import org.hibernate.event.PreDeleteEventListener;
import org.hibernate.event.PreInsertEventListener;
import org.hibernate.event.PreUpdateEventListener;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.SingleTableSubclass;
import org.hibernate.util.ReflectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TypeSafeActivator {
    private static final Logger logger = LoggerFactory.getLogger(TypeSafeActivator.class);
    private static final String FACTORY_PROPERTY = "javax.persistence.validation.factory";

    TypeSafeActivator() {
    }

    public static void activateBeanValidation(EventListeners eventListeners, Properties properties) {
        ValidatorFactory factory = TypeSafeActivator.getValidatorFactory(properties);
        BeanValidationEventListener beanValidationEventListener = new BeanValidationEventListener(factory, properties);
        PreInsertEventListener[] listeners = eventListeners.getPreInsertEventListeners();
        int length = listeners.length + 1;
        PreInsertEventListener[] newListeners = new PreInsertEventListener[length];
        System.arraycopy(listeners, 0, newListeners, 0, length - 1);
        newListeners[length - 1] = beanValidationEventListener;
        eventListeners.setPreInsertEventListeners(newListeners);
        listeners = eventListeners.getPreUpdateEventListeners();
        length = listeners.length + 1;
        newListeners = new PreUpdateEventListener[length];
        System.arraycopy(listeners, 0, newListeners, 0, length - 1);
        newListeners[length - 1] = beanValidationEventListener;
        eventListeners.setPreUpdateEventListeners((PreUpdateEventListener[])newListeners);
        listeners = eventListeners.getPreDeleteEventListeners();
        length = listeners.length + 1;
        newListeners = new PreDeleteEventListener[length];
        System.arraycopy(listeners, 0, newListeners, 0, length - 1);
        newListeners[length - 1] = beanValidationEventListener;
        eventListeners.setPreDeleteEventListeners((PreDeleteEventListener[])newListeners);
    }

    public static void applyDDL(Collection<PersistentClass> persistentClasses, Properties properties) {
        ValidatorFactory factory = TypeSafeActivator.getValidatorFactory(properties);
        Class<?>[] groupsArray = new GroupsPerOperation(properties).get(GroupsPerOperation.Operation.DDL);
        HashSet groups = new HashSet(Arrays.asList(groupsArray));
        for (PersistentClass persistentClass : persistentClasses) {
            Class clazz;
            String className = persistentClass.getClassName();
            if (className == null || className.length() == 0) continue;
            try {
                clazz = ReflectHelper.classForName((String)className, TypeSafeActivator.class);
            }
            catch (ClassNotFoundException e) {
                throw new AssertionFailure("Entity class not found", (Throwable)e);
            }
            try {
                TypeSafeActivator.applyDDL("", persistentClass, clazz, factory, groups, true);
            }
            catch (Exception e) {
                logger.warn("Unable to apply constraints on DDL for " + className, (Throwable)e);
            }
        }
    }

    private static void applyDDL(String prefix, PersistentClass persistentClass, Class<?> clazz, ValidatorFactory factory, Set<Class<?>> groups, boolean activateNotNull) {
        BeanDescriptor descriptor = factory.getValidator().getConstraintsForClass(clazz);
        for (PropertyDescriptor propertyDesc : descriptor.getConstrainedProperties()) {
            Property property = TypeSafeActivator.findPropertyByName(persistentClass, prefix + propertyDesc.getPropertyName());
            boolean hasNotNull = false;
            if (property == null) continue;
            hasNotNull = TypeSafeActivator.applyConstraints(propertyDesc.getConstraintDescriptors(), property, propertyDesc, groups, activateNotNull);
            if (!property.isComposite() || !propertyDesc.isCascaded()) continue;
            Class componentClass = ((Component)property.getValue()).getComponentClass();
            boolean canSetNotNullOnColumns = activateNotNull && hasNotNull;
            TypeSafeActivator.applyDDL(prefix + propertyDesc.getPropertyName() + ".", persistentClass, componentClass, factory, groups, canSetNotNullOnColumns);
        }
    }

    private static boolean applyConstraints(Set<ConstraintDescriptor<?>> constraintDescriptors, Property property, PropertyDescriptor propertyDesc, Set<Class<?>> groups, boolean canApplyNotNull) {
        boolean hasNotNull = false;
        for (ConstraintDescriptor<?> descriptor : constraintDescriptors) {
            if (groups != null && Collections.disjoint(descriptor.getGroups(), groups)) continue;
            if (canApplyNotNull) {
                hasNotNull = hasNotNull || TypeSafeActivator.applyNotNull(property, descriptor);
            }
            TypeSafeActivator.applyDigits(property, descriptor);
            TypeSafeActivator.applySize(property, descriptor, propertyDesc);
            TypeSafeActivator.applyMin(property, descriptor);
            TypeSafeActivator.applyMax(property, descriptor);
            hasNotNull = hasNotNull || TypeSafeActivator.applyConstraints(descriptor.getComposingConstraints(), property, propertyDesc, null, canApplyNotNull);
        }
        return hasNotNull;
    }

    private static void applyMin(Property property, ConstraintDescriptor<?> descriptor) {
        if (Min.class.equals(descriptor.getAnnotation().annotationType())) {
            ConstraintDescriptor<?> minConstraint = descriptor;
            long min = ((Min)minConstraint.getAnnotation()).value();
            Column col = (Column)property.getColumnIterator().next();
            col.setCheckConstraint(col.getName() + ">=" + min);
        }
    }

    private static void applyMax(Property property, ConstraintDescriptor<?> descriptor) {
        if (Max.class.equals(descriptor.getAnnotation().annotationType())) {
            ConstraintDescriptor<?> maxConstraint = descriptor;
            long max = ((Max)maxConstraint.getAnnotation()).value();
            Column col = (Column)property.getColumnIterator().next();
            col.setCheckConstraint(col.getName() + "<=" + max);
        }
    }

    private static boolean applyNotNull(Property property, ConstraintDescriptor<?> descriptor) {
        boolean hasNotNull = false;
        if (NotNull.class.equals(descriptor.getAnnotation().annotationType())) {
            if (!(property.getPersistentClass() instanceof SingleTableSubclass) && !property.isComposite()) {
                Iterator iter = property.getColumnIterator();
                while (iter.hasNext()) {
                    ((Column)iter.next()).setNullable(false);
                    hasNotNull = true;
                }
            }
            hasNotNull = true;
        }
        return hasNotNull;
    }

    private static void applyDigits(Property property, ConstraintDescriptor<?> descriptor) {
        if (Digits.class.equals(descriptor.getAnnotation().annotationType())) {
            ConstraintDescriptor<?> digitsConstraint = descriptor;
            int integerDigits = ((Digits)digitsConstraint.getAnnotation()).integer();
            int fractionalDigits = ((Digits)digitsConstraint.getAnnotation()).fraction();
            Column col = (Column)property.getColumnIterator().next();
            col.setPrecision(integerDigits + fractionalDigits);
            col.setScale(fractionalDigits);
        }
    }

    private static void applySize(Property property, ConstraintDescriptor<?> descriptor, PropertyDescriptor propertyDesc) {
        if (Size.class.equals(descriptor.getAnnotation().annotationType()) && String.class.equals((Object)propertyDesc.getElementClass())) {
            ConstraintDescriptor<?> sizeConstraint = descriptor;
            int max = ((Size)sizeConstraint.getAnnotation()).max();
            Column col = (Column)property.getColumnIterator().next();
            if (max < Integer.MAX_VALUE) {
                col.setLength(max);
            }
        }
    }

    private static Property findPropertyByName(PersistentClass associatedClass, String propertyName) {
        Property property = null;
        Property idProperty = associatedClass.getIdentifierProperty();
        String idName = idProperty != null ? idProperty.getName() : null;
        try {
            if (propertyName == null || propertyName.length() == 0 || propertyName.equals(idName)) {
                property = idProperty;
            } else {
                if (propertyName.indexOf(idName + ".") == 0) {
                    property = idProperty;
                    propertyName = propertyName.substring(idName.length() + 1);
                }
                StringTokenizer st = new StringTokenizer(propertyName, ".", false);
                while (st.hasMoreElements()) {
                    String element = (String)st.nextElement();
                    if (property == null) {
                        property = associatedClass.getProperty(element);
                        continue;
                    }
                    if (!property.isComposite()) {
                        return null;
                    }
                    property = ((Component)property.getValue()).getProperty(element);
                }
            }
        }
        catch (MappingException e) {
            try {
                if (associatedClass.getIdentifierMapper() == null) {
                    return null;
                }
                StringTokenizer st = new StringTokenizer(propertyName, ".", false);
                while (st.hasMoreElements()) {
                    String element = (String)st.nextElement();
                    if (property == null) {
                        property = associatedClass.getIdentifierMapper().getProperty(element);
                        continue;
                    }
                    if (!property.isComposite()) {
                        return null;
                    }
                    property = ((Component)property.getValue()).getProperty(element);
                }
            }
            catch (MappingException ee) {
                return null;
            }
        }
        return property;
    }

    private static ValidatorFactory getValidatorFactory(Map<Object, Object> properties) {
        Object unsafeProperty;
        ValidatorFactory factory = null;
        if (properties != null && (unsafeProperty = properties.get(FACTORY_PROPERTY)) != null) {
            try {
                factory = (ValidatorFactory)ValidatorFactory.class.cast(unsafeProperty);
            }
            catch (ClassCastException e) {
                throw new HibernateException("Property javax.persistence.validation.factory should contain an object of type " + ValidatorFactory.class.getName());
            }
        }
        if (factory == null) {
            try {
                factory = Validation.buildDefaultValidatorFactory();
            }
            catch (Exception e) {
                throw new HibernateException("Unable to build the default ValidatorFactory", (Throwable)e);
            }
        }
        return factory;
    }
}

