/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg.beanvalidation;

import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.validation.ConstraintViolationException;
import javax.validation.TraversableResolver;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import org.hibernate.EntityMode;
import org.hibernate.cfg.beanvalidation.GroupsPerOperation;
import org.hibernate.cfg.beanvalidation.HibernateTraversableResolver;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.event.PreDeleteEvent;
import org.hibernate.event.PreDeleteEventListener;
import org.hibernate.event.PreInsertEvent;
import org.hibernate.event.PreInsertEventListener;
import org.hibernate.event.PreUpdateEvent;
import org.hibernate.event.PreUpdateEventListener;
import org.hibernate.persister.entity.EntityPersister;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanValidationEventListener
implements PreInsertEventListener,
PreUpdateEventListener,
PreDeleteEventListener {
    private ValidatorFactory factory;
    private ConcurrentHashMap<EntityPersister, Set<String>> associationsPerEntityPersister = new ConcurrentHashMap();
    private GroupsPerOperation groupsPerOperation;

    public BeanValidationEventListener(ValidatorFactory factory, Properties properties) {
        this.factory = factory;
        this.groupsPerOperation = new GroupsPerOperation(properties);
    }

    public boolean onPreInsert(PreInsertEvent event) {
        this.validate(event.getEntity(), event.getSession().getEntityMode(), event.getPersister(), event.getSession().getFactory(), GroupsPerOperation.Operation.INSERT);
        return false;
    }

    public boolean onPreUpdate(PreUpdateEvent event) {
        this.validate(event.getEntity(), event.getSession().getEntityMode(), event.getPersister(), event.getSession().getFactory(), GroupsPerOperation.Operation.UPDATE);
        return false;
    }

    public boolean onPreDelete(PreDeleteEvent event) {
        this.validate(event.getEntity(), event.getSession().getEntityMode(), event.getPersister(), event.getSession().getFactory(), GroupsPerOperation.Operation.DELETE);
        return false;
    }

    private <T> void validate(T object, EntityMode mode, EntityPersister persister, SessionFactoryImplementor sessionFactory, GroupsPerOperation.Operation operation) {
        if (object == null || mode != EntityMode.POJO) {
            return;
        }
        HibernateTraversableResolver tr = new HibernateTraversableResolver(persister, this.associationsPerEntityPersister, sessionFactory);
        Validator validator = this.factory.usingContext().traversableResolver((TraversableResolver)tr).getValidator();
        Class[] groups = this.groupsPerOperation.get(operation);
        if (groups.length > 0) {
            Set constraintViolations;
            Set unsafeViolations = constraintViolations = validator.validate(object, groups);
            if (constraintViolations.size() > 0) {
                throw new ConstraintViolationException("Invalid object at " + operation.getName() + " time for groups " + this.toString(groups), unsafeViolations);
            }
        }
    }

    private String toString(Class<?>[] groups) {
        StringBuilder toString = new StringBuilder("[");
        for (Class<?> group : groups) {
            toString.append(group.getName()).append(", ");
        }
        toString.append("]");
        return toString.toString();
    }
}

