/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.service.jdbc.connections.internal;

import com.mchange.v2.c3p0.DataSources;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.hibernate.HibernateException;
import org.hibernate.cfg.Environment;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.hibernate.service.jdbc.connections.internal.C3P0Logger;
import org.hibernate.service.jdbc.connections.internal.ConnectionProviderInitiator;
import org.hibernate.service.jdbc.connections.spi.ConnectionProvider;
import org.hibernate.service.spi.UnknownUnwrapTypeException;
import org.jboss.logging.Logger;

public class C3P0ConnectionProvider
implements ConnectionProvider {
    private static final C3P0Logger LOG = (C3P0Logger)Logger.getMessageLogger(C3P0Logger.class, (String)C3P0ConnectionProvider.class.getName());
    private static final String C3P0_STYLE_MIN_POOL_SIZE = "c3p0.minPoolSize";
    private static final String C3P0_STYLE_MAX_POOL_SIZE = "c3p0.maxPoolSize";
    private static final String C3P0_STYLE_MAX_IDLE_TIME = "c3p0.maxIdleTime";
    private static final String C3P0_STYLE_MAX_STATEMENTS = "c3p0.maxStatements";
    private static final String C3P0_STYLE_ACQUIRE_INCREMENT = "c3p0.acquireIncrement";
    private static final String C3P0_STYLE_IDLE_CONNECTION_TEST_PERIOD = "c3p0.idleConnectionTestPeriod";
    private static final String C3P0_STYLE_INITIAL_POOL_SIZE = "c3p0.initialPoolSize";
    private DataSource ds;
    private Integer isolation;
    private boolean autocommit;

    public Connection getConnection() throws SQLException {
        Connection c = this.ds.getConnection();
        if (this.isolation != null) {
            c.setTransactionIsolation(this.isolation);
        }
        if (c.getAutoCommit() != this.autocommit) {
            c.setAutoCommit(this.autocommit);
        }
        return c;
    }

    public void closeConnection(Connection conn) throws SQLException {
        conn.close();
    }

    public boolean isUnwrappableAs(Class unwrapType) {
        return ConnectionProvider.class.equals((Object)unwrapType) || C3P0ConnectionProvider.class.isAssignableFrom(unwrapType) || DataSource.class.isAssignableFrom(unwrapType);
    }

    public <T> T unwrap(Class<T> unwrapType) {
        if (ConnectionProvider.class.equals(unwrapType) || C3P0ConnectionProvider.class.isAssignableFrom(unwrapType)) {
            return (T)this;
        }
        if (DataSource.class.isAssignableFrom(unwrapType)) {
            return (T)this.ds;
        }
        throw new UnknownUnwrapTypeException(unwrapType);
    }

    public void configure(Properties props) throws HibernateException {
        String jdbcDriverClass = props.getProperty("hibernate.connection.driver_class");
        String jdbcUrl = props.getProperty("hibernate.connection.url");
        Properties connectionProps = ConnectionProviderInitiator.getConnectionProperties((Map)props);
        LOG.c3p0UsingDriver(jdbcDriverClass, jdbcUrl);
        LOG.connectionProperties(ConfigurationHelper.maskOut((Properties)connectionProps, (String)"password"));
        this.autocommit = ConfigurationHelper.getBoolean((String)"hibernate.connection.autocommit", (Map)props);
        LOG.autoCommitMode(this.autocommit);
        if (jdbcDriverClass == null) {
            LOG.jdbcDriverNotSpecified("hibernate.connection.driver_class");
        } else {
            try {
                Class.forName(jdbcDriverClass);
            }
            catch (ClassNotFoundException cnfe) {
                try {
                    ReflectHelper.classForName((String)jdbcDriverClass);
                }
                catch (ClassNotFoundException e) {
                    String msg = LOG.jdbcDriverNotFound(jdbcDriverClass);
                    LOG.error(msg, e);
                    throw new HibernateException(msg, (Throwable)e);
                }
            }
        }
        try {
            Integer minPoolSize = ConfigurationHelper.getInteger((String)"hibernate.c3p0.min_size", (Map)props);
            Integer maxPoolSize = ConfigurationHelper.getInteger((String)"hibernate.c3p0.max_size", (Map)props);
            Integer maxIdleTime = ConfigurationHelper.getInteger((String)"hibernate.c3p0.timeout", (Map)props);
            Integer maxStatements = ConfigurationHelper.getInteger((String)"hibernate.c3p0.max_statements", (Map)props);
            Integer acquireIncrement = ConfigurationHelper.getInteger((String)"hibernate.c3p0.acquire_increment", (Map)props);
            Integer idleTestPeriod = ConfigurationHelper.getInteger((String)"hibernate.c3p0.idle_test_period", (Map)props);
            Properties c3props = new Properties();
            for (String string : props.keySet()) {
                if (!string.startsWith("hibernate.c3p0.")) continue;
                String newKey = string.substring(10);
                if (props.containsKey(newKey)) {
                    this.warnPropertyConflict(string, newKey);
                }
                c3props.put(newKey, props.get(string));
            }
            this.setOverwriteProperty("hibernate.c3p0.min_size", C3P0_STYLE_MIN_POOL_SIZE, props, c3props, minPoolSize);
            this.setOverwriteProperty("hibernate.c3p0.max_size", C3P0_STYLE_MAX_POOL_SIZE, props, c3props, maxPoolSize);
            this.setOverwriteProperty("hibernate.c3p0.timeout", C3P0_STYLE_MAX_IDLE_TIME, props, c3props, maxIdleTime);
            this.setOverwriteProperty("hibernate.c3p0.max_statements", C3P0_STYLE_MAX_STATEMENTS, props, c3props, maxStatements);
            this.setOverwriteProperty("hibernate.c3p0.acquire_increment", C3P0_STYLE_ACQUIRE_INCREMENT, props, c3props, acquireIncrement);
            this.setOverwriteProperty("hibernate.c3p0.idle_test_period", C3P0_STYLE_IDLE_CONNECTION_TEST_PERIOD, props, c3props, idleTestPeriod);
            Integer initialPoolSize = ConfigurationHelper.getInteger((String)C3P0_STYLE_INITIAL_POOL_SIZE, (Map)props);
            if (initialPoolSize == null && minPoolSize != null) {
                c3props.put(C3P0_STYLE_INITIAL_POOL_SIZE, String.valueOf(minPoolSize).trim());
            }
            DataSource dataSource = DataSources.unpooledDataSource((String)jdbcUrl, (Properties)connectionProps);
            Properties allProps = (Properties)props.clone();
            allProps.putAll((Map<?, ?>)c3props);
            this.ds = DataSources.pooledDataSource((DataSource)dataSource, (Properties)allProps);
        }
        catch (Exception e) {
            LOG.error(LOG.unableToInstantiateC3p0ConnectionPool(), e);
            throw new HibernateException(LOG.unableToInstantiateC3p0ConnectionPool(), (Throwable)e);
        }
        String i = props.getProperty("hibernate.connection.isolation");
        if (i == null) {
            this.isolation = null;
        } else {
            this.isolation = new Integer(i);
            LOG.jdbcIsolationLevel(Environment.isolationLevelToString((int)this.isolation));
        }
    }

    public void close() {
        try {
            DataSources.destroy((DataSource)this.ds);
        }
        catch (SQLException sqle) {
            LOG.unableToDestroyC3p0ConnectionPool(sqle);
        }
    }

    public boolean supportsAggressiveRelease() {
        return false;
    }

    private void setOverwriteProperty(String hibernateStyleKey, String c3p0StyleKey, Properties hibp, Properties c3p, Integer value) {
        if (value != null) {
            String longC3p0StyleKey;
            c3p.put(c3p0StyleKey, String.valueOf(value).trim());
            if (hibp.getProperty(c3p0StyleKey) != null) {
                this.warnPropertyConflict(hibernateStyleKey, c3p0StyleKey);
            }
            if (hibp.getProperty(longC3p0StyleKey = "hibernate." + c3p0StyleKey) != null) {
                this.warnPropertyConflict(hibernateStyleKey, longC3p0StyleKey);
            }
        }
    }

    private void warnPropertyConflict(String hibernateStyle, String c3p0Style) {
        LOG.bothHibernateAndC3p0StylesSet(hibernateStyle, c3p0Style, hibernateStyle, c3p0Style);
    }
}

