/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache;

import java.net.URL;
import java.util.Properties;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import org.hibernate.cache.Cache;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.CacheProvider;
import org.hibernate.cache.EhCache;
import org.hibernate.cache.EhCacheLogger;
import org.hibernate.cache.Timestamper;
import org.hibernate.internal.util.ConfigHelper;
import org.hibernate.internal.util.StringHelper;
import org.jboss.logging.Logger;

public class EhCacheProvider
implements CacheProvider {
    private static final EhCacheLogger LOG = (EhCacheLogger)Logger.getMessageLogger(EhCacheLogger.class, (String)EhCacheProvider.class.getName());
    private CacheManager manager;

    public Cache buildCache(String name, Properties properties) throws CacheException {
        try {
            net.sf.ehcache.Cache cache = this.manager.getCache(name);
            if (cache == null) {
                LOG.unableToFindConfiguration(name);
                this.manager.addCache(name);
                cache = this.manager.getCache(name);
                LOG.debugf("Started EHCache region: %s", name);
            }
            return new EhCache((Ehcache)cache);
        }
        catch (net.sf.ehcache.CacheException e) {
            throw new CacheException((Throwable)e);
        }
    }

    public long nextTimestamp() {
        return Timestamper.next();
    }

    public void start(Properties properties) throws CacheException {
        if (this.manager != null) {
            LOG.attemptToRestartAlreadyStartedEhCacheProvider();
            return;
        }
        try {
            String configurationResourceName = null;
            if (properties != null) {
                configurationResourceName = (String)properties.get("hibernate.cache.provider_configuration_file_resource_path");
            }
            if (StringHelper.isEmpty(configurationResourceName)) {
                this.manager = new CacheManager();
            } else {
                URL url = this.loadResource(configurationResourceName);
                this.manager = new CacheManager(url);
            }
        }
        catch (net.sf.ehcache.CacheException e) {
            if (e.getMessage().startsWith("Cannot parseConfiguration CacheManager. Attempt to create a new instance of CacheManager using the diskStorePath")) {
                throw new CacheException("Attempt to restart an already started EhCacheProvider. Use sessionFactory.close()  between repeated calls to buildSessionFactory. Consider using net.sf.ehcache.hibernate.SingletonEhCacheProvider.", (Throwable)e);
            }
            throw e;
        }
    }

    private URL loadResource(String configurationResourceName) {
        URL url = ConfigHelper.locateConfig((String)configurationResourceName);
        LOG.debugf("Creating EhCacheProvider from a specified resource: %s Resolved to URL: %s", configurationResourceName, url);
        return url;
    }

    public void stop() {
        if (this.manager != null) {
            this.manager.shutdown();
            this.manager = null;
        }
    }

    public boolean isMinimalPutsEnabledByDefault() {
        return false;
    }
}

