/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.internal;

import java.net.URL;
import java.util.Properties;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.util.ClassLoaderUtil;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.internal.EhCache;
import org.hibernate.cache.internal.EhCacheMessageLogger;
import org.hibernate.cache.internal.Timestamper;
import org.hibernate.cache.spi.Cache;
import org.hibernate.cache.spi.CacheProvider;
import org.jboss.logging.Logger;

@Deprecated
public final class SingletonEhCacheProvider
implements CacheProvider {
    public static final String NET_SF_EHCACHE_CONFIGURATION_RESOURCE_NAME = "net.sf.ehcache.configurationResourceName";
    private static final EhCacheMessageLogger LOG = (EhCacheMessageLogger)Logger.getMessageLogger(EhCacheMessageLogger.class, (String)SingletonEhCacheProvider.class.getName());
    private static int referenceCount;
    private CacheManager manager;

    public final Cache buildCache(String name, Properties properties) throws CacheException {
        try {
            Ehcache cache = this.manager.getEhcache(name);
            if (cache == null) {
                LOG.unableToFindEhCacheConfiguration(name);
                this.manager.addCache(name);
                cache = this.manager.getEhcache(name);
                LOG.debugf("Started EHCache region: %s", name);
            }
            return new EhCache(cache);
        }
        catch (net.sf.ehcache.CacheException e) {
            throw new CacheException((Throwable)e);
        }
    }

    public final long nextTimestamp() {
        return Timestamper.next();
    }

    public final void start(Properties properties) throws CacheException {
        String configurationResourceName = null;
        if (properties != null) {
            configurationResourceName = (String)properties.get(NET_SF_EHCACHE_CONFIGURATION_RESOURCE_NAME);
        }
        if (configurationResourceName == null || configurationResourceName.length() == 0) {
            this.manager = CacheManager.create();
            ++referenceCount;
        } else {
            if (!configurationResourceName.startsWith("/")) {
                configurationResourceName = "/" + configurationResourceName;
                if (LOG.isDebugEnabled()) {
                    LOG.debugf("Prepending / to %s. It should be placed in the root of the classpath rather than in a package.", configurationResourceName);
                }
            }
            URL url = this.loadResource(configurationResourceName);
            this.manager = CacheManager.create((URL)url);
            ++referenceCount;
        }
    }

    private URL loadResource(String configurationResourceName) {
        ClassLoader standardClassloader = ClassLoaderUtil.getStandardClassLoader();
        URL url = null;
        if (standardClassloader != null) {
            url = standardClassloader.getResource(configurationResourceName);
        }
        if (url == null) {
            url = this.getClass().getResource(configurationResourceName);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debugf("Creating EhCacheProvider from a specified resource: %s Resolved to URL: %s", configurationResourceName, url);
        }
        if (url == null && LOG.isEnabled(Logger.Level.WARN)) {
            LOG.unableToLoadConfiguration(configurationResourceName);
        }
        return url;
    }

    public void stop() {
        if (this.manager != null) {
            if (--referenceCount == 0) {
                this.manager.shutdown();
            }
            this.manager = null;
        }
    }

    public final boolean isMinimalPutsEnabledByDefault() {
        return false;
    }
}

