/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ejb;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.persistence.Cache;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContextType;
import javax.persistence.PersistenceUnitUtil;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.metamodel.Metamodel;
import javax.persistence.spi.LoadState;
import javax.persistence.spi.PersistenceUnitTransactionType;
import org.hibernate.EntityMode;
import org.hibernate.Hibernate;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import org.hibernate.ejb.EntityManagerImpl;
import org.hibernate.ejb.HibernateEntityManagerFactory;
import org.hibernate.ejb.criteria.CriteriaBuilderImpl;
import org.hibernate.ejb.metamodel.MetamodelImpl;
import org.hibernate.ejb.util.PersistenceUtilHelper;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.metadata.ClassMetadata;
import org.hibernate.service.ServiceRegistry;

public class EntityManagerFactoryImpl
implements HibernateEntityManagerFactory {
    private final SessionFactory sessionFactory;
    private final PersistenceUnitTransactionType transactionType;
    private final boolean discardOnClose;
    private final Class sessionInterceptorClass;
    private final CriteriaBuilderImpl criteriaBuilder;
    private final Metamodel metamodel;
    private final HibernatePersistenceUnitUtil util;
    private final Map<String, Object> properties;
    private final PersistenceUtilHelper.MetadataCache cache = new PersistenceUtilHelper.MetadataCache();

    public EntityManagerFactoryImpl(PersistenceUnitTransactionType transactionType, boolean discardOnClose, Class sessionInterceptorClass, Configuration cfg, ServiceRegistry serviceRegistry) {
        this.sessionFactory = cfg.buildSessionFactory(serviceRegistry);
        this.transactionType = transactionType;
        this.discardOnClose = discardOnClose;
        this.sessionInterceptorClass = sessionInterceptorClass;
        Iterator classes = cfg.getClassMappings();
        this.metamodel = !"disabled".equalsIgnoreCase(cfg.getProperty("hibernate.ejb.metamodel.generation")) ? MetamodelImpl.buildMetamodel(classes, (SessionFactoryImplementor)this.sessionFactory) : null;
        this.criteriaBuilder = new CriteriaBuilderImpl(this);
        this.util = new HibernatePersistenceUnitUtil(this);
        HashMap<String, Object> props = new HashMap<String, Object>();
        EntityManagerFactoryImpl.addAll(props, ((SessionFactoryImplementor)this.sessionFactory).getProperties());
        EntityManagerFactoryImpl.addAll(props, cfg.getProperties());
        this.properties = Collections.unmodifiableMap(props);
    }

    private static void addAll(HashMap<String, Object> propertyMap, Properties properties) {
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            if (!String.class.isInstance(entry.getKey())) continue;
            propertyMap.put((String)entry.getKey(), entry.getValue());
        }
    }

    public EntityManager createEntityManager() {
        return this.createEntityManager(null);
    }

    public EntityManager createEntityManager(Map map) {
        return new EntityManagerImpl(this, PersistenceContextType.EXTENDED, this.transactionType, this.discardOnClose, this.sessionInterceptorClass, map);
    }

    public CriteriaBuilder getCriteriaBuilder() {
        return this.criteriaBuilder;
    }

    public Metamodel getMetamodel() {
        return this.metamodel;
    }

    public void close() {
        this.sessionFactory.close();
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public Cache getCache() {
        if (!this.isOpen()) {
            throw new IllegalStateException("EntityManagerFactory is closed");
        }
        return new JPACache(this.sessionFactory);
    }

    public PersistenceUnitUtil getPersistenceUnitUtil() {
        if (!this.isOpen()) {
            throw new IllegalStateException("EntityManagerFactory is closed");
        }
        return this.util;
    }

    public boolean isOpen() {
        return !this.sessionFactory.isClosed();
    }

    @Override
    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    private static class HibernatePersistenceUnitUtil
    implements PersistenceUnitUtil,
    Serializable {
        private final HibernateEntityManagerFactory emf;
        private transient PersistenceUtilHelper.MetadataCache cache;

        private HibernatePersistenceUnitUtil(EntityManagerFactoryImpl emf) {
            this.emf = emf;
            this.cache = emf.cache;
        }

        public boolean isLoaded(Object entity, String attributeName) {
            LoadState state = PersistenceUtilHelper.isLoadedWithoutReference(entity, attributeName, this.cache);
            if (state == LoadState.LOADED) {
                return true;
            }
            if (state == LoadState.NOT_LOADED) {
                return false;
            }
            return PersistenceUtilHelper.isLoadedWithReference(entity, attributeName, this.cache) != LoadState.NOT_LOADED;
        }

        public boolean isLoaded(Object entity) {
            return PersistenceUtilHelper.isLoaded(entity) != LoadState.NOT_LOADED;
        }

        public Object getIdentifier(Object entity) {
            Class entityClass = Hibernate.getClass((Object)entity);
            ClassMetadata classMetadata = this.emf.getSessionFactory().getClassMetadata(entityClass);
            if (classMetadata == null) {
                throw new IllegalArgumentException(entityClass + " is not an entity");
            }
            return classMetadata.getIdentifier(entity, EntityMode.POJO);
        }
    }

    private static class JPACache
    implements Cache {
        private SessionFactory sessionFactory;

        private JPACache(SessionFactory sessionFactory) {
            this.sessionFactory = sessionFactory;
        }

        public boolean contains(Class entityClass, Object identifier) {
            return this.sessionFactory.getCache().containsEntity(entityClass, (Serializable)identifier);
        }

        public void evict(Class entityClass, Object identifier) {
            this.sessionFactory.getCache().evictEntity(entityClass, (Serializable)identifier);
        }

        public void evict(Class entityClass) {
            this.sessionFactory.getCache().evictEntityRegion(entityClass);
        }

        public void evictAll() {
            this.sessionFactory.getCache().evictEntityRegions();
        }
    }
}

