/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ejb.packaging;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import org.hibernate.ejb.internal.EntityManagerMessageLogger;
import org.hibernate.ejb.packaging.ExplodedJarVisitor;
import org.hibernate.ejb.packaging.FileZippedJarVisitor;
import org.hibernate.ejb.packaging.Filter;
import org.hibernate.ejb.packaging.InputStreamZippedJarVisitor;
import org.hibernate.ejb.packaging.JarProtocolVisitor;
import org.hibernate.ejb.packaging.JarVisitor;
import org.hibernate.internal.util.StringHelper;
import org.jboss.logging.Logger;

public class JarVisitorFactory {
    private static final EntityManagerMessageLogger LOG = (EntityManagerMessageLogger)Logger.getMessageLogger(EntityManagerMessageLogger.class, (String)JarVisitorFactory.class.getName());

    public static URL getJarURLFromURLEntry(URL url, String entry) throws IllegalArgumentException {
        URL jarUrl;
        String file = url.getFile();
        if (!entry.startsWith("/")) {
            entry = "/" + entry;
        }
        if ((file = file.substring(0, file.length() - entry.length())).endsWith("!")) {
            file = file.substring(0, file.length() - 1);
        }
        try {
            String protocol = url.getProtocol();
            if ("jar".equals(protocol) || "wsjar".equals(protocol)) {
                jarUrl = new URL(file);
                if ("file".equals(jarUrl.getProtocol()) && file.indexOf(32) != -1) {
                    jarUrl = new File(jarUrl.getFile()).toURI().toURL();
                }
            } else if ("zip".equals(protocol) || "code-source".equals(url.getProtocol()) || "file".equals(protocol)) {
                jarUrl = file.indexOf(32) != -1 ? new File(file).toURI().toURL() : new File(file).toURL();
            } else {
                try {
                    jarUrl = new URL(protocol, url.getHost(), url.getPort(), file);
                }
                catch (MalformedURLException murle) {
                    jarUrl = url;
                }
            }
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Unable to determine JAR Url from " + url + ". Cause: " + e.getMessage());
        }
        LOG.trace("JAR URL from URL Entry: " + url + " >> " + jarUrl);
        return jarUrl;
    }

    public static URL getURLFromPath(String jarPath) {
        URL jarUrl;
        try {
            jarUrl = new URL(jarPath);
        }
        catch (MalformedURLException e) {
            try {
                jarUrl = new URL("file:" + jarPath);
            }
            catch (MalformedURLException ee) {
                throw new IllegalArgumentException("Unable to find jar:" + jarPath, ee);
            }
        }
        return jarUrl;
    }

    public static JarVisitor getVisitor(String jarPath, Filter[] filters) throws IllegalArgumentException {
        File file = new File(jarPath);
        if (file.isFile()) {
            return new InputStreamZippedJarVisitor(jarPath, filters);
        }
        return new ExplodedJarVisitor(jarPath, filters);
    }

    public static JarVisitor getVisitor(URL jarUrl, Filter[] filters) throws IllegalArgumentException {
        return JarVisitorFactory.getVisitor(jarUrl, filters, "");
    }

    public static JarVisitor getVisitor(URL jarUrl, Filter[] filters, String entry) throws IllegalArgumentException {
        String protocol = jarUrl.getProtocol();
        if ("jar".equals(protocol)) {
            return new JarProtocolVisitor(jarUrl, filters, entry);
        }
        if (StringHelper.isEmpty((String)protocol) || "file".equals(protocol)) {
            File file;
            try {
                String filePart = jarUrl.getFile();
                file = filePart != null && filePart.indexOf(32) != -1 ? new File(jarUrl.getFile()) : new File(jarUrl.toURI().getSchemeSpecificPart());
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException("Unable to visit JAR " + jarUrl + ". Cause: " + e.getMessage(), e);
            }
            if (file.isDirectory()) {
                return new ExplodedJarVisitor(jarUrl, filters, entry);
            }
            return new FileZippedJarVisitor(jarUrl, filters, entry);
        }
        return new InputStreamZippedJarVisitor(jarUrl, filters, entry);
    }

    public static byte[] getBytesFromInputStream(InputStream inputStream) throws IOException {
        int size;
        byte[] tmpByte = new byte[4096];
        byte[] entryBytes = new byte[]{};
        while ((size = inputStream.read(tmpByte)) != -1) {
            byte[] current = new byte[entryBytes.length + size];
            System.arraycopy(entryBytes, 0, current, 0, entryBytes.length);
            System.arraycopy(tmpByte, 0, current, entryBytes.length, size);
            entryBytes = current;
        }
        return entryBytes;
    }
}

