/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpa.criteria.compile;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.ParameterExpression;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.jpa.criteria.compile.CompilableCriteria;
import org.hibernate.jpa.criteria.compile.ImplicitParameterBinding;
import org.hibernate.jpa.criteria.compile.InterpretedParameterMetadata;
import org.hibernate.jpa.criteria.compile.RenderingContext;
import org.hibernate.jpa.spi.HibernateEntityManagerImplementor;
import org.hibernate.type.Type;

public class CriteriaCompiler
implements Serializable {
    private final HibernateEntityManagerImplementor entityManager;

    public CriteriaCompiler(HibernateEntityManagerImplementor entityManager) {
        this.entityManager = entityManager;
    }

    public Query compile(CompilableCriteria criteria) {
        criteria.validate();
        final HashMap explicitParameterMapping = new HashMap();
        final HashMap explicitParameterNameMapping = new HashMap();
        final ArrayList implicitParameterBindings = new ArrayList();
        final HashMap implicitParameterTypes = new HashMap();
        RenderingContext renderingContext = new RenderingContext(){
            private int aliasCount = 0;
            private int explicitParameterCount = 0;

            @Override
            public String generateAlias() {
                return "generatedAlias" + this.aliasCount++;
            }

            public String generateParameterName() {
                return "param" + this.explicitParameterCount++;
            }

            @Override
            public String registerExplicitParameter(ParameterExpression<?> criteriaQueryParameter) {
                String jpaqlParameterName;
                if (explicitParameterMapping.containsKey(criteriaQueryParameter)) {
                    jpaqlParameterName = (String)explicitParameterMapping.get(criteriaQueryParameter);
                } else {
                    jpaqlParameterName = this.generateParameterName();
                    explicitParameterMapping.put(criteriaQueryParameter, jpaqlParameterName);
                }
                if (StringHelper.isNotEmpty((String)criteriaQueryParameter.getName())) {
                    explicitParameterNameMapping.put(criteriaQueryParameter.getName(), criteriaQueryParameter);
                }
                return jpaqlParameterName;
            }

            @Override
            public String registerLiteralParameterBinding(final Object literal, final Class javaType) {
                final String parameterName = this.generateParameterName();
                ImplicitParameterBinding binding = new ImplicitParameterBinding(){

                    @Override
                    public String getParameterName() {
                        return parameterName;
                    }

                    @Override
                    public Class getJavaType() {
                        return javaType;
                    }

                    @Override
                    public void bind(TypedQuery typedQuery) {
                        typedQuery.setParameter(parameterName, literal);
                    }
                };
                implicitParameterBindings.add(binding);
                implicitParameterTypes.put(parameterName, javaType);
                return parameterName;
            }

            @Override
            public String getCastType(Class javaType) {
                SessionFactoryImplementor factory = (SessionFactoryImplementor)CriteriaCompiler.this.entityManager.getFactory().getSessionFactory();
                Type hibernateType = factory.getTypeResolver().heuristicType(javaType.getName());
                if (hibernateType == null) {
                    throw new IllegalArgumentException("Could not convert java type [" + javaType.getName() + "] to Hibernate type");
                }
                return hibernateType.getName();
            }
        };
        return criteria.interpret(renderingContext).buildCompiledQuery(this.entityManager, new InterpretedParameterMetadata(){

            @Override
            public Map<ParameterExpression<?>, String> explicitParameterMapping() {
                return explicitParameterMapping;
            }

            @Override
            public Map<String, ParameterExpression<?>> explicitParameterNameMapping() {
                return explicitParameterNameMapping;
            }

            @Override
            public List<ImplicitParameterBinding> implicitParameterBindings() {
                return implicitParameterBindings;
            }

            @Override
            public Map<String, Class> implicitParameterTypes() {
                return implicitParameterTypes;
            }
        });
    }
}

