/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpa.spi;

import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.persistence.CacheRetrieveMode;
import javax.persistence.CacheStoreMode;
import javax.persistence.FlushModeType;
import javax.persistence.Parameter;
import javax.persistence.Query;
import javax.persistence.TemporalType;
import org.hibernate.CacheMode;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.QueryParameterException;
import org.hibernate.jpa.QueryHints;
import org.hibernate.jpa.internal.EntityManagerMessageLogger;
import org.hibernate.jpa.internal.util.CacheModeHelper;
import org.hibernate.jpa.internal.util.ConfigurationHelper;
import org.hibernate.jpa.internal.util.LockModeTypeHelper;
import org.hibernate.jpa.spi.AbstractQueryImpl;
import org.hibernate.jpa.spi.HibernateEntityManagerImplementor;
import org.hibernate.jpa.spi.ParameterBind;
import org.hibernate.jpa.spi.ParameterRegistration;
import org.hibernate.procedure.NoSuchParameterException;
import org.hibernate.procedure.ParameterStrategyException;
import org.jboss.logging.Logger;

public abstract class BaseQueryImpl
implements Query {
    private static final EntityManagerMessageLogger LOG = (EntityManagerMessageLogger)Logger.getMessageLogger(EntityManagerMessageLogger.class, (String)AbstractQueryImpl.class.getName());
    private final HibernateEntityManagerImplementor entityManager;
    private int firstResult;
    private int maxResults = -1;
    private Map<String, Object> hints;
    private FlushModeType jpaFlushMode;
    private Set<ParameterRegistration<?>> parameterRegistrations;

    public BaseQueryImpl(HibernateEntityManagerImplementor entityManager) {
        this.entityManager = entityManager;
    }

    protected HibernateEntityManagerImplementor entityManager() {
        return this.entityManager;
    }

    protected void checkOpen(boolean markForRollbackIfClosed) {
        this.entityManager.checkOpen(markForRollbackIfClosed);
    }

    protected abstract void applyFirstResult(int var1);

    public BaseQueryImpl setFirstResult(int firstResult) {
        this.checkOpen(true);
        if (firstResult < 0) {
            throw new IllegalArgumentException("Negative value (" + firstResult + ") passed to setFirstResult");
        }
        this.firstResult = firstResult;
        this.applyFirstResult(firstResult);
        return this;
    }

    public int getFirstResult() {
        this.checkOpen(false);
        return this.firstResult;
    }

    protected abstract void applyMaxResults(int var1);

    public BaseQueryImpl setMaxResults(int maxResult) {
        this.checkOpen(true);
        if (maxResult < 0) {
            throw new IllegalArgumentException("Negative value (" + maxResult + ") passed to setMaxResults");
        }
        this.maxResults = maxResult;
        this.applyMaxResults(maxResult);
        return this;
    }

    public int getSpecifiedMaxResults() {
        return this.maxResults;
    }

    public int getMaxResults() {
        this.checkOpen(false);
        return this.maxResults == -1 ? Integer.MAX_VALUE : this.maxResults;
    }

    public Set<String> getSupportedHints() {
        return QueryHints.getDefinedHints();
    }

    public Map<String, Object> getHints() {
        this.checkOpen(false);
        return this.hints;
    }

    protected abstract boolean applyTimeoutHint(int var1);

    protected abstract boolean applyLockTimeoutHint(int var1);

    protected abstract boolean applyCommentHint(String var1);

    protected abstract boolean applyFetchSizeHint(int var1);

    protected abstract boolean applyCacheableHint(boolean var1);

    protected abstract boolean applyCacheRegionHint(String var1);

    protected abstract boolean applyReadOnlyHint(boolean var1);

    protected abstract boolean applyCacheModeHint(CacheMode var1);

    protected abstract boolean applyFlushModeHint(FlushMode var1);

    protected abstract boolean canApplyAliasSpecificLockModeHints();

    protected abstract void applyAliasSpecificLockModeHint(String var1, LockMode var2);

    public BaseQueryImpl setHint(String hintName, Object value) {
        this.checkOpen(true);
        boolean applied = false;
        try {
            if ("org.hibernate.timeout".equals(hintName)) {
                applied = this.applyTimeoutHint(ConfigurationHelper.getInteger(value));
            } else if ("javax.persistence.query.timeout".equals(hintName)) {
                int timeout = (int)Math.round(ConfigurationHelper.getInteger(value).doubleValue() / 1000.0);
                applied = this.applyTimeoutHint(timeout);
            } else if ("javax.persistence.lock.timeout".equals(hintName)) {
                applied = this.applyLockTimeoutHint(ConfigurationHelper.getInteger(value));
            } else if ("org.hibernate.comment".equals(hintName)) {
                applied = this.applyCommentHint((String)value);
            } else if ("org.hibernate.fetchSize".equals(hintName)) {
                applied = this.applyFetchSizeHint(ConfigurationHelper.getInteger(value));
            } else if ("org.hibernate.cacheable".equals(hintName)) {
                applied = this.applyCacheableHint(ConfigurationHelper.getBoolean(value));
            } else if ("org.hibernate.cacheRegion".equals(hintName)) {
                applied = this.applyCacheRegionHint((String)value);
            } else if ("org.hibernate.readOnly".equals(hintName)) {
                applied = this.applyReadOnlyHint(ConfigurationHelper.getBoolean(value));
            } else if ("org.hibernate.cacheMode".equals(hintName)) {
                applied = this.applyCacheModeHint(ConfigurationHelper.getCacheMode(value));
            } else if ("org.hibernate.flushMode".equals(hintName)) {
                applied = this.applyFlushModeHint(ConfigurationHelper.getFlushMode(value));
            } else if ("javax.persistence.cache.retrieveMode".equals(hintName)) {
                CacheStoreMode storeMode;
                CacheRetrieveMode retrieveMode = (CacheRetrieveMode)value;
                CacheStoreMode cacheStoreMode = storeMode = this.hints != null ? (CacheStoreMode)this.hints.get("javax.persistence.cache.storeMode") : null;
                if (storeMode == null) {
                    storeMode = (CacheStoreMode)this.entityManager.getProperties().get("javax.persistence.cache.storeMode");
                }
                applied = this.applyCacheModeHint(CacheModeHelper.interpretCacheMode(storeMode, retrieveMode));
            } else if ("javax.persistence.cache.storeMode".equals(hintName)) {
                CacheRetrieveMode retrieveMode;
                CacheStoreMode storeMode = (CacheStoreMode)value;
                CacheRetrieveMode cacheRetrieveMode = retrieveMode = this.hints != null ? (CacheRetrieveMode)this.hints.get("javax.persistence.cache.retrieveMode") : null;
                if (retrieveMode == null) {
                    retrieveMode = (CacheRetrieveMode)this.entityManager.getProperties().get("javax.persistence.cache.retrieveMode");
                }
                applied = this.applyCacheModeHint(CacheModeHelper.interpretCacheMode(storeMode, retrieveMode));
            } else if (hintName.startsWith("org.hibernate.lockMode")) {
                if (this.canApplyAliasSpecificLockModeHints()) {
                    String alias = hintName.substring("org.hibernate.lockMode".length() + 1);
                    try {
                        LockMode lockMode = LockModeTypeHelper.interpretLockMode(value);
                        this.applyAliasSpecificLockModeHint(alias, lockMode);
                    }
                    catch (Exception e) {
                        LOG.unableToDetermineLockModeValue(hintName, value);
                        applied = false;
                    }
                } else {
                    applied = false;
                }
            } else {
                LOG.ignoringUnrecognizedQueryHint(hintName);
            }
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Value for hint");
        }
        if (applied) {
            if (this.hints == null) {
                this.hints = new HashMap<String, Object>();
            }
            this.hints.put(hintName, value);
        } else {
            LOG.debugf("Skipping unsupported query hint [%s]", hintName);
        }
        return this;
    }

    public BaseQueryImpl setFlushMode(FlushModeType jpaFlushMode) {
        this.checkOpen(true);
        this.jpaFlushMode = jpaFlushMode;
        if (jpaFlushMode == FlushModeType.AUTO) {
            this.applyFlushModeHint(FlushMode.AUTO);
        } else if (jpaFlushMode == FlushModeType.COMMIT) {
            this.applyFlushModeHint(FlushMode.COMMIT);
        }
        return this;
    }

    protected FlushModeType getSpecifiedFlushMode() {
        return this.jpaFlushMode;
    }

    public FlushModeType getFlushMode() {
        this.checkOpen(false);
        return this.jpaFlushMode != null ? this.jpaFlushMode : this.entityManager.getFlushMode();
    }

    protected <X> ParameterRegistration<X> findParameterRegistration(Parameter<X> parameter) {
        if (ParameterRegistration.class.isInstance(parameter)) {
            ParameterRegistration reg = (ParameterRegistration)parameter;
            if (reg.getQuery() != this) {
                throw new IllegalArgumentException("Passed Parameter was from different Query");
            }
            return reg;
        }
        if (parameter.getName() != null) {
            return this.findParameterRegistration(parameter.getName());
        }
        if (parameter.getPosition() != null) {
            return this.findParameterRegistration(parameter.getPosition());
        }
        throw new IllegalArgumentException("Unable to resolve incoming parameter [" + parameter + "] to registration");
    }

    protected <X> ParameterRegistration<X> findParameterRegistration(String parameterName) {
        return (ParameterRegistration)this.getParameter(parameterName);
    }

    protected <X> ParameterRegistration<X> findParameterRegistration(int parameterPosition) {
        if (this.isJpaPositionalParameter(parameterPosition)) {
            return this.findParameterRegistration(Integer.toString(parameterPosition));
        }
        return (ParameterRegistration)this.getParameter(parameterPosition);
    }

    protected abstract boolean isJpaPositionalParameter(int var1);

    private Set<ParameterRegistration<?>> parameterRegistrations() {
        if (this.parameterRegistrations == null) {
            this.parameterRegistrations = new HashSet();
        }
        return this.parameterRegistrations;
    }

    protected void registerParameter(ParameterRegistration parameter) {
        if (parameter == null) {
            throw new IllegalArgumentException("parameter cannot be null");
        }
        if (this.parameterRegistrations().contains(parameter)) {
            LOG.debug("Parameter registered multiple times : " + parameter);
            return;
        }
        this.parameterRegistrations().add(parameter);
    }

    public <T> BaseQueryImpl setParameter(Parameter<T> param, T value) {
        this.checkOpen(true);
        try {
            this.findParameterRegistration(param).bindValue(value);
        }
        catch (QueryParameterException e) {
            this.entityManager().markForRollbackOnly();
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        catch (HibernateException he) {
            throw this.entityManager.convert(he);
        }
        return this;
    }

    public BaseQueryImpl setParameter(Parameter<Calendar> param, Calendar value, TemporalType temporalType) {
        this.checkOpen(true);
        try {
            this.findParameterRegistration(param).bindValue(value, temporalType);
        }
        catch (QueryParameterException e) {
            this.entityManager().markForRollbackOnly();
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        catch (HibernateException he) {
            throw this.entityManager.convert(he);
        }
        return this;
    }

    public BaseQueryImpl setParameter(Parameter<Date> param, Date value, TemporalType temporalType) {
        this.checkOpen(true);
        try {
            this.findParameterRegistration(param).bindValue(value, temporalType);
        }
        catch (QueryParameterException e) {
            this.entityManager().markForRollbackOnly();
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        catch (HibernateException he) {
            throw this.entityManager.convert(he);
        }
        return this;
    }

    public BaseQueryImpl setParameter(String name, Object value) {
        this.checkOpen(true);
        try {
            this.findParameterRegistration(name).bindValue(value);
        }
        catch (QueryParameterException e) {
            this.entityManager().markForRollbackOnly();
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        catch (HibernateException he) {
            throw this.entityManager.convert(he);
        }
        return this;
    }

    public BaseQueryImpl setParameter(String name, Calendar value, TemporalType temporalType) {
        this.checkOpen(true);
        try {
            this.findParameterRegistration(name).bindValue(value, temporalType);
        }
        catch (QueryParameterException e) {
            this.entityManager().markForRollbackOnly();
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        catch (HibernateException he) {
            throw this.entityManager.convert(he);
        }
        return this;
    }

    public BaseQueryImpl setParameter(String name, Date value, TemporalType temporalType) {
        this.checkOpen(true);
        try {
            this.findParameterRegistration(name).bindValue(value, temporalType);
        }
        catch (QueryParameterException e) {
            this.entityManager().markForRollbackOnly();
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        catch (HibernateException he) {
            throw this.entityManager.convert(he);
        }
        return this;
    }

    public BaseQueryImpl setParameter(int position, Object value) {
        this.checkOpen(true);
        try {
            this.findParameterRegistration(position).bindValue(value);
        }
        catch (QueryParameterException e) {
            this.entityManager().markForRollbackOnly();
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        catch (HibernateException he) {
            throw this.entityManager.convert(he);
        }
        return this;
    }

    public BaseQueryImpl setParameter(int position, Calendar value, TemporalType temporalType) {
        this.checkOpen(true);
        try {
            this.findParameterRegistration(position).bindValue(value, temporalType);
        }
        catch (QueryParameterException e) {
            this.entityManager().markForRollbackOnly();
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        catch (HibernateException he) {
            throw this.entityManager.convert(he);
        }
        return this;
    }

    public BaseQueryImpl setParameter(int position, Date value, TemporalType temporalType) {
        this.checkOpen(true);
        try {
            this.findParameterRegistration(position).bindValue(value, temporalType);
        }
        catch (ParameterStrategyException e) {
            this.entityManager().markForRollbackOnly();
            throw new IllegalArgumentException("Invalid mix of named and positional parameters", e);
        }
        catch (NoSuchParameterException e) {
            this.entityManager().markForRollbackOnly();
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        catch (QueryParameterException e) {
            this.entityManager().markForRollbackOnly();
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        catch (HibernateException he) {
            throw this.entityManager.convert(he);
        }
        return this;
    }

    public Set getParameters() {
        this.checkOpen(false);
        return this.parameterRegistrations();
    }

    public Parameter<?> getParameter(String name) {
        this.checkOpen(false);
        if (this.parameterRegistrations != null) {
            for (ParameterRegistration<?> param : this.parameterRegistrations) {
                if (!name.equals(param.getName())) continue;
                return param;
            }
        }
        throw new IllegalArgumentException("Parameter with that name [" + name + "] did not exist");
    }

    public <T> Parameter<T> getParameter(String name, Class<T> type) {
        this.checkOpen(false);
        Parameter<?> param = this.getParameter(name);
        if (param.getParameterType() != null && !param.getParameterType().isAssignableFrom(type)) {
            throw new IllegalArgumentException(String.format("Parameter type [%s] is not assignment compatible with requested type [%s] for parameter named [%s]", param.getParameterType().getName(), type.getName(), name));
        }
        return param;
    }

    public Parameter<?> getParameter(int position) {
        if (this.isJpaPositionalParameter(position)) {
            return this.getParameter(Integer.toString(position));
        }
        this.checkOpen(false);
        if (this.parameterRegistrations != null) {
            for (ParameterRegistration<?> param : this.parameterRegistrations) {
                if (param.getPosition() == null || position != param.getPosition()) continue;
                return param;
            }
        }
        throw new IllegalArgumentException("Parameter with that position [" + position + "] did not exist");
    }

    public <T> Parameter<T> getParameter(int position, Class<T> type) {
        this.checkOpen(false);
        Parameter<?> param = this.getParameter(position);
        if (param.getParameterType() != null && !param.getParameterType().isAssignableFrom(type)) {
            throw new IllegalArgumentException(String.format("Parameter type [%s] is not assignment compatible with requested type [%s] for parameter at position [%s]", param.getParameterType().getName(), type.getName(), position));
        }
        return param;
    }

    public boolean isBound(Parameter<?> param) {
        this.checkOpen(false);
        ParameterRegistration<?> registration = this.findParameterRegistration(param);
        return registration != null && registration.isBindable() && registration.getBind() != null;
    }

    public <T> T getParameterValue(Parameter<T> param) {
        this.checkOpen(false);
        ParameterRegistration<T> registration = this.findParameterRegistration(param);
        if (registration == null) {
            throw new IllegalArgumentException("Passed parameter [" + param + "] is not a (registered) parameter of this query");
        }
        if (!registration.isBindable()) {
            throw new IllegalStateException("Passed parameter [" + param + "] is not bindable");
        }
        ParameterBind<T> bind = registration.getBind();
        if (bind == null) {
            throw new IllegalStateException("Parameter [" + param + "] has not yet been bound");
        }
        return bind.getValue();
    }

    public Object getParameterValue(String name) {
        this.checkOpen(false);
        return this.getParameterValue(this.getParameter(name));
    }

    public Object getParameterValue(int position) {
        this.checkOpen(false);
        return this.getParameterValue(this.getParameter(position));
    }

    protected static void validateBinding(Class parameterType, Object bind, TemporalType temporalType) {
        if (bind == null || parameterType == null) {
            return;
        }
        if (Collection.class.isInstance(bind) && !Collection.class.isAssignableFrom(parameterType)) {
            BaseQueryImpl.validateCollectionValuedParameterBinding(parameterType, (Collection)bind, temporalType);
        } else if (bind.getClass().isArray()) {
            BaseQueryImpl.validateArrayValuedParameterBinding(parameterType, bind, temporalType);
        } else if (!BaseQueryImpl.isValidBindValue(parameterType, bind, temporalType)) {
            throw new IllegalArgumentException(String.format("Parameter value [%s] did not match expected type [%s (%s)]", bind, parameterType.getName(), BaseQueryImpl.extractName(temporalType)));
        }
    }

    private static String extractName(TemporalType temporalType) {
        return temporalType == null ? "n/a" : temporalType.name();
    }

    private static void validateCollectionValuedParameterBinding(Class parameterType, Collection value, TemporalType temporalType) {
        for (Object element : value) {
            if (BaseQueryImpl.isValidBindValue(parameterType, element, temporalType)) continue;
            throw new IllegalArgumentException(String.format("Parameter value element [%s] did not match expected type [%s (%s)]", element, parameterType.getName(), BaseQueryImpl.extractName(temporalType)));
        }
    }

    private static void validateArrayValuedParameterBinding(Class parameterType, Object value, TemporalType temporalType) {
        if (!parameterType.isArray()) {
            throw new IllegalArgumentException(String.format("Encountered array-valued parameter binding, but was expecting [%s (%s)]", parameterType.getName(), BaseQueryImpl.extractName(temporalType)));
        }
        if (value.getClass().getComponentType().isPrimitive()) {
            if (!parameterType.getComponentType().isAssignableFrom(value.getClass().getComponentType())) {
                throw new IllegalArgumentException(String.format("Primitive array-valued parameter bind value type [%s] did not match expected type [%s (%s)]", value.getClass().getComponentType().getName(), parameterType.getName(), BaseQueryImpl.extractName(temporalType)));
            }
        } else {
            Object[] array;
            for (Object element : array = (Object[])value) {
                if (BaseQueryImpl.isValidBindValue(parameterType.getComponentType(), element, temporalType)) continue;
                throw new IllegalArgumentException(String.format("Array-valued parameter value element [%s] did not match expected type [%s (%s)]", element, parameterType.getName(), BaseQueryImpl.extractName(temporalType)));
            }
        }
    }

    private static boolean isValidBindValue(Class expectedType, Object value, TemporalType temporalType) {
        if (expectedType.isInstance(value)) {
            return true;
        }
        if (temporalType != null) {
            boolean bindIsTemporal;
            boolean parameterDeclarationIsTemporal = Date.class.isAssignableFrom(expectedType) || Calendar.class.isAssignableFrom(expectedType);
            boolean bl = bindIsTemporal = Date.class.isInstance(value) || Calendar.class.isInstance(value);
            if (parameterDeclarationIsTemporal && bindIsTemporal) {
                return true;
            }
        }
        return false;
    }

    protected static class ParameterBindImpl<T>
    implements ParameterBind<T> {
        private final T value;
        private final TemporalType specifiedTemporalType;

        public ParameterBindImpl(T value, TemporalType specifiedTemporalType) {
            this.value = value;
            this.specifiedTemporalType = specifiedTemporalType;
        }

        @Override
        public T getValue() {
            return this.value;
        }

        @Override
        public TemporalType getSpecifiedTemporalType() {
            return this.specifiedTemporalType;
        }
    }
}

