/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpa.spi;

import java.util.Calendar;
import java.util.Date;
import java.util.Set;
import javax.persistence.FlushModeType;
import javax.persistence.LockModeType;
import javax.persistence.Parameter;
import javax.persistence.PersistenceException;
import javax.persistence.TemporalType;
import javax.persistence.TransactionRequiredException;
import javax.persistence.TypedQuery;
import org.hibernate.HibernateException;
import org.hibernate.TypeMismatchException;
import org.hibernate.hql.internal.QueryExecutionRequestException;
import org.hibernate.jpa.QueryHints;
import org.hibernate.jpa.spi.BaseQueryImpl;
import org.hibernate.jpa.spi.HibernateEntityManagerImplementor;

public abstract class AbstractQueryImpl<X>
extends BaseQueryImpl
implements TypedQuery<X> {
    private LockModeType jpaLockMode = LockModeType.NONE;

    public AbstractQueryImpl(HibernateEntityManagerImplementor entityManager) {
        super(entityManager);
    }

    protected HibernateEntityManagerImplementor getEntityManager() {
        return this.entityManager();
    }

    protected abstract int internalExecuteUpdate();

    public int executeUpdate() {
        this.checkOpen(true);
        try {
            if (!this.entityManager().isTransactionInProgress()) {
                this.entityManager().throwPersistenceException((PersistenceException)new TransactionRequiredException("Executing an update/delete query"));
                return 0;
            }
            return this.internalExecuteUpdate();
        }
        catch (QueryExecutionRequestException he) {
            throw new IllegalStateException(he);
        }
        catch (TypeMismatchException e) {
            throw new IllegalArgumentException(e);
        }
        catch (HibernateException he) {
            this.entityManager().throwPersistenceException(he);
            return 0;
        }
    }

    @Override
    public AbstractQueryImpl<X> setMaxResults(int maxResults) {
        return (AbstractQueryImpl)super.setMaxResults(maxResults);
    }

    @Override
    public AbstractQueryImpl<X> setFirstResult(int firstResult) {
        return (AbstractQueryImpl)super.setFirstResult(firstResult);
    }

    @Override
    public AbstractQueryImpl<X> setHint(String hintName, Object value) {
        super.setHint(hintName, value);
        return this;
    }

    @Override
    public Set<String> getSupportedHints() {
        return QueryHints.getDefinedHints();
    }

    public TypedQuery<X> setLockMode(LockModeType lockModeType) {
        this.checkOpen(true);
        if (this.isNativeSqlQuery()) {
            throw new IllegalStateException("Illegal attempt to set lock mode on a native SQL query");
        }
        if (!this.isSelectQuery()) {
            throw new IllegalStateException("Illegal attempt to set lock mode on a non-SELECT query");
        }
        if (!this.canApplyAliasSpecificLockModeHints()) {
            throw new IllegalStateException("Not a JPAQL/Criteria query");
        }
        this.jpaLockMode = lockModeType;
        this.internalApplyLockMode(lockModeType);
        return this;
    }

    public LockModeType getLockMode() {
        this.checkOpen(false);
        if (this.isNativeSqlQuery()) {
            throw new IllegalStateException("Illegal attempt to set lock mode on a native SQL query");
        }
        if (!this.isSelectQuery()) {
            throw new IllegalStateException("Illegal attempt to set lock mode on a non-SELECT query");
        }
        return this.jpaLockMode;
    }

    @Override
    public <T> AbstractQueryImpl<X> setParameter(Parameter<T> param, T value) {
        return (AbstractQueryImpl)super.setParameter((Parameter)param, (Object)value);
    }

    @Override
    public AbstractQueryImpl<X> setParameter(Parameter<Calendar> param, Calendar value, TemporalType temporalType) {
        return (AbstractQueryImpl)super.setParameter((Parameter)param, value, temporalType);
    }

    @Override
    public AbstractQueryImpl<X> setParameter(Parameter<Date> param, Date value, TemporalType temporalType) {
        return (AbstractQueryImpl)super.setParameter((Parameter)param, value, temporalType);
    }

    @Override
    public AbstractQueryImpl<X> setParameter(String name, Object value) {
        return (AbstractQueryImpl)super.setParameter(name, value);
    }

    @Override
    public AbstractQueryImpl<X> setParameter(String name, Calendar value, TemporalType temporalType) {
        return (AbstractQueryImpl)super.setParameter(name, value, temporalType);
    }

    @Override
    public AbstractQueryImpl<X> setParameter(String name, Date value, TemporalType temporalType) {
        return (AbstractQueryImpl)super.setParameter(name, value, temporalType);
    }

    @Override
    public AbstractQueryImpl<X> setParameter(int position, Object value) {
        return (AbstractQueryImpl)super.setParameter(position, value);
    }

    @Override
    public AbstractQueryImpl<X> setParameter(int position, Calendar value, TemporalType temporalType) {
        return (AbstractQueryImpl)super.setParameter(position, value, temporalType);
    }

    @Override
    public AbstractQueryImpl<X> setParameter(int position, Date value, TemporalType temporalType) {
        return (AbstractQueryImpl)super.setParameter(position, value, temporalType);
    }

    @Override
    public AbstractQueryImpl<X> setFlushMode(FlushModeType jpaFlushMode) {
        return (AbstractQueryImpl)super.setFlushMode(jpaFlushMode);
    }

    protected void checkTransaction() {
        if (this.jpaLockMode != null && this.jpaLockMode != LockModeType.NONE && !this.getEntityManager().isTransactionInProgress()) {
            throw new TransactionRequiredException("no transaction is in progress");
        }
    }
}

