/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpa.boot.internal;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import javax.persistence.AttributeConverter;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityNotFoundException;
import javax.persistence.PersistenceException;
import javax.persistence.spi.PersistenceUnitTransactionType;
import javax.sql.DataSource;
import org.hibernate.Interceptor;
import org.hibernate.SessionFactory;
import org.hibernate.SessionFactoryObserver;
import org.hibernate.boot.CacheRegionDefinition;
import org.hibernate.boot.MetadataBuilder;
import org.hibernate.boot.MetadataSources;
import org.hibernate.boot.SessionFactoryBuilder;
import org.hibernate.boot.archive.scan.internal.StandardScanOptions;
import org.hibernate.boot.archive.scan.spi.ScanEnvironment;
import org.hibernate.boot.archive.scan.spi.ScanOptions;
import org.hibernate.boot.cfgxml.internal.ConfigLoader;
import org.hibernate.boot.cfgxml.spi.LoadedConfig;
import org.hibernate.boot.model.TypeContributor;
import org.hibernate.boot.registry.BootstrapServiceRegistry;
import org.hibernate.boot.registry.BootstrapServiceRegistryBuilder;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.boot.registry.selector.StrategyRegistrationProvider;
import org.hibernate.boot.registry.selector.spi.StrategySelector;
import org.hibernate.boot.spi.MetadataImplementor;
import org.hibernate.cfg.AttributeConverterDefinition;
import org.hibernate.cfg.beanvalidation.BeanValidationIntegrator;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.transaction.internal.jdbc.JdbcTransactionFactory;
import org.hibernate.engine.transaction.internal.jta.CMTTransactionFactory;
import org.hibernate.id.factory.spi.MutableIdentifierGeneratorFactory;
import org.hibernate.integrator.spi.Integrator;
import org.hibernate.internal.log.DeprecationLogger;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.jpa.boot.internal.SettingsImpl;
import org.hibernate.jpa.boot.internal.StandardJpaScanEnvironmentImpl;
import org.hibernate.jpa.boot.spi.EntityManagerFactoryBuilder;
import org.hibernate.jpa.boot.spi.IntegratorProvider;
import org.hibernate.jpa.boot.spi.PersistenceUnitDescriptor;
import org.hibernate.jpa.boot.spi.StrategyRegistrationProviderList;
import org.hibernate.jpa.boot.spi.TypeContributorList;
import org.hibernate.jpa.event.spi.JpaIntegrator;
import org.hibernate.jpa.internal.EntityManagerFactoryImpl;
import org.hibernate.jpa.internal.EntityManagerMessageLogger;
import org.hibernate.jpa.internal.schemagen.JpaSchemaGenerator;
import org.hibernate.jpa.internal.util.LogHelper;
import org.hibernate.jpa.internal.util.PersistenceUnitTransactionTypeHelper;
import org.hibernate.jpa.spi.IdentifierGeneratorStrategyProvider;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.proxy.EntityNotFoundDelegate;
import org.hibernate.secure.spi.GrantedPermission;
import org.hibernate.secure.spi.JaccPermissionDeclarations;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.jboss.logging.Logger;

public class EntityManagerFactoryBuilderImpl
implements EntityManagerFactoryBuilder {
    private static final EntityManagerMessageLogger LOG = (EntityManagerMessageLogger)Logger.getMessageLogger(EntityManagerMessageLogger.class, (String)EntityManagerFactoryBuilderImpl.class.getName());
    public static final String INTEGRATOR_PROVIDER = "hibernate.integrator_provider";
    public static final String STRATEGY_REGISTRATION_PROVIDERS = "hibernate.strategy_registration_provider";
    public static final String TYPE_CONTRIBUTORS = "hibernate.type_contributors";
    public static final String JANDEX_INDEX = "hibernate.jandex_index";
    private final PersistenceUnitDescriptor persistenceUnit;
    private final Map configurationValues;
    private final StandardServiceRegistry standardServiceRegistry;
    private final MetadataImplementor metadata;
    private final SettingsImpl settings;
    private Object validatorFactory;
    private Object cdiBeanManager;
    private DataSource dataSource;

    public MetadataImplementor getMetadata() {
        return this.metadata;
    }

    public EntityManagerFactoryBuilderImpl(PersistenceUnitDescriptor persistenceUnit, Map integrationSettings) {
        this(persistenceUnit, integrationSettings, null);
    }

    public EntityManagerFactoryBuilderImpl(PersistenceUnitDescriptor persistenceUnit, Map integrationSettings, ClassLoader providedClassLoader) {
        LogHelper.logPersistenceUnitInformation(persistenceUnit);
        this.persistenceUnit = persistenceUnit;
        if (integrationSettings == null) {
            integrationSettings = Collections.emptyMap();
        }
        BootstrapServiceRegistry bsr = this.buildBootstrapServiceRegistry(integrationSettings, providedClassLoader);
        StandardServiceRegistryBuilder ssrBuilder = new StandardServiceRegistryBuilder(bsr);
        MergedSettings mergedSettings = this.mergeSettings(persistenceUnit, integrationSettings, ssrBuilder);
        this.configurationValues = mergedSettings.getConfigurationValues();
        ssrBuilder.applySettings(this.configurationValues);
        this.settings = this.configure(ssrBuilder);
        this.standardServiceRegistry = ssrBuilder.build();
        this.configure(this.standardServiceRegistry, mergedSettings);
        MetadataSources metadataSources = new MetadataSources((ServiceRegistry)bsr);
        List<AttributeConverterDefinition> attributeConverterDefinitions = this.populate(metadataSources, mergedSettings, this.standardServiceRegistry);
        MetadataBuilder metamodelBuilder = metadataSources.getMetadataBuilder(this.standardServiceRegistry);
        this.populate(metamodelBuilder, mergedSettings, this.standardServiceRegistry, attributeConverterDefinitions);
        this.metadata = (MetadataImplementor)metamodelBuilder.build();
        this.withValidatorFactory(this.configurationValues.get("javax.persistence.validation.factory"));
        boolean useClassTransformer = "true".equals(this.configurationValues.remove("hibernate.ejb.use_class_enhancer"));
        if (useClassTransformer) {
            persistenceUnit.pushClassTransformer(this.collectNamesOfClassesToEnhance(this.metadata));
        }
    }

    public Map getConfigurationValues() {
        return Collections.unmodifiableMap(this.configurationValues);
    }

    private BootstrapServiceRegistry buildBootstrapServiceRegistry(Map integrationSettings, ClassLoader providedClassLoader) {
        Object classLoadersSetting;
        ClassLoader classLoader;
        StrategyRegistrationProviderList strategyRegistrationProviderList;
        BootstrapServiceRegistryBuilder bsrBuilder = new BootstrapServiceRegistryBuilder();
        bsrBuilder.applyIntegrator((Integrator)new JpaIntegrator());
        IntegratorProvider integratorProvider = (IntegratorProvider)integrationSettings.get(INTEGRATOR_PROVIDER);
        if (integratorProvider != null) {
            for (Integrator integrator : integratorProvider.getIntegrators()) {
                bsrBuilder.applyIntegrator(integrator);
            }
        }
        if ((strategyRegistrationProviderList = (StrategyRegistrationProviderList)integrationSettings.get(STRATEGY_REGISTRATION_PROVIDERS)) != null) {
            for (StrategyRegistrationProvider strategyRegistrationProvider : strategyRegistrationProviderList.getStrategyRegistrationProviders()) {
                bsrBuilder.withStrategySelectors(strategyRegistrationProvider);
            }
        }
        if (this.persistenceUnit.getClassLoader() != null) {
            bsrBuilder.applyClassLoader(this.persistenceUnit.getClassLoader());
        }
        if (providedClassLoader != null) {
            bsrBuilder.applyClassLoader(providedClassLoader);
        }
        if ((classLoader = (ClassLoader)integrationSettings.get("hibernate.classLoader.application")) != null) {
            LOG.debugf("Found use of deprecated `%s` setting; use `%s` instead.", "hibernate.classLoader.application", "hibernate.classLoaders");
        }
        if ((classLoadersSetting = integrationSettings.get("hibernate.classLoaders")) != null) {
            if (Collection.class.isInstance(classLoadersSetting)) {
                for (ClassLoader classLoader2 : (Collection)classLoadersSetting) {
                    bsrBuilder.applyClassLoader(classLoader2);
                }
            } else if (classLoadersSetting.getClass().isArray()) {
                for (ClassLoader classLoader3 : (ClassLoader[])classLoadersSetting) {
                    bsrBuilder.applyClassLoader(classLoader3);
                }
            } else if (ClassLoader.class.isInstance(classLoadersSetting)) {
                bsrBuilder.applyClassLoader((ClassLoader)classLoadersSetting);
            }
        }
        return bsrBuilder.build();
    }

    private MergedSettings mergeSettings(PersistenceUnitDescriptor persistenceUnit, Map<?, ?> integrationSettings, StandardServiceRegistryBuilder ssrBuilder) {
        String cfgXmlResourceName2;
        MergedSettings mergedSettings = new MergedSettings();
        if (persistenceUnit.getProperties() != null) {
            mergedSettings.configurationValues.putAll(persistenceUnit.getProperties());
        }
        mergedSettings.configurationValues.put("hibernate.ejb.persistenceUnitName", persistenceUnit.getName());
        ConfigLoader configLoader = new ConfigLoader(ssrBuilder.getBootstrapServiceRegistry());
        String cfgXmlResourceName1 = (String)mergedSettings.configurationValues.remove("hibernate.ejb.cfgfile");
        if (StringHelper.isNotEmpty((String)cfgXmlResourceName1)) {
            LoadedConfig loadedCfg = configLoader.loadConfigXmlResource(cfgXmlResourceName1);
            this.processConfigXml(loadedCfg, mergedSettings, ssrBuilder);
        }
        if (StringHelper.isNotEmpty((String)(cfgXmlResourceName2 = (String)integrationSettings.get("hibernate.ejb.cfgfile")))) {
            integrationSettings.remove("hibernate.ejb.cfgfile");
            LoadedConfig loadedCfg = configLoader.loadConfigXmlResource(cfgXmlResourceName2);
            this.processConfigXml(loadedCfg, mergedSettings, ssrBuilder);
        }
        for (Map.Entry entry : integrationSettings.entrySet()) {
            if (entry.getKey() == null) continue;
            if (entry.getValue() == null) {
                mergedSettings.configurationValues.remove(entry.getKey());
                continue;
            }
            mergedSettings.configurationValues.put(entry.getKey(), entry.getValue());
        }
        if (!mergedSettings.configurationValues.containsKey("javax.persistence.validation.mode") && persistenceUnit.getValidationMode() != null) {
            mergedSettings.configurationValues.put("javax.persistence.validation.mode", persistenceUnit.getValidationMode());
        }
        if (!mergedSettings.configurationValues.containsKey("javax.persistence.sharedCache.mode") && persistenceUnit.getSharedCacheMode() != null) {
            mergedSettings.configurationValues.put("javax.persistence.sharedCache.mode", persistenceUnit.getSharedCacheMode());
        }
        String jaccContextId = (String)mergedSettings.configurationValues.get("hibernate.jacc_context_id");
        Iterator iterator = mergedSettings.configurationValues.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (entry.getValue() == null) {
                iterator.remove();
                break;
            }
            if (!String.class.isInstance(entry.getKey()) || !String.class.isInstance(entry.getValue())) continue;
            String keyString = (String)entry.getKey();
            String valueString = (String)entry.getValue();
            if (keyString.startsWith("hibernate.jacc")) {
                if (jaccContextId == null) {
                    LOG.debug("Found JACC permission grant [%s] in properties, but no JACC context id was specified; ignoring");
                    continue;
                }
                mergedSettings.getJaccPermissions(jaccContextId).addPermissionDeclaration(this.parseJaccConfigEntry(keyString, valueString));
                continue;
            }
            if (keyString.startsWith("hibernate.ejb.classcache")) {
                mergedSettings.addCacheRegionDefinition(this.parseCacheRegionDefinitionEntry(keyString.substring("hibernate.ejb.classcache".length() + 1), valueString, CacheRegionDefinition.CacheRegionType.ENTITY));
                continue;
            }
            if (!keyString.startsWith("hibernate.ejb.collectioncache")) continue;
            mergedSettings.addCacheRegionDefinition(this.parseCacheRegionDefinitionEntry(keyString.substring("hibernate.ejb.collectioncache".length() + 1), (String)entry.getValue(), CacheRegionDefinition.CacheRegionType.COLLECTION));
        }
        return mergedSettings;
    }

    private void processConfigXml(LoadedConfig loadedConfig, MergedSettings mergedSettings, StandardServiceRegistryBuilder ssrBuilder) {
        String sfName;
        if (!mergedSettings.configurationValues.containsKey("hibernate.session_factory_name") && (sfName = loadedConfig.getSessionFactoryName()) != null) {
            mergedSettings.configurationValues.put("hibernate.session_factory_name", sfName);
        }
        mergedSettings.configurationValues.putAll(loadedConfig.getConfigurationValues());
        ssrBuilder.configure(loadedConfig);
    }

    private GrantedPermission parseJaccConfigEntry(String keyString, String valueString) {
        try {
            int roleStart = "hibernate.jacc".length() + 1;
            String role = keyString.substring(roleStart, keyString.indexOf(46, roleStart));
            int classStart = roleStart + role.length() + 1;
            String clazz = keyString.substring(classStart, keyString.length());
            return new GrantedPermission(role, clazz, valueString);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.persistenceException("Illegal usage of hibernate.jacc: " + keyString);
        }
    }

    private CacheRegionDefinition parseCacheRegionDefinitionEntry(String role, String value, CacheRegionDefinition.CacheRegionType cacheType) {
        StringTokenizer params = new StringTokenizer(value, ";, ");
        if (!params.hasMoreTokens()) {
            StringBuilder error = new StringBuilder("Illegal usage of ");
            if (cacheType == CacheRegionDefinition.CacheRegionType.ENTITY) {
                error.append("hibernate.ejb.classcache").append(": ").append("hibernate.ejb.classcache");
            } else {
                error.append("hibernate.ejb.collectioncache").append(": ").append("hibernate.ejb.collectioncache");
            }
            error.append('.').append(role).append(' ').append(value).append(".  Was expecting configuration (usage[,region[,lazy]]), but found none");
            throw this.persistenceException(error.toString());
        }
        String usage = params.nextToken();
        String region = null;
        if (params.hasMoreTokens()) {
            region = params.nextToken();
        }
        boolean lazyProperty = true;
        if (cacheType == CacheRegionDefinition.CacheRegionType.ENTITY) {
            if (params.hasMoreTokens()) {
                lazyProperty = "all".equalsIgnoreCase(params.nextToken());
            }
        } else {
            lazyProperty = false;
        }
        return new CacheRegionDefinition(cacheType, role, usage, region, lazyProperty);
    }

    private SettingsImpl configure(StandardServiceRegistryBuilder ssrBuilder) {
        Object value;
        SettingsImpl settings = new SettingsImpl();
        this.applyJdbcConnectionProperties(ssrBuilder);
        this.applyTransactionProperties(ssrBuilder, settings);
        if ("true".equals(this.configurationValues.get("hibernate.transaction.flush_before_completion"))) {
            ssrBuilder.applySetting("hibernate.transaction.flush_before_completion", (Object)"false");
            LOG.definingFlushBeforeCompletionIgnoredInHem("hibernate.transaction.flush_before_completion");
        }
        if ((value = this.configurationValues.get("hibernate.ejb.discard_pc_on_close")) != null) {
            settings.setReleaseResourcesOnCloseEnabled("true".equals(value));
        }
        StrategySelector strategySelector = (StrategySelector)ssrBuilder.getBootstrapServiceRegistry().getService(StrategySelector.class);
        Object interceptorSetting = this.configurationValues.remove("hibernate.ejb.interceptor.session_scoped");
        if (interceptorSetting != null) {
            settings.setSessionInterceptorClass(this.loadSessionInterceptorClass(interceptorSetting, strategySelector));
        }
        return settings;
    }

    private void applyJdbcConnectionProperties(StandardServiceRegistryBuilder ssrBuilder) {
        if (this.dataSource != null) {
            ssrBuilder.applySetting("hibernate.connection.datasource", (Object)this.dataSource);
        } else if (this.persistenceUnit.getJtaDataSource() != null) {
            if (!ssrBuilder.getSettings().containsKey("hibernate.connection.datasource")) {
                ssrBuilder.applySetting("hibernate.connection.datasource", this.persistenceUnit.getJtaDataSource());
                this.configurationValues.put("javax.persistence.jtaDataSource", this.persistenceUnit.getJtaDataSource());
            }
        } else if (this.persistenceUnit.getNonJtaDataSource() != null) {
            if (!ssrBuilder.getSettings().containsKey("hibernate.connection.datasource")) {
                ssrBuilder.applySetting("hibernate.connection.datasource", this.persistenceUnit.getNonJtaDataSource());
                this.configurationValues.put("javax.persistence.nonJtaDataSource", this.persistenceUnit.getNonJtaDataSource());
            }
        } else {
            String pass;
            String user;
            String url;
            String driver = (String)this.configurationValues.get("javax.persistence.jdbc.driver");
            if (StringHelper.isNotEmpty((String)driver)) {
                ssrBuilder.applySetting("hibernate.connection.driver_class", (Object)driver);
            }
            if (StringHelper.isNotEmpty((String)(url = (String)this.configurationValues.get("javax.persistence.jdbc.url")))) {
                ssrBuilder.applySetting("hibernate.connection.url", (Object)url);
            }
            if (StringHelper.isNotEmpty((String)(user = (String)this.configurationValues.get("javax.persistence.jdbc.user")))) {
                ssrBuilder.applySetting("hibernate.connection.username", (Object)user);
            }
            if (StringHelper.isNotEmpty((String)(pass = (String)this.configurationValues.get("javax.persistence.jdbc.password")))) {
                ssrBuilder.applySetting("hibernate.connection.password", (Object)pass);
            }
        }
    }

    private void applyTransactionProperties(StandardServiceRegistryBuilder ssrBuilder, SettingsImpl settings) {
        PersistenceUnitTransactionType txnType = PersistenceUnitTransactionTypeHelper.interpretTransactionType(this.configurationValues.get("javax.persistence.transactionType"));
        if (txnType == null) {
            txnType = this.persistenceUnit.getTransactionType();
        }
        if (txnType == null) {
            txnType = PersistenceUnitTransactionType.RESOURCE_LOCAL;
        }
        settings.setTransactionType(txnType);
        boolean hasTxStrategy = this.configurationValues.containsKey("hibernate.transaction.factory_class");
        if (hasTxStrategy) {
            LOG.overridingTransactionStrategyDangerous("hibernate.transaction.factory_class");
        } else if (txnType == PersistenceUnitTransactionType.JTA) {
            ssrBuilder.applySetting("hibernate.transaction.factory_class", CMTTransactionFactory.class);
        } else if (txnType == PersistenceUnitTransactionType.RESOURCE_LOCAL) {
            ssrBuilder.applySetting("hibernate.transaction.factory_class", JdbcTransactionFactory.class);
        }
    }

    private Class<? extends Interceptor> loadSessionInterceptorClass(Object value, StrategySelector strategySelector) {
        if (value == null) {
            return null;
        }
        return Class.class.isInstance(value) ? (Class)value : strategySelector.selectStrategyImplementor(Interceptor.class, value.toString());
    }

    private void configure(StandardServiceRegistry ssr, MergedSettings mergedSettings) {
        StrategySelector strategySelector = (StrategySelector)ssr.getService(StrategySelector.class);
        Object idGeneratorStrategyProviderSetting = this.configurationValues.remove("hibernate.ejb.identifier_generator_strategy_provider");
        if (idGeneratorStrategyProviderSetting != null) {
            IdentifierGeneratorStrategyProvider idGeneratorStrategyProvider = (IdentifierGeneratorStrategyProvider)strategySelector.resolveStrategy(IdentifierGeneratorStrategyProvider.class, idGeneratorStrategyProviderSetting);
            MutableIdentifierGeneratorFactory identifierGeneratorFactory = (MutableIdentifierGeneratorFactory)ssr.getService(MutableIdentifierGeneratorFactory.class);
            if (identifierGeneratorFactory == null) {
                throw this.persistenceException("Application requested custom identifier generator strategies, but the MutableIdentifierGeneratorFactory could not be found");
            }
            for (Map.Entry<String, Class<?>> entry : idGeneratorStrategyProvider.getStrategies().entrySet()) {
                identifierGeneratorFactory.register(entry.getKey(), entry.getValue());
            }
        }
    }

    private List<AttributeConverterDefinition> populate(MetadataSources metadataSources, MergedSettings mergedSettings, StandardServiceRegistry ssr) {
        List explicitOrmXmlList;
        String explicitHbmXmls;
        ArrayList<AttributeConverterDefinition> attributeConverterDefinitions = null;
        List loadedAnnotatedClasses = (List)this.configurationValues.remove("hibernate.ejb.loaded.classes");
        if (loadedAnnotatedClasses != null) {
            for (String[] cls : loadedAnnotatedClasses) {
                if (AttributeConverter.class.isAssignableFrom((Class<?>)cls)) {
                    if (attributeConverterDefinitions == null) {
                        attributeConverterDefinitions = new ArrayList<AttributeConverterDefinition>();
                    }
                    attributeConverterDefinitions.add(AttributeConverterDefinition.from((Class)cls));
                    continue;
                }
                metadataSources.addAnnotatedClass((Class)cls);
            }
        }
        if ((explicitHbmXmls = (String)this.configurationValues.remove("hibernate.hbmxml.files")) != null) {
            for (String hbmXml : StringHelper.split((String)", ", (String)explicitHbmXmls)) {
                metadataSources.addResource(hbmXml);
            }
        }
        if ((explicitOrmXmlList = (List)this.configurationValues.remove("hibernate.ejb.xml_files")) != null) {
            for (String ormXml : explicitOrmXmlList) {
                metadataSources.addResource(ormXml);
            }
        }
        return attributeConverterDefinitions;
    }

    private void populate(MetadataBuilder metamodelBuilder, MergedSettings mergedSettings, StandardServiceRegistry ssr, List<AttributeConverterDefinition> attributeConverterDefinitions) {
        TypeContributorList typeContributorList;
        Object namingStrategySetting;
        if (this.persistenceUnit.getTempClassLoader() != null) {
            metamodelBuilder.applyTempClassLoader(this.persistenceUnit.getTempClassLoader());
        }
        metamodelBuilder.applyScanEnvironment((ScanEnvironment)new StandardJpaScanEnvironmentImpl(this.persistenceUnit));
        metamodelBuilder.applyScanOptions((ScanOptions)new StandardScanOptions((String)this.configurationValues.get("hibernate.archive.autodetection"), this.persistenceUnit.isExcludeUnlistedClasses()));
        if (mergedSettings.cacheRegionDefinitions != null) {
            for (CacheRegionDefinition localCacheRegionDefinition : mergedSettings.cacheRegionDefinitions) {
                metamodelBuilder.applyCacheRegionDefinition(localCacheRegionDefinition);
            }
        }
        if ((namingStrategySetting = this.configurationValues.remove("hibernate.ejb.naming_strategy")) != null) {
            DeprecationLogger.DEPRECATION_LOGGER.logDeprecatedNamingStrategySetting("hibernate.ejb.naming_strategy", "hibernate.implicit_naming_strategy", "hibernate.physical_naming_strategy");
        }
        if ((typeContributorList = (TypeContributorList)this.configurationValues.remove(TYPE_CONTRIBUTORS)) != null) {
            for (TypeContributor typeContributor : typeContributorList.getTypeContributors()) {
                metamodelBuilder.applyTypes(typeContributor);
            }
        }
        if (attributeConverterDefinitions != null) {
            for (AttributeConverterDefinition attributeConverterDefinition : attributeConverterDefinitions) {
                metamodelBuilder.applyAttributeConverter(attributeConverterDefinition);
            }
        }
    }

    private List<String> collectNamesOfClassesToEnhance(MetadataImplementor metadata) {
        ArrayList<String> entityClassNames = new ArrayList<String>();
        for (PersistentClass persistentClass : metadata.getEntityBindings()) {
            if (persistentClass.getClassName() == null) continue;
            entityClassNames.add(persistentClass.getClassName());
        }
        return entityClassNames;
    }

    @Override
    public EntityManagerFactoryBuilder withValidatorFactory(Object validatorFactory) {
        this.validatorFactory = validatorFactory;
        if (validatorFactory != null) {
            BeanValidationIntegrator.validateFactory((Object)validatorFactory);
        }
        return this;
    }

    @Override
    public EntityManagerFactoryBuilder withDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
        return this;
    }

    @Override
    public void cancel() {
    }

    @Override
    public void generateSchema() {
        try {
            SessionFactoryBuilder sfBuilder = this.metadata.getSessionFactoryBuilder();
            this.populate(sfBuilder, this.standardServiceRegistry);
            sfBuilder.build();
            JpaSchemaGenerator.performGeneration(this.metadata, this.configurationValues, this.standardServiceRegistry);
        }
        catch (Exception e) {
            throw this.persistenceException("Unable to build Hibernate SessionFactory", e);
        }
        this.cancel();
    }

    @Override
    public EntityManagerFactory build() {
        SessionFactoryImplementor sessionFactory;
        SessionFactoryBuilder sfBuilder = this.metadata.getSessionFactoryBuilder();
        this.populate(sfBuilder, this.standardServiceRegistry);
        try {
            sessionFactory = (SessionFactoryImplementor)sfBuilder.build();
        }
        catch (Exception e) {
            throw this.persistenceException("Unable to build Hibernate SessionFactory", e);
        }
        JpaSchemaGenerator.performGeneration(this.metadata, this.configurationValues, this.standardServiceRegistry);
        return new EntityManagerFactoryImpl(this.persistenceUnit.getName(), sessionFactory, this.metadata, this.settings, this.configurationValues);
    }

    private void populate(SessionFactoryBuilder sfBuilder, StandardServiceRegistry ssr) {
        Object sessionFactoryObserverSetting;
        StrategySelector strategySelector = (StrategySelector)ssr.getService(StrategySelector.class);
        Object sessionFactoryInterceptorSetting = this.configurationValues.remove("hibernate.ejb.interceptor");
        if (sessionFactoryInterceptorSetting != null) {
            Interceptor sessionFactoryInterceptor = (Interceptor)strategySelector.resolveStrategy(Interceptor.class, sessionFactoryInterceptorSetting);
            sfBuilder.applyInterceptor(sessionFactoryInterceptor);
        }
        if ((sessionFactoryObserverSetting = this.configurationValues.remove("hibernate.ejb.session_factory_observer")) != null) {
            SessionFactoryObserver suppliedSessionFactoryObserver = (SessionFactoryObserver)strategySelector.resolveStrategy(SessionFactoryObserver.class, sessionFactoryObserverSetting);
            sfBuilder.addSessionFactoryObservers(new SessionFactoryObserver[]{suppliedSessionFactoryObserver});
        }
        sfBuilder.addSessionFactoryObservers(new SessionFactoryObserver[]{ServiceRegistryCloser.INSTANCE});
        sfBuilder.applyEntityNotFoundDelegate((EntityNotFoundDelegate)JpaEntityNotFoundDelegate.INSTANCE);
        if (this.validatorFactory != null) {
            sfBuilder.applyValidatorFactory(this.validatorFactory);
        }
        if (this.cdiBeanManager != null) {
            sfBuilder.applyBeanManager(this.cdiBeanManager);
        }
    }

    private PersistenceException persistenceException(String message) {
        return this.persistenceException(message, null);
    }

    private PersistenceException persistenceException(String message, Exception cause) {
        return new PersistenceException(this.getExceptionHeader() + message, (Throwable)cause);
    }

    private String getExceptionHeader() {
        return "[PersistenceUnit: " + this.persistenceUnit.getName() + "] ";
    }

    public static class MergedSettings {
        private final Map configurationValues = new ConcurrentHashMap(16, 0.75f, 1);
        private Map<String, JaccPermissionDeclarations> jaccPermissionsByContextId;
        private List<CacheRegionDefinition> cacheRegionDefinitions;

        public Map getConfigurationValues() {
            return this.configurationValues;
        }

        public JaccPermissionDeclarations getJaccPermissions(String jaccContextId) {
            JaccPermissionDeclarations jaccPermissions;
            if (this.jaccPermissionsByContextId == null) {
                this.jaccPermissionsByContextId = new HashMap<String, JaccPermissionDeclarations>();
            }
            if ((jaccPermissions = this.jaccPermissionsByContextId.get(jaccContextId)) == null) {
                jaccPermissions = new JaccPermissionDeclarations(jaccContextId);
                this.jaccPermissionsByContextId.put(jaccContextId, jaccPermissions);
            }
            return jaccPermissions;
        }

        public void addCacheRegionDefinition(CacheRegionDefinition cacheRegionDefinition) {
            if (this.cacheRegionDefinitions == null) {
                this.cacheRegionDefinitions = new ArrayList<CacheRegionDefinition>();
            }
            this.cacheRegionDefinitions.add(cacheRegionDefinition);
        }
    }

    public static class ServiceRegistryCloser
    implements SessionFactoryObserver {
        public static final ServiceRegistryCloser INSTANCE = new ServiceRegistryCloser();

        public void sessionFactoryCreated(SessionFactory sessionFactory) {
        }

        public void sessionFactoryClosed(SessionFactory sessionFactory) {
            SessionFactoryImplementor sfi = (SessionFactoryImplementor)sessionFactory;
            sfi.getServiceRegistry().destroy();
            ServiceRegistry basicRegistry = sfi.getServiceRegistry().getParentServiceRegistry();
            ((ServiceRegistryImplementor)basicRegistry).destroy();
        }
    }

    private static class JpaEntityNotFoundDelegate
    implements EntityNotFoundDelegate,
    Serializable {
        public static final JpaEntityNotFoundDelegate INSTANCE = new JpaEntityNotFoundDelegate();

        private JpaEntityNotFoundDelegate() {
        }

        public void handleEntityNotFound(String entityName, Serializable id) {
            throw new EntityNotFoundException("Unable to find " + entityName + " with id " + id);
        }
    }
}

