/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.query.internal.impl;

import jakarta.persistence.NoResultException;
import jakarta.persistence.NonUniqueResultException;
import jakarta.persistence.criteria.JoinType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.CacheMode;
import org.hibernate.FlushMode;
import org.hibernate.Incubating;
import org.hibernate.LockMode;
import org.hibernate.envers.boot.internal.EnversService;
import org.hibernate.envers.configuration.internal.AuditEntitiesConfiguration;
import org.hibernate.envers.exception.AuditException;
import org.hibernate.envers.internal.entities.RelationDescription;
import org.hibernate.envers.internal.entities.mapper.id.IdMapper;
import org.hibernate.envers.internal.entities.mapper.relation.MiddleIdData;
import org.hibernate.envers.internal.reader.AuditReaderImplementor;
import org.hibernate.envers.internal.tools.query.Parameters;
import org.hibernate.envers.internal.tools.query.QueryBuilder;
import org.hibernate.envers.query.AuditAssociationQuery;
import org.hibernate.envers.query.criteria.AuditCriterion;
import org.hibernate.envers.query.criteria.internal.CriteriaTools;
import org.hibernate.envers.query.internal.impl.AuditQueryImplementor;
import org.hibernate.envers.query.order.AuditOrder;
import org.hibernate.envers.query.projection.AuditProjection;

@Incubating
public class AuditAssociationQueryImpl<Q extends AuditQueryImplementor>
implements AuditAssociationQuery<Q>,
AuditQueryImplementor {
    private final EnversService enversService;
    private final AuditReaderImplementor auditReader;
    private final Q parent;
    private final QueryBuilder queryBuilder;
    private final JoinType joinType;
    private final String entityName;
    private final IdMapper ownerAssociationIdMapper;
    private final String ownerAlias;
    private final String alias;
    private final Map<String, String> aliasToEntityNameMap;
    private final List<AuditCriterion> criterions = new ArrayList<AuditCriterion>();
    private final Parameters parameters;
    private final List<AuditAssociationQueryImpl<?>> associationQueries = new ArrayList();
    private final Map<String, AuditAssociationQueryImpl<AuditAssociationQueryImpl<Q>>> associationQueryMap = new HashMap<String, AuditAssociationQueryImpl<AuditAssociationQueryImpl<Q>>>();

    public AuditAssociationQueryImpl(EnversService enversService, AuditReaderImplementor auditReader, Q parent, QueryBuilder queryBuilder, String propertyName, JoinType joinType, Map<String, String> aliasToEntityNameMap, String ownerAlias, String userSuppliedAlias) {
        this.enversService = enversService;
        this.auditReader = auditReader;
        this.parent = parent;
        this.queryBuilder = queryBuilder;
        this.joinType = joinType;
        String ownerEntityName = aliasToEntityNameMap.get(ownerAlias);
        RelationDescription relationDescription = CriteriaTools.getRelatedEntity(enversService, ownerEntityName, propertyName);
        if (relationDescription == null) {
            throw new IllegalArgumentException("Property " + propertyName + " of entity " + ownerEntityName + " is not a valid association for queries");
        }
        this.entityName = relationDescription.getToEntityName();
        this.ownerAssociationIdMapper = relationDescription.getIdMapper();
        this.ownerAlias = ownerAlias;
        this.alias = userSuppliedAlias == null ? queryBuilder.generateAlias() : userSuppliedAlias;
        aliasToEntityNameMap.put(this.alias, this.entityName);
        this.aliasToEntityNameMap = aliasToEntityNameMap;
        this.parameters = queryBuilder.addParameters(this.alias);
    }

    @Override
    public String getAlias() {
        return this.alias;
    }

    @Override
    public List getResultList() throws AuditException {
        return this.parent.getResultList();
    }

    @Override
    public Object getSingleResult() throws AuditException, NonUniqueResultException, NoResultException {
        return this.parent.getSingleResult();
    }

    @Override
    public AuditAssociationQueryImpl<AuditAssociationQueryImpl<Q>> traverseRelation(String associationName, JoinType joinType) {
        return this.traverseRelation(associationName, joinType, null);
    }

    @Override
    public AuditAssociationQueryImpl<AuditAssociationQueryImpl<Q>> traverseRelation(String associationName, JoinType joinType, String alias) {
        AuditAssociationQueryImpl<AuditAssociationQueryImpl<Q>> result = this.associationQueryMap.get(associationName);
        if (result == null) {
            result = new AuditAssociationQueryImpl<AuditAssociationQueryImpl>(this.enversService, this.auditReader, this, this.queryBuilder, associationName, joinType, this.aliasToEntityNameMap, this.alias, alias);
            this.associationQueries.add(result);
            this.associationQueryMap.put(associationName, result);
        }
        return result;
    }

    @Override
    public AuditAssociationQueryImpl<Q> add(AuditCriterion criterion) {
        this.criterions.add(criterion);
        return this;
    }

    @Override
    public AuditAssociationQueryImpl<Q> addProjection(AuditProjection projection) {
        AuditProjection.ProjectionData projectionData = projection.getData(this.enversService);
        String projectionEntityAlias = projectionData.getAlias(this.alias);
        String projectionEntityName = this.aliasToEntityNameMap.get(projectionEntityAlias);
        String propertyName = CriteriaTools.determinePropertyName(this.enversService, this.auditReader, projectionEntityName, projectionData.getPropertyName());
        this.queryBuilder.addProjection(projectionData.getFunction(), projectionEntityAlias, propertyName, projectionData.isDistinct());
        this.registerProjection(projectionEntityName, projection);
        return this;
    }

    @Override
    public AuditAssociationQueryImpl<Q> addOrder(AuditOrder order) {
        AuditOrder.OrderData orderData = order.getData(this.enversService);
        String orderEntityAlias = orderData.getAlias(this.alias);
        String orderEntityName = this.aliasToEntityNameMap.get(orderEntityAlias);
        String propertyName = CriteriaTools.determinePropertyName(this.enversService, this.auditReader, orderEntityName, orderData.getPropertyName());
        this.queryBuilder.addOrder(orderEntityAlias, propertyName, orderData.isAscending());
        return this;
    }

    @Override
    public AuditAssociationQueryImpl<Q> setMaxResults(int maxResults) {
        this.parent.setMaxResults(maxResults);
        return this;
    }

    @Override
    public AuditAssociationQueryImpl<Q> setFirstResult(int firstResult) {
        this.parent.setFirstResult(firstResult);
        return this;
    }

    @Override
    public AuditAssociationQueryImpl<Q> setCacheable(boolean cacheable) {
        this.parent.setCacheable(cacheable);
        return this;
    }

    @Override
    public AuditAssociationQueryImpl<Q> setCacheRegion(String cacheRegion) {
        this.parent.setCacheRegion(cacheRegion);
        return this;
    }

    @Override
    public AuditAssociationQueryImpl<Q> setComment(String comment) {
        this.parent.setComment(comment);
        return this;
    }

    @Override
    public AuditAssociationQueryImpl<Q> setFlushMode(FlushMode flushMode) {
        this.parent.setFlushMode(flushMode);
        return this;
    }

    @Override
    public AuditAssociationQueryImpl<Q> setCacheMode(CacheMode cacheMode) {
        this.parent.setCacheMode(cacheMode);
        return this;
    }

    @Override
    public AuditAssociationQueryImpl<Q> setTimeout(int timeout) {
        this.parent.setTimeout(timeout);
        return this;
    }

    @Override
    public AuditAssociationQueryImpl<Q> setLockMode(LockMode lockMode) {
        this.parent.setLockMode(lockMode);
        return this;
    }

    @Override
    public Q up() {
        return this.parent;
    }

    protected void addCriterionsToQuery(AuditReaderImplementor versionsReader) {
        if (this.enversService.getEntitiesConfigurations().isVersioned(this.entityName)) {
            String auditEntityName = this.enversService.getAuditEntitiesConfiguration().getAuditEntityName(this.entityName);
            Parameters parameters = this.queryBuilder.addJoin(this.joinType, auditEntityName, this.alias, false);
            AuditEntitiesConfiguration verEntCfg = this.enversService.getAuditEntitiesConfiguration();
            String originalIdPropertyName = verEntCfg.getOriginalIdPropName();
            IdMapper idMapperTarget = this.enversService.getEntitiesConfigurations().get(this.entityName).getIdMapper();
            String prefix = this.alias.concat(".").concat(originalIdPropertyName);
            this.ownerAssociationIdMapper.addIdsEqualToQuery(parameters, this.ownerAlias, idMapperTarget, prefix);
            Parameters parametersToUse = this.parameters;
            String revisionPropertyPath = verEntCfg.getRevisionNumberPath();
            if (this.joinType == JoinType.LEFT) {
                parametersToUse = this.parameters.addSubParameters("or");
                parametersToUse.addNullRestriction(revisionPropertyPath, true);
                parametersToUse = parametersToUse.addSubParameters("and");
            }
            MiddleIdData referencedIdData = new MiddleIdData(verEntCfg, this.enversService.getEntitiesConfigurations().get(this.entityName).getIdMappingData(), null, this.entityName, this.enversService.getEntitiesConfigurations().isVersioned(this.entityName));
            this.enversService.getAuditStrategy().addEntityAtRevisionRestriction(this.enversService.getGlobalConfiguration(), this.queryBuilder, parametersToUse, revisionPropertyPath, verEntCfg.getRevisionEndFieldName(), true, referencedIdData, revisionPropertyPath, originalIdPropertyName, this.alias, this.queryBuilder.generateAlias(), true);
        } else {
            Parameters joinConditionParameters = this.queryBuilder.addJoin(this.joinType, this.entityName, this.alias, false);
            IdMapper idMapper = this.enversService.getEntitiesConfigurations().getNotVersionEntityConfiguration(this.entityName).getIdMapper();
            this.ownerAssociationIdMapper.addIdsEqualToQuery(joinConditionParameters, this.ownerAlias, idMapper, this.alias);
        }
        for (AuditCriterion auditCriterion : this.criterions) {
            auditCriterion.addToQuery(this.enversService, versionsReader, this.aliasToEntityNameMap, this.alias, this.queryBuilder, this.parameters);
        }
        for (AuditAssociationQueryImpl auditAssociationQueryImpl : this.associationQueries) {
            auditAssociationQueryImpl.addCriterionsToQuery(versionsReader);
        }
    }

    @Override
    public void registerProjection(String entityName, AuditProjection projection) {
        this.parent.registerProjection(entityName, projection);
    }
}

