/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.query.internal.impl;

import java.util.List;
import java.util.Set;
import org.hibernate.envers.boot.internal.EnversService;
import org.hibernate.envers.configuration.internal.AuditEntitiesConfiguration;
import org.hibernate.envers.internal.reader.AuditReaderImplementor;
import org.hibernate.envers.query.criteria.AuditCriterion;
import org.hibernate.envers.query.internal.impl.AbstractAuditQuery;
import org.hibernate.envers.query.internal.impl.AuditAssociationQueryImpl;
import org.hibernate.query.Query;

public class EntitiesModifiedAtRevisionQuery
extends AbstractAuditQuery {
    private final Number revision;

    public EntitiesModifiedAtRevisionQuery(EnversService enversService, AuditReaderImplementor versionsReader, Class<?> cls, Number revision) {
        super(enversService, versionsReader, cls);
        this.revision = revision;
    }

    public EntitiesModifiedAtRevisionQuery(EnversService enversService, AuditReaderImplementor versionsReader, Class<?> cls, String entityName, Number revision) {
        super(enversService, versionsReader, cls, entityName);
        this.revision = revision;
    }

    @Override
    public List list() {
        AuditEntitiesConfiguration verEntCfg = this.enversService.getAuditEntitiesConfiguration();
        String revisionPropertyPath = verEntCfg.getRevisionNumberPath();
        this.qb.getRootParameters().addWhereWithParam(revisionPropertyPath, "=", this.revision);
        for (AuditCriterion criterion : this.criterions) {
            criterion.addToQuery(this.enversService, this.versionsReader, this.aliasToEntityNameMap, "e__", this.qb, this.qb.getRootParameters());
        }
        for (AuditAssociationQueryImpl associationQuery : this.associationQueries) {
            associationQuery.addCriterionsToQuery(this.versionsReader);
        }
        Query query = this.buildQuery();
        Set params = query.getParameterMetadata().getNamedParameterNames();
        if (params.contains("revision")) {
            query.setParameter("revision", (Object)this.revision);
        }
        List queryResult = query.list();
        return this.applyProjections(queryResult, this.revision);
    }
}

