/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.configuration;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.DOMWriter;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.hibernate.MappingException;
import org.hibernate.annotations.common.reflection.ReflectionManager;
import org.hibernate.cfg.Configuration;
import org.hibernate.envers.configuration.AuditEntitiesConfiguration;
import org.hibernate.envers.configuration.GlobalConfiguration;
import org.hibernate.envers.configuration.PersistentClassGraphDefiner;
import org.hibernate.envers.configuration.metadata.AuditMetadataGenerator;
import org.hibernate.envers.configuration.metadata.EntityXmlMappingData;
import org.hibernate.envers.configuration.metadata.reader.AnnotationsMetadataReader;
import org.hibernate.envers.configuration.metadata.reader.ClassAuditingData;
import org.hibernate.envers.entities.EntitiesConfigurations;
import org.hibernate.envers.tools.StringTools;
import org.hibernate.envers.tools.graph.GraphTopologicalSort;
import org.hibernate.mapping.PersistentClass;

public class EntitiesConfigurator {
    public EntitiesConfigurations configure(Configuration cfg, ReflectionManager reflectionManager, GlobalConfiguration globalCfg, AuditEntitiesConfiguration verEntCfg, Document revisionInfoXmlMapping, Element revisionInfoRelationMapping) {
        AuditMetadataGenerator auditMetaGen = new AuditMetadataGenerator(cfg, globalCfg, verEntCfg, revisionInfoRelationMapping);
        DOMWriter writer = new DOMWriter();
        Iterator<PersistentClass> classes = GraphTopologicalSort.sort(new PersistentClassGraphDefiner(cfg)).iterator();
        HashMap<PersistentClass, ClassAuditingData> pcDatas = new HashMap<PersistentClass, ClassAuditingData>();
        HashMap<PersistentClass, EntityXmlMappingData> xmlMappings = new HashMap<PersistentClass, EntityXmlMappingData>();
        while (classes.hasNext()) {
            EntityXmlMappingData xmlMappingData;
            PersistentClass pc = classes.next();
            AnnotationsMetadataReader annotationsMetadataReader = new AnnotationsMetadataReader(globalCfg, reflectionManager, pc);
            ClassAuditingData auditData = annotationsMetadataReader.getAuditData();
            if (auditData.isAudited()) {
                pcDatas.put(pc, auditData);
                if (!StringTools.isEmpty(auditData.getAuditTable().value())) {
                    verEntCfg.addCustomAuditTableName(pc.getEntityName(), auditData.getAuditTable().value());
                }
                xmlMappingData = new EntityXmlMappingData();
                auditMetaGen.generateFirstPass(pc, auditData, xmlMappingData, true);
                xmlMappings.put(pc, xmlMappingData);
                continue;
            }
            xmlMappingData = new EntityXmlMappingData();
            auditMetaGen.generateFirstPass(pc, auditData, xmlMappingData, false);
            xmlMappings.put(pc, xmlMappingData);
        }
        for (Map.Entry pcDatasEntry : pcDatas.entrySet()) {
            EntityXmlMappingData xmlMappingData = (EntityXmlMappingData)xmlMappings.get(pcDatasEntry.getKey());
            auditMetaGen.generateSecondPass((PersistentClass)pcDatasEntry.getKey(), (ClassAuditingData)pcDatasEntry.getValue(), xmlMappingData);
            try {
                cfg.addDocument(writer.write(xmlMappingData.getMainXmlMapping()));
                for (Document additionalMapping : xmlMappingData.getAdditionalXmlMappings()) {
                    cfg.addDocument(writer.write(additionalMapping));
                }
            }
            catch (DocumentException e) {
                throw new MappingException((Throwable)e);
            }
        }
        if (pcDatas.size() > 0) {
            try {
                if (revisionInfoXmlMapping != null) {
                    cfg.addDocument(writer.write(revisionInfoXmlMapping));
                }
            }
            catch (DocumentException e) {
                throw new MappingException((Throwable)e);
            }
        }
        return new EntitiesConfigurations(auditMetaGen.getEntitiesConfigurations(), auditMetaGen.getNotAuditedEntitiesConfigurations());
    }

    private void writeDocument(Document e) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintWriter w = new PrintWriter(baos);
        try {
            XMLWriter xw = new XMLWriter((Writer)w, new OutputFormat(" ", true));
            xw.write(e);
            ((Writer)w).flush();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        System.out.println("-----------");
        System.out.println(baos.toString());
        System.out.println("-----------");
    }
}

