/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.configuration;

import java.util.Map;
import java.util.Properties;
import java.util.WeakHashMap;
import org.hibernate.MappingException;
import org.hibernate.annotations.common.reflection.ReflectionManager;
import org.hibernate.cfg.Configuration;
import org.hibernate.envers.configuration.AuditEntitiesConfiguration;
import org.hibernate.envers.configuration.EntitiesConfigurator;
import org.hibernate.envers.configuration.GlobalConfiguration;
import org.hibernate.envers.configuration.RevisionInfoConfiguration;
import org.hibernate.envers.configuration.RevisionInfoConfigurationResult;
import org.hibernate.envers.entities.EntitiesConfigurations;
import org.hibernate.envers.revisioninfo.RevisionInfoNumberReader;
import org.hibernate.envers.revisioninfo.RevisionInfoQueryCreator;
import org.hibernate.envers.strategy.AuditStrategy;
import org.hibernate.envers.synchronization.AuditProcessManager;

public class AuditConfiguration {
    private final GlobalConfiguration globalCfg;
    private final AuditEntitiesConfiguration auditEntCfg;
    private final AuditProcessManager auditProcessManager;
    private final AuditStrategy auditStrategy;
    private final EntitiesConfigurations entCfg;
    private final RevisionInfoQueryCreator revisionInfoQueryCreator;
    private final RevisionInfoNumberReader revisionInfoNumberReader;
    private static Map<Configuration, AuditConfiguration> cfgs = new WeakHashMap<Configuration, AuditConfiguration>();

    public AuditEntitiesConfiguration getAuditEntCfg() {
        return this.auditEntCfg;
    }

    public AuditProcessManager getSyncManager() {
        return this.auditProcessManager;
    }

    public GlobalConfiguration getGlobalCfg() {
        return this.globalCfg;
    }

    public EntitiesConfigurations getEntCfg() {
        return this.entCfg;
    }

    public RevisionInfoQueryCreator getRevisionInfoQueryCreator() {
        return this.revisionInfoQueryCreator;
    }

    public RevisionInfoNumberReader getRevisionInfoNumberReader() {
        return this.revisionInfoNumberReader;
    }

    public AuditStrategy getAuditStrategy() {
        return this.auditStrategy;
    }

    public AuditConfiguration(Configuration cfg) {
        Properties properties = cfg.getProperties();
        ReflectionManager reflectionManager = cfg.getReflectionManager();
        RevisionInfoConfiguration revInfoCfg = new RevisionInfoConfiguration();
        RevisionInfoConfigurationResult revInfoCfgResult = revInfoCfg.configure(cfg, reflectionManager);
        this.auditEntCfg = new AuditEntitiesConfiguration(properties, revInfoCfgResult.getRevisionInfoEntityName());
        this.globalCfg = new GlobalConfiguration(properties);
        this.auditProcessManager = new AuditProcessManager(revInfoCfgResult.getRevisionInfoGenerator());
        try {
            Class<?> auditStrategyClass = Thread.currentThread().getContextClassLoader().loadClass(this.auditEntCfg.getAuditStrategyName());
            this.auditStrategy = (AuditStrategy)auditStrategyClass.newInstance();
        }
        catch (Exception e) {
            throw new MappingException(String.format("Unable to create AuditStrategy[%s] instance.", this.auditEntCfg.getAuditStrategyName()));
        }
        this.revisionInfoQueryCreator = revInfoCfgResult.getRevisionInfoQueryCreator();
        this.revisionInfoNumberReader = revInfoCfgResult.getRevisionInfoNumberReader();
        this.entCfg = new EntitiesConfigurator().configure(cfg, reflectionManager, this.globalCfg, this.auditEntCfg, this.auditStrategy, revInfoCfgResult.getRevisionInfoXmlMapping(), revInfoCfgResult.getRevisionInfoRelationMapping());
    }

    public static synchronized AuditConfiguration getFor(Configuration cfg) {
        AuditConfiguration verCfg = cfgs.get(cfg);
        if (verCfg == null) {
            verCfg = new AuditConfiguration(cfg);
            cfgs.put(cfg, verCfg);
            cfg.buildMappings();
        }
        return verCfg;
    }
}

