/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers;

import javax.persistence.EntityManager;
import org.hibernate.Session;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.envers.AuditReader;
import org.hibernate.envers.event.EnversListener;
import org.hibernate.envers.exception.AuditException;
import org.hibernate.envers.reader.AuditReaderImpl;
import org.hibernate.event.EventType;
import org.hibernate.event.PostInsertEventListener;
import org.hibernate.service.event.spi.EventListenerRegistry;

public class AuditReaderFactory {
    private AuditReaderFactory() {
    }

    public static AuditReader get(Session session) throws AuditException {
        SessionImplementor sessionImpl = !(session instanceof SessionImplementor) ? (SessionImplementor)session.getSessionFactory().getCurrentSession() : (SessionImplementor)session;
        EventListenerRegistry listenerRegistry = (EventListenerRegistry)sessionImpl.getFactory().getServiceRegistry().getService(EventListenerRegistry.class);
        for (PostInsertEventListener listener : listenerRegistry.getEventListenerGroup(EventType.POST_INSERT).listeners()) {
            if (!(listener instanceof EnversListener)) continue;
            return new AuditReaderImpl(((EnversListener)listener).getAuditConfiguration(), session, sessionImpl);
        }
        throw new AuditException("Envers listeners were not properly registered");
    }

    public static AuditReader get(EntityManager entityManager) throws AuditException {
        if (entityManager.getDelegate() instanceof Session) {
            return AuditReaderFactory.get((Session)entityManager.getDelegate());
        }
        if (entityManager.getDelegate() instanceof EntityManager) {
            return AuditReaderFactory.get((EntityManager)entityManager.getDelegate());
        }
        throw new AuditException("Hibernate EntityManager not present!");
    }
}

