/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.revisioninfo;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.hibernate.envers.entities.PropertyData;
import org.hibernate.envers.tools.reflection.ReflectionTools;
import org.hibernate.property.Getter;

public class ModifiedEntityTypesReader {
    private final Getter modifiedEntityTypesGetter;

    public ModifiedEntityTypesReader(Class<?> revisionInfoClass, PropertyData modifiedEntityTypesData) {
        this.modifiedEntityTypesGetter = ReflectionTools.getGetter(revisionInfoClass, modifiedEntityTypesData);
    }

    public Set<Class> getModifiedEntityTypes(Object revisionEntity) {
        Set modifiedEntityClassNames = (Set)this.modifiedEntityTypesGetter.get(revisionEntity);
        if (modifiedEntityClassNames != null) {
            HashSet<Class> result = new HashSet<Class>(modifiedEntityClassNames.size());
            for (String entityClassName : modifiedEntityClassNames) {
                try {
                    result.add(Thread.currentThread().getContextClassLoader().loadClass(entityClassName));
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(e);
                }
            }
            return result;
        }
        return Collections.EMPTY_SET;
    }
}

