/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.entities.mapper.relation.lazy;

import java.io.Serializable;
import org.hibernate.HibernateException;
import org.hibernate.envers.configuration.AuditConfiguration;
import org.hibernate.envers.entities.EntitiesConfigurations;
import org.hibernate.envers.entities.mapper.relation.lazy.AbstractDelegateSessionImplementor;
import org.hibernate.envers.reader.AuditReaderImplementor;

public class ToOneDelegateSessionImplementor
extends AbstractDelegateSessionImplementor {
    private static final long serialVersionUID = 4770438372940785488L;
    private final AuditReaderImplementor versionsReader;
    private final Class<?> entityClass;
    private final Object entityId;
    private final Number revision;
    private EntitiesConfigurations entCfg;

    public ToOneDelegateSessionImplementor(AuditReaderImplementor versionsReader, Class<?> entityClass, Object entityId, Number revision, AuditConfiguration verCfg) {
        super(versionsReader.getSessionImplementor());
        this.versionsReader = versionsReader;
        this.entityClass = entityClass;
        this.entityId = entityId;
        this.revision = revision;
        this.entCfg = verCfg.getEntCfg();
    }

    @Override
    public Object doImmediateLoad(String entityName) throws HibernateException {
        if (this.entCfg.getNotVersionEntityConfiguration(entityName) == null) {
            return this.versionsReader.find(this.entityClass, entityName, this.entityId, this.revision);
        }
        return this.delegate.immediateLoad(entityName, (Serializable)this.entityId);
    }
}

